/*
 * Decompiled with CFR 0.152.
 */
package net.wedjaa.ansible.vault.crypto.data;

import java.util.Arrays;
import net.wedjaa.ansible.vault.crypto.data.VaultInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Logger logger = LoggerFactory.getLogger(Util.class);
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    protected static final String LINE_BREAK = "\n";
    protected static final String CHAR_ENCODING = "UTF-8";

    public static String join(String[] datalines) {
        return String.join((CharSequence)"", Arrays.asList(datalines));
    }

    public static byte[] unhex(String hexed) {
        int dataLen = hexed.length();
        byte[] output = new byte[dataLen / 2];
        for (int charIdx = 0; charIdx < dataLen; charIdx += 2) {
            output[charIdx / 2] = (byte)((Character.digit(hexed.charAt(charIdx), 16) << 4) + Character.digit(hexed.charAt(charIdx + 1), 16));
        }
        return output;
    }

    public static String hexit(byte[] unhexed) {
        return Util.hexit(unhexed, 80);
    }

    public static String hexit(byte[] unhexed, int lineLength) {
        String result = "";
        int colIdx = 0;
        for (byte val : unhexed) {
            result = result + String.format("%02x", val);
            if (lineLength <= 0 || ++colIdx < lineLength / 2) continue;
            result = result + LINE_BREAK;
            colIdx = 0;
        }
        return result;
    }

    public static VaultInfo getVaultInfo(String vaultData) {
        String infoString = vaultData.substring(0, vaultData.indexOf(LINE_BREAK));
        return new VaultInfo(infoString);
    }

    public static VaultInfo getVaultInfo(byte[] vaultData) {
        return Util.getVaultInfo(new String(vaultData));
    }

    public static String cleanupData(String vaultData) {
        return vaultData.substring(vaultData.indexOf(LINE_BREAK) + 1);
    }

    public static byte[] getVaultData(String vaultData) {
        String rawData = Util.join(Util.cleanupData(vaultData).split(LINE_BREAK));
        return Util.unhex(rawData);
    }

    public static byte[] getVaultData(byte[] vaultData) {
        String rawData = Util.join(Util.cleanupData(new String(vaultData)).split(LINE_BREAK));
        return Util.unhex(rawData);
    }
}

