/*
 * Decompiled with CFR 0.152.
 */
package com.tinder.scarlet.retry;

import com.tinder.scarlet.retry.BackoffStrategy;
import com.tinder.scarlet.retry.ExponentialBackoffStrategy;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0005\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0003*\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/tinder/scarlet/retry/ExponentialWithJitterBackoffStrategy;", "Lcom/tinder/scarlet/retry/BackoffStrategy;", "baseDurationMillis", "", "maxDurationMillis", "random", "Ljava/util/Random;", "(JJLjava/util/Random;)V", "getBaseDurationMillis", "()J", "exponentialBackoffRetryStrategy", "Lcom/tinder/scarlet/retry/ExponentialBackoffStrategy;", "getMaxDurationMillis", "backoffDurationMillisAt", "retryCount", "", "Lkotlin/ranges/ClosedRange;", "withJitter", "scarlet"})
public final class ExponentialWithJitterBackoffStrategy
implements BackoffStrategy {
    private final long baseDurationMillis;
    private final long maxDurationMillis;
    @NotNull
    private final Random random;
    @NotNull
    private final ExponentialBackoffStrategy exponentialBackoffRetryStrategy;

    public ExponentialWithJitterBackoffStrategy(long baseDurationMillis, long maxDurationMillis, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.baseDurationMillis = baseDurationMillis;
        this.maxDurationMillis = maxDurationMillis;
        this.random = random;
        this.exponentialBackoffRetryStrategy = new ExponentialBackoffStrategy(this.baseDurationMillis, this.maxDurationMillis);
    }

    public /* synthetic */ ExponentialWithJitterBackoffStrategy(long l, long l2, Random random, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            random = new Random();
        }
        this(l, l2, random);
    }

    public final long getBaseDurationMillis() {
        return this.baseDurationMillis;
    }

    public final long getMaxDurationMillis() {
        return this.maxDurationMillis;
    }

    @Override
    public long backoffDurationMillisAt(int retryCount) {
        long duration = this.exponentialBackoffRetryStrategy.backoffDurationMillisAt(retryCount);
        if (duration == this.maxDurationMillis) {
            return duration;
        }
        return this.withJitter(duration);
    }

    private final long withJitter(long $this$withJitter) {
        return this.random((ClosedRange<Long>)((ClosedRange)new LongRange(0L, $this$withJitter)));
    }

    private final long random(ClosedRange<Long> $this$random) {
        return (long)this.random.nextInt((int)(((Number)((Object)$this$random.getEndInclusive())).longValue() - ((Number)((Object)$this$random.getStart())).longValue())) + ((Number)((Object)$this$random.getStart())).longValue();
    }
}

