/*
 * Decompiled with CFR 0.152.
 */
package com.tinder.scarlet.retry;

import com.tinder.scarlet.retry.BackoffStrategy;
import kotlin.Metadata;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/tinder/scarlet/retry/ExponentialBackoffStrategy;", "Lcom/tinder/scarlet/retry/BackoffStrategy;", "initialDurationMillis", "", "maxDurationMillis", "(JJ)V", "getInitialDurationMillis", "()J", "getMaxDurationMillis", "backoffDurationMillisAt", "retryCount", "", "scarlet"})
public final class ExponentialBackoffStrategy
implements BackoffStrategy {
    private final long initialDurationMillis;
    private final long maxDurationMillis;

    public ExponentialBackoffStrategy(long initialDurationMillis, long maxDurationMillis) {
        this.initialDurationMillis = initialDurationMillis;
        this.maxDurationMillis = maxDurationMillis;
        boolean bl = this.initialDurationMillis > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "initialDurationMillis, " + this.getInitialDurationMillis() + ", must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.maxDurationMillis > 0L;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "maxDurationMillis, " + this.getMaxDurationMillis() + ", must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final long getInitialDurationMillis() {
        return this.initialDurationMillis;
    }

    public final long getMaxDurationMillis() {
        return this.maxDurationMillis;
    }

    @Override
    public long backoffDurationMillisAt(int retryCount) {
        return (long)Math.min((double)this.maxDurationMillis, (double)this.initialDurationMillis * Math.pow(2.0, retryCount));
    }
}

