/*
 * Decompiled with CFR 0.152.
 */
package com.tinder.scarlet.internal.servicemethod;

import com.tinder.scarlet.internal.connection.Connection;
import com.tinder.scarlet.internal.servicemethod.ServiceMethod;
import com.tinder.scarlet.internal.utils.RuntimePlatform;
import com.tinder.scarlet.ws.Receive;
import com.tinder.scarlet.ws.Send;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J!\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\u0010\rR \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/tinder/scarlet/internal/servicemethod/ServiceMethodExecutor;", "", "serviceMethods", "", "Ljava/lang/reflect/Method;", "Lcom/tinder/scarlet/internal/servicemethod/ServiceMethod;", "(Ljava/util/Map;)V", "getServiceMethods$scarlet", "()Ljava/util/Map;", "execute", "method", "args", "", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "Factory", "scarlet"})
public final class ServiceMethodExecutor {
    @NotNull
    private final Map<Method, ServiceMethod> serviceMethods;

    public ServiceMethodExecutor(@NotNull Map<Method, ? extends ServiceMethod> serviceMethods) {
        Intrinsics.checkNotNullParameter(serviceMethods, (String)"serviceMethods");
        this.serviceMethods = serviceMethods;
    }

    @NotNull
    public final Map<Method, ServiceMethod> getServiceMethods$scarlet() {
        return this.serviceMethods;
    }

    @NotNull
    public final Object execute(@NotNull Method method, @NotNull Object[] args) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ServiceMethod serviceMethod = this.serviceMethods.get(method);
        boolean bl = false;
        boolean bl2 = false;
        if (serviceMethod == null) {
            boolean bl3 = false;
            String string = "Service method not found";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ServiceMethod serviceMethod2 = serviceMethod;
        if ((serviceMethod = serviceMethod2) instanceof ServiceMethod.Send) {
            object = ((ServiceMethod.Send)serviceMethod2).execute(args[0]);
        } else if (serviceMethod instanceof ServiceMethod.Receive) {
            object = ((ServiceMethod.Receive)serviceMethod2).execute();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011H\u0002J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0016\u001a\u00020\u0015*\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/tinder/scarlet/internal/servicemethod/ServiceMethodExecutor$Factory;", "", "runtimePlatform", "Lcom/tinder/scarlet/internal/utils/RuntimePlatform;", "sendServiceMethodFactory", "Lcom/tinder/scarlet/internal/servicemethod/ServiceMethod$Send$Factory;", "receiveServiceMethodFactory", "Lcom/tinder/scarlet/internal/servicemethod/ServiceMethod$Receive$Factory;", "(Lcom/tinder/scarlet/internal/utils/RuntimePlatform;Lcom/tinder/scarlet/internal/servicemethod/ServiceMethod$Send$Factory;Lcom/tinder/scarlet/internal/servicemethod/ServiceMethod$Receive$Factory;)V", "create", "Lcom/tinder/scarlet/internal/servicemethod/ServiceMethodExecutor;", "serviceInterface", "Ljava/lang/Class;", "connection", "Lcom/tinder/scarlet/internal/connection/Connection;", "findServiceMethodFactory", "Lcom/tinder/scarlet/internal/servicemethod/ServiceMethod$Factory;", "", "findServiceMethods", "", "Ljava/lang/reflect/Method;", "Lcom/tinder/scarlet/internal/servicemethod/ServiceMethod;", "toServiceMethod", "scarlet"})
    public static final class Factory {
        @NotNull
        private final RuntimePlatform runtimePlatform;
        @NotNull
        private final ServiceMethod.Send.Factory sendServiceMethodFactory;
        @NotNull
        private final ServiceMethod.Receive.Factory receiveServiceMethodFactory;

        public Factory(@NotNull RuntimePlatform runtimePlatform, @NotNull ServiceMethod.Send.Factory sendServiceMethodFactory, @NotNull ServiceMethod.Receive.Factory receiveServiceMethodFactory) {
            Intrinsics.checkNotNullParameter((Object)runtimePlatform, (String)"runtimePlatform");
            Intrinsics.checkNotNullParameter((Object)sendServiceMethodFactory, (String)"sendServiceMethodFactory");
            Intrinsics.checkNotNullParameter((Object)receiveServiceMethodFactory, (String)"receiveServiceMethodFactory");
            this.runtimePlatform = runtimePlatform;
            this.sendServiceMethodFactory = sendServiceMethodFactory;
            this.receiveServiceMethodFactory = receiveServiceMethodFactory;
        }

        @NotNull
        public final ServiceMethodExecutor create(@NotNull Class<?> serviceInterface, @NotNull Connection connection) {
            Intrinsics.checkNotNullParameter(serviceInterface, (String)"serviceInterface");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Map<Method, ServiceMethod> serviceMethods = this.findServiceMethods(serviceInterface, connection);
            return new ServiceMethodExecutor(serviceMethods);
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Method, ServiceMethod> findServiceMethods(Class<?> $this$findServiceMethods, Connection connection) {
            void $this$mapTo$iv$iv;
            void $this$filterNotTo$iv$iv;
            Method[] methodArray = $this$findServiceMethods.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"declaredMethods");
            Object[] $this$filterNot$iv = methodArray;
            boolean $i$f$filterNot = false;
            Object[] objectArray = $this$filterNot$iv;
            Iterable<void> destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Method element$iv$iv : $this$filterNotTo$iv$iv) {
                Method it = element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (this.runtimePlatform.isDefaultMethod(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List methods = (List)destination$iv$iv;
            Iterable $this$map$iv = methods;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Method element$iv$iv;
                element$iv$iv = (Method)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                ServiceMethod serviceMethod = this.toServiceMethod((Method)it, connection);
                collection.add(serviceMethod);
            }
            List serviceMethods = (List)destination$iv$iv2;
            return MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)methods, (Iterable)serviceMethods));
        }

        /*
         * WARNING - void declaration
         */
        private final ServiceMethod toServiceMethod(Method $this$toServiceMethod, Connection connection) {
            void $this$mapNotNullTo$iv$iv;
            Annotation[] annotationArray = $this$toServiceMethod.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"annotations");
            Object[] $this$mapNotNull$iv = annotationArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var11_14 = $this$forEach$iv$iv$iv;
            int n = ((void)var11_14).length;
            for (int i = 0; i < n; ++i) {
                ServiceMethod.Factory factory;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var11_14[i];
                boolean bl = false;
                Annotation it = (Annotation)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (this.findServiceMethodFactory(it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                ServiceMethod.Factory it$iv$iv = factory;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List serviceMethodFactories = (List)destination$iv$iv;
            boolean bl = serviceMethodFactories.size() == 1;
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl) {
                boolean bl8 = false;
                String string = Intrinsics.stringPlus((String)"A method must have one and only one service method annotation: ", (Object)$this$toServiceMethod);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return ((ServiceMethod.Factory)CollectionsKt.first((List)serviceMethodFactories)).create(connection, $this$toServiceMethod);
        }

        private final ServiceMethod.Factory findServiceMethodFactory(Annotation $this$findServiceMethodFactory) {
            Annotation annotation = $this$findServiceMethodFactory;
            return annotation instanceof Send ? (ServiceMethod.Factory)this.sendServiceMethodFactory : (annotation instanceof Receive ? (ServiceMethod.Factory)this.receiveServiceMethodFactory : null);
        }
    }
}

