/*
 * Decompiled with CFR 0.152.
 */
package com.tinder.scarlet.internal.connection;

import com.tinder.StateMachine;
import com.tinder.scarlet.Event;
import com.tinder.scarlet.Lifecycle;
import com.tinder.scarlet.Message;
import com.tinder.scarlet.Session;
import com.tinder.scarlet.SideEffect;
import com.tinder.scarlet.State;
import com.tinder.scarlet.WebSocket;
import com.tinder.scarlet.internal.connection.Connection;
import com.tinder.scarlet.internal.connection.subscriber.LifecycleStateSubscriber;
import com.tinder.scarlet.internal.connection.subscriber.RetryTimerSubscriber;
import com.tinder.scarlet.internal.connection.subscriber.WebSocketEventSubscriber;
import com.tinder.scarlet.lifecycle.LifecycleRegistry;
import com.tinder.scarlet.retry.BackoffStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.processors.PublishProcessor;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/tinder/scarlet/internal/connection/Connection;", "", "stateManager", "Lcom/tinder/scarlet/internal/connection/Connection$StateManager;", "(Lcom/tinder/scarlet/internal/connection/Connection$StateManager;)V", "getStateManager", "()Lcom/tinder/scarlet/internal/connection/Connection$StateManager;", "observeEvent", "Lio/reactivex/Flowable;", "Lcom/tinder/scarlet/Event;", "send", "", "message", "Lcom/tinder/scarlet/Message;", "startForever", "", "Factory", "StateManager", "scarlet"})
public final class Connection {
    @NotNull
    private final StateManager stateManager;

    public Connection(@NotNull StateManager stateManager) {
        Intrinsics.checkNotNullParameter((Object)stateManager, (String)"stateManager");
        this.stateManager = stateManager;
    }

    @NotNull
    public final StateManager getStateManager() {
        return this.stateManager;
    }

    public final void startForever() {
        this.stateManager.subscribe();
    }

    @NotNull
    public final Flowable<Event> observeEvent() {
        return this.stateManager.observeEvent();
    }

    public final boolean send(@NotNull Message message) {
        State state;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        State state2 = state = this.stateManager.getState();
        return state2 instanceof State.Connected ? ((State.Connected)state).getSession$scarlet().getWebSocket().send(message) : false;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rJ\u0018\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001eH\u0002J\u0018\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001eH\u0002J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001bH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0006\u0010*\u001a\u00020\u001bJ\u0018\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030,0\u001eH\u0002J\f\u0010-\u001a\u00020\u001b*\u00020.H\u0002J\u0014\u0010/\u001a\u00020\u001b*\u0002002\u0006\u0010\u0013\u001a\u000201H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/tinder/scarlet/internal/connection/Connection$StateManager;", "", "lifecycle", "Lcom/tinder/scarlet/Lifecycle;", "webSocketFactory", "Lcom/tinder/scarlet/WebSocket$Factory;", "backoffStrategy", "Lcom/tinder/scarlet/retry/BackoffStrategy;", "scheduler", "Lio/reactivex/Scheduler;", "(Lcom/tinder/scarlet/Lifecycle;Lcom/tinder/scarlet/WebSocket$Factory;Lcom/tinder/scarlet/retry/BackoffStrategy;Lio/reactivex/Scheduler;)V", "eventProcessor", "Lio/reactivex/processors/PublishProcessor;", "Lcom/tinder/scarlet/Event;", "kotlin.jvm.PlatformType", "getLifecycle", "()Lcom/tinder/scarlet/Lifecycle;", "lifecycleStateSubscriber", "Lcom/tinder/scarlet/internal/connection/subscriber/LifecycleStateSubscriber;", "state", "Lcom/tinder/scarlet/State;", "getState", "()Lcom/tinder/scarlet/State;", "stateMachine", "Lcom/tinder/StateMachine;", "Lcom/tinder/scarlet/SideEffect;", "handleEvent", "", "event", "lifecycleStart", "Lcom/tinder/StateMachine$Matcher;", "Lcom/tinder/scarlet/Event$OnLifecycle$StateChange;", "lifecycleStop", "observeEvent", "Lio/reactivex/Flowable;", "open", "Lcom/tinder/scarlet/Session;", "requestNextLifecycleState", "scheduleRetry", "Lio/reactivex/disposables/Disposable;", "duration", "", "subscribe", "webSocketOpen", "Lcom/tinder/scarlet/Event$OnWebSocket$Event;", "cancelRetry", "Lcom/tinder/scarlet/State$WaitingToRetry;", "initiateShutdown", "Lcom/tinder/scarlet/State$Connected;", "Lcom/tinder/scarlet/Lifecycle$State;", "scarlet"})
    public static final class StateManager {
        @NotNull
        private final Lifecycle lifecycle;
        @NotNull
        private final WebSocket.Factory webSocketFactory;
        @NotNull
        private final BackoffStrategy backoffStrategy;
        @NotNull
        private final Scheduler scheduler;
        @NotNull
        private final LifecycleStateSubscriber lifecycleStateSubscriber;
        @NotNull
        private final PublishProcessor<Event> eventProcessor;
        @NotNull
        private final StateMachine<State, Event, SideEffect> stateMachine;

        public StateManager(@NotNull Lifecycle lifecycle, @NotNull WebSocket.Factory webSocketFactory, @NotNull BackoffStrategy backoffStrategy, @NotNull Scheduler scheduler) {
            Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
            Intrinsics.checkNotNullParameter((Object)webSocketFactory, (String)"webSocketFactory");
            Intrinsics.checkNotNullParameter((Object)backoffStrategy, (String)"backoffStrategy");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            this.lifecycle = lifecycle;
            this.webSocketFactory = webSocketFactory;
            this.backoffStrategy = backoffStrategy;
            this.scheduler = scheduler;
            this.lifecycleStateSubscriber = new LifecycleStateSubscriber(this);
            PublishProcessor publishProcessor = PublishProcessor.create();
            Intrinsics.checkNotNullExpressionValue((Object)publishProcessor, (String)"create<Event>()");
            this.eventProcessor = publishProcessor;
            this.stateMachine = StateMachine.Companion.create((Function1)new Function1<StateMachine.GraphBuilder<State, Event, SideEffect>, Unit>(this){
                final /* synthetic */ StateManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull StateMachine.GraphBuilder<State, Event, SideEffect> $this$create) {
                    StateMachine.Matcher.Companion this_$iv$iv;
                    StateMachine.GraphBuilder<State, Event, SideEffect> this_$iv;
                    Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                    StateMachine.GraphBuilder<State, Event, SideEffect> graphBuilder = $this$create;
                    Function1 init$iv = (Function1)new Function1<StateMachine.GraphBuilder.StateDefinitionBuilder<State.Disconnected>, Unit>(this.this$0){
                        final /* synthetic */ StateManager this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull StateMachine.GraphBuilder.StateDefinitionBuilder<State.Disconnected> $this$state) {
                            void this_$iv;
                            Intrinsics.checkNotNullParameter($this$state, (String)"$this$state");
                            $this$state.onEnter((Function2)new Function2<State.Disconnected, Event, Unit>(this.this$0){
                                final /* synthetic */ StateManager this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2);
                                }

                                public final void invoke(@NotNull State.Disconnected $this$onEnter, @NotNull Event it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$onEnter, (String)"$this$onEnter");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    StateManager.access$requestNextLifecycleState(this.this$0);
                                }
                            });
                            $this$state.on(StateManager.access$lifecycleStart(this.this$0), (Function2)new Function2<State.Disconnected, Event.OnLifecycle.StateChange<?>, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>(this.this$0, $this$state){
                                final /* synthetic */ StateManager this$0;
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.Disconnected> $this_state;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.Disconnected $this$on, @NotNull Event.OnLifecycle.StateChange<?> it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    Session webSocketSession = StateManager.access$open(this.this$0);
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.transitionTo$default(this.$this_state, (Object)$this$on, (Object)new State.Connecting(webSocketSession, 0), null, (int)2, null);
                                }
                            });
                            $this$state.on(StateManager.access$lifecycleStop(this.this$0), (Function2)new Function2<State.Disconnected, Event.OnLifecycle.StateChange<?>, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>(this.this$0, $this$state){
                                final /* synthetic */ StateManager this$0;
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.Disconnected> $this_state;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.Disconnected $this$on, @NotNull Event.OnLifecycle.StateChange<?> it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    StateManager.access$requestNextLifecycleState(this.this$0);
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.dontTransition$default(this.$this_state, (Object)$this$on, null, (int)1, null);
                                }
                            });
                            StateMachine.GraphBuilder.StateDefinitionBuilder<State.Disconnected> stateDefinitionBuilder = $this$state;
                            Function2 createTransitionTo$iv = (Function2)new Function2<State.Disconnected, Event.OnLifecycle.Terminate, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>($this$state){
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.Disconnected> $this_state;
                                {
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.Disconnected $this$on, @NotNull Event.OnLifecycle.Terminate it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.transitionTo$default(this.$this_state, (Object)$this$on, (Object)State.Destroyed.INSTANCE, null, (int)2, null);
                                }
                            };
                            boolean $i$f$on = false;
                            void var5_5 = this_$iv;
                            void var6_6 = this_$iv;
                            boolean $i$f$any = false;
                            StateMachine.Matcher.Companion this_$iv$iv$iv = StateMachine.Matcher.Companion;
                            boolean $i$f$any2 = false;
                            StateMachine.Matcher matcher = this_$iv$iv$iv.any(Event.OnLifecycle.Terminate.class);
                            var6_6.on(matcher, createTransitionTo$iv);
                        }
                    };
                    boolean $i$f$state = false;
                    StateMachine.Matcher.Companion companion = StateMachine.Matcher.Companion;
                    StateMachine.GraphBuilder<State, Event, SideEffect> graphBuilder2 = this_$iv;
                    boolean $i$f$any = false;
                    StateMachine.Matcher matcher = this_$iv$iv.any(State.Disconnected.class);
                    graphBuilder2.state(matcher, init$iv);
                    this_$iv = $this$create;
                    init$iv = (Function1)new Function1<StateMachine.GraphBuilder.StateDefinitionBuilder<State.WaitingToRetry>, Unit>(this.this$0){
                        final /* synthetic */ StateManager this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull StateMachine.GraphBuilder.StateDefinitionBuilder<State.WaitingToRetry> $this$state) {
                            StateMachine.GraphBuilder.StateDefinitionBuilder<State.WaitingToRetry> this_$iv;
                            Intrinsics.checkNotNullParameter($this$state, (String)"$this$state");
                            $this$state.onEnter((Function2)new Function2<State.WaitingToRetry, Event, Unit>(this.this$0){
                                final /* synthetic */ StateManager this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2);
                                }

                                public final void invoke(@NotNull State.WaitingToRetry $this$onEnter, @NotNull Event it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$onEnter, (String)"$this$onEnter");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    StateManager.access$requestNextLifecycleState(this.this$0);
                                }
                            });
                            StateMachine.GraphBuilder.StateDefinitionBuilder<State.WaitingToRetry> stateDefinitionBuilder = $this$state;
                            Function2 createTransitionTo$iv = (Function2)new Function2<State.WaitingToRetry, Event.OnRetry, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>(this.this$0, $this$state){
                                final /* synthetic */ StateManager this$0;
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.WaitingToRetry> $this_state;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.WaitingToRetry $this$on, @NotNull Event.OnRetry it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    Session webSocketSession = StateManager.access$open(this.this$0);
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.transitionTo$default(this.$this_state, (Object)$this$on, (Object)new State.Connecting(webSocketSession, $this$on.getRetryCount() + 1), null, (int)2, null);
                                }
                            };
                            boolean $i$f$on = false;
                            void var5_5 = this_$iv;
                            StateMachine.GraphBuilder.StateDefinitionBuilder<State.WaitingToRetry> stateDefinitionBuilder2 = this_$iv;
                            boolean $i$f$any = false;
                            StateMachine.Matcher.Companion this_$iv$iv$iv = StateMachine.Matcher.Companion;
                            boolean $i$f$any2 = false;
                            StateMachine.Matcher matcher = this_$iv$iv$iv.any(Event.OnRetry.class);
                            stateDefinitionBuilder2.on(matcher, createTransitionTo$iv);
                            $this$state.on(StateManager.access$lifecycleStart(this.this$0), (Function2)new Function2<State.WaitingToRetry, Event.OnLifecycle.StateChange<?>, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>(this.this$0, $this$state){
                                final /* synthetic */ StateManager this$0;
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.WaitingToRetry> $this_state;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.WaitingToRetry $this$on, @NotNull Event.OnLifecycle.StateChange<?> it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    StateManager.access$requestNextLifecycleState(this.this$0);
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.dontTransition$default(this.$this_state, (Object)$this$on, null, (int)1, null);
                                }
                            });
                            $this$state.on(StateManager.access$lifecycleStop(this.this$0), (Function2)new Function2<State.WaitingToRetry, Event.OnLifecycle.StateChange<?>, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>(this.this$0, $this$state){
                                final /* synthetic */ StateManager this$0;
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.WaitingToRetry> $this_state;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.WaitingToRetry $this$on, @NotNull Event.OnLifecycle.StateChange<?> it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    StateManager.access$cancelRetry(this.this$0, $this$on);
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.transitionTo$default(this.$this_state, (Object)$this$on, (Object)State.Disconnected.INSTANCE, null, (int)2, null);
                                }
                            });
                            this_$iv = $this$state;
                            createTransitionTo$iv = (Function2)new Function2<State.WaitingToRetry, Event.OnLifecycle.Terminate, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>(this.this$0, $this$state){
                                final /* synthetic */ StateManager this$0;
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.WaitingToRetry> $this_state;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.WaitingToRetry $this$on, @NotNull Event.OnLifecycle.Terminate it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    StateManager.access$cancelRetry(this.this$0, $this$on);
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.transitionTo$default(this.$this_state, (Object)$this$on, (Object)State.Destroyed.INSTANCE, null, (int)2, null);
                                }
                            };
                            $i$f$on = false;
                            StateMachine.GraphBuilder.StateDefinitionBuilder<State.WaitingToRetry> this_$iv$iv = this_$iv;
                            stateDefinitionBuilder2 = this_$iv;
                            $i$f$any = false;
                            this_$iv$iv$iv = StateMachine.Matcher.Companion;
                            $i$f$any2 = false;
                            matcher = this_$iv$iv$iv.any(Event.OnLifecycle.Terminate.class);
                            stateDefinitionBuilder2.on(matcher, createTransitionTo$iv);
                        }
                    };
                    $i$f$state = false;
                    this_$iv$iv = StateMachine.Matcher.Companion;
                    graphBuilder2 = this_$iv;
                    $i$f$any = false;
                    matcher = this_$iv$iv.any(State.WaitingToRetry.class);
                    graphBuilder2.state(matcher, init$iv);
                    this_$iv = $this$create;
                    init$iv = (Function1)new Function1<StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connecting>, Unit>(this.this$0){
                        final /* synthetic */ StateManager this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connecting> $this$state) {
                            void this_$iv;
                            Intrinsics.checkNotNullParameter($this$state, (String)"$this$state");
                            $this$state.on(StateManager.access$webSocketOpen(this.this$0), (Function2)new Function2<State.Connecting, Event.OnWebSocket.Event<?>, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>($this$state){
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connecting> $this_state;
                                {
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.Connecting $this$on, @NotNull Event.OnWebSocket.Event<?> it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.transitionTo$default(this.$this_state, (Object)$this$on, (Object)new State.Connected($this$on.getSession$scarlet()), null, (int)2, null);
                                }
                            });
                            StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connecting> stateDefinitionBuilder = $this$state;
                            Function2 createTransitionTo$iv = (Function2)new Function2<State.Connecting, Event.OnWebSocket.Terminate, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>(this.this$0, $this$state){
                                final /* synthetic */ StateManager this$0;
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connecting> $this_state;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.Connecting $this$on, @NotNull Event.OnWebSocket.Terminate it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    long backoffDuration = StateManager.access$getBackoffStrategy$p(this.this$0).backoffDurationMillisAt($this$on.getRetryCount());
                                    Disposable timerDisposable = StateManager.access$scheduleRetry(this.this$0, backoffDuration);
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.transitionTo$default(this.$this_state, (Object)$this$on, (Object)new State.WaitingToRetry(timerDisposable, $this$on.getRetryCount(), backoffDuration), null, (int)2, null);
                                }
                            };
                            boolean $i$f$on = false;
                            void var5_5 = this_$iv;
                            void var6_6 = this_$iv;
                            boolean $i$f$any = false;
                            StateMachine.Matcher.Companion this_$iv$iv$iv = StateMachine.Matcher.Companion;
                            boolean $i$f$any2 = false;
                            StateMachine.Matcher matcher = this_$iv$iv$iv.any(Event.OnWebSocket.Terminate.class);
                            var6_6.on(matcher, createTransitionTo$iv);
                        }
                    };
                    $i$f$state = false;
                    this_$iv$iv = StateMachine.Matcher.Companion;
                    graphBuilder2 = this_$iv;
                    $i$f$any = false;
                    matcher = this_$iv$iv.any(State.Connecting.class);
                    graphBuilder2.state(matcher, init$iv);
                    this_$iv = $this$create;
                    init$iv = (Function1)new Function1<StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connected>, Unit>(this.this$0){
                        final /* synthetic */ StateManager this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connected> $this$state) {
                            StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connected> this_$iv;
                            Intrinsics.checkNotNullParameter($this$state, (String)"$this$state");
                            $this$state.onEnter((Function2)new Function2<State.Connected, Event, Unit>(this.this$0){
                                final /* synthetic */ StateManager this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2);
                                }

                                public final void invoke(@NotNull State.Connected $this$onEnter, @NotNull Event it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$onEnter, (String)"$this$onEnter");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    StateManager.access$requestNextLifecycleState(this.this$0);
                                }
                            });
                            $this$state.on(StateManager.access$lifecycleStart(this.this$0), (Function2)new Function2<State.Connected, Event.OnLifecycle.StateChange<?>, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>(this.this$0, $this$state){
                                final /* synthetic */ StateManager this$0;
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connected> $this_state;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.Connected $this$on, @NotNull Event.OnLifecycle.StateChange<?> it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    StateManager.access$requestNextLifecycleState(this.this$0);
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.dontTransition$default(this.$this_state, (Object)$this$on, null, (int)1, null);
                                }
                            });
                            $this$state.on(StateManager.access$lifecycleStop(this.this$0), (Function2)new Function2<State.Connected, Event.OnLifecycle.StateChange<?>, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>(this.this$0, $this$state){
                                final /* synthetic */ StateManager this$0;
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connected> $this_state;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.Connected $this$on, @NotNull Event.OnLifecycle.StateChange<?> it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    StateManager.access$initiateShutdown(this.this$0, $this$on, it.getState());
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.transitionTo$default(this.$this_state, (Object)$this$on, (Object)State.Disconnecting.INSTANCE, null, (int)2, null);
                                }
                            });
                            StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connected> stateDefinitionBuilder = $this$state;
                            Function2 createTransitionTo$iv = (Function2)new Function2<State.Connected, Event.OnLifecycle.Terminate, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>($this$state){
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connected> $this_state;
                                {
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.Connected $this$on, @NotNull Event.OnLifecycle.Terminate it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    $this$on.getSession$scarlet().getWebSocket().cancel();
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.transitionTo$default(this.$this_state, (Object)$this$on, (Object)State.Destroyed.INSTANCE, null, (int)2, null);
                                }
                            };
                            boolean $i$f$on = false;
                            void var5_5 = this_$iv;
                            StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connected> stateDefinitionBuilder2 = this_$iv;
                            boolean $i$f$any = false;
                            StateMachine.Matcher.Companion this_$iv$iv$iv = StateMachine.Matcher.Companion;
                            boolean $i$f$any2 = false;
                            StateMachine.Matcher matcher = this_$iv$iv$iv.any(Event.OnLifecycle.Terminate.class);
                            stateDefinitionBuilder2.on(matcher, createTransitionTo$iv);
                            this_$iv = $this$state;
                            createTransitionTo$iv = (Function2)new Function2<State.Connected, Event.OnWebSocket.Terminate, StateMachine.Graph.State.TransitionTo<? extends State, ? extends SideEffect>>(this.this$0, $this$state){
                                final /* synthetic */ StateManager this$0;
                                final /* synthetic */ StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connected> $this_state;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_state = $this_state;
                                    super(2);
                                }

                                @NotNull
                                public final StateMachine.Graph.State.TransitionTo<State, SideEffect> invoke(@NotNull State.Connected $this$on, @NotNull Event.OnWebSocket.Terminate it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    long backoffDuration = StateManager.access$getBackoffStrategy$p(this.this$0).backoffDurationMillisAt(0);
                                    Disposable timerDisposable = StateManager.access$scheduleRetry(this.this$0, backoffDuration);
                                    return StateMachine.GraphBuilder.StateDefinitionBuilder.transitionTo$default(this.$this_state, (Object)$this$on, (Object)new State.WaitingToRetry(timerDisposable, 0, backoffDuration), null, (int)2, null);
                                }
                            };
                            $i$f$on = false;
                            StateMachine.GraphBuilder.StateDefinitionBuilder<State.Connected> this_$iv$iv = this_$iv;
                            stateDefinitionBuilder2 = this_$iv;
                            $i$f$any = false;
                            this_$iv$iv$iv = StateMachine.Matcher.Companion;
                            $i$f$any2 = false;
                            matcher = this_$iv$iv$iv.any(Event.OnWebSocket.Terminate.class);
                            stateDefinitionBuilder2.on(matcher, createTransitionTo$iv);
                        }
                    };
                    $i$f$state = false;
                    this_$iv$iv = StateMachine.Matcher.Companion;
                    graphBuilder2 = this_$iv;
                    $i$f$any = false;
                    matcher = this_$iv$iv.any(State.Connected.class);
                    graphBuilder2.state(matcher, init$iv);
                    this_$iv = $this$create;
                    init$iv = stateMachine.5.INSTANCE;
                    $i$f$state = false;
                    this_$iv$iv = StateMachine.Matcher.Companion;
                    graphBuilder2 = this_$iv;
                    $i$f$any = false;
                    matcher = this_$iv$iv.any(State.Disconnecting.class);
                    graphBuilder2.state(matcher, init$iv);
                    this_$iv = $this$create;
                    init$iv = (Function1)new Function1<StateMachine.GraphBuilder.StateDefinitionBuilder<State.Destroyed>, Unit>(this.this$0){
                        final /* synthetic */ StateManager this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull StateMachine.GraphBuilder.StateDefinitionBuilder<State.Destroyed> $this$state) {
                            Intrinsics.checkNotNullParameter($this$state, (String)"$this$state");
                            $this$state.onEnter((Function2)new Function2<State.Destroyed, Event, Unit>(this.this$0){
                                final /* synthetic */ StateManager this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2);
                                }

                                public final void invoke(@NotNull State.Destroyed $this$onEnter, @NotNull Event it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$onEnter, (String)"$this$onEnter");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    StateManager.access$getLifecycleStateSubscriber$p(this.this$0).dispose();
                                }
                            });
                        }
                    };
                    $i$f$state = false;
                    this_$iv$iv = StateMachine.Matcher.Companion;
                    graphBuilder2 = this_$iv;
                    $i$f$any = false;
                    matcher = this_$iv$iv.any(State.Destroyed.class);
                    graphBuilder2.state(matcher, init$iv);
                    $this$create.initialState((Object)State.Disconnected.INSTANCE);
                    $this$create.onTransition((Function1)new Function1<StateMachine.Transition<? extends State, ? extends Event, ? extends SideEffect>, Unit>(this.this$0){
                        final /* synthetic */ StateManager this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull StateMachine.Transition<? extends State, ? extends Event, SideEffect> transition) {
                            Intrinsics.checkNotNullParameter(transition, (String)"transition");
                            StateMachine.Transition<? extends State, ? extends Event, SideEffect> transition2 = transition;
                            StateManager stateManager = this.this$0;
                            boolean bl = false;
                            boolean bl2 = false;
                            StateMachine.Transition<? extends State, ? extends Event, SideEffect> it = transition2;
                            boolean bl3 = false;
                            if (it instanceof StateMachine.Transition.Valid && !Intrinsics.areEqual((Object)it.getFromState(), (Object)((StateMachine.Transition.Valid)it).getToState())) {
                                StateManager.access$getEventProcessor$p(stateManager).onNext(new Event.OnStateChange<State>(stateManager.getState()));
                            }
                        }
                    });
                }
            });
        }

        @NotNull
        public final Lifecycle getLifecycle() {
            return this.lifecycle;
        }

        @NotNull
        public final State getState() {
            return (State)this.stateMachine.getState();
        }

        @NotNull
        public final Flowable<Event> observeEvent() {
            Flowable flowable = this.eventProcessor.onBackpressureBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"eventProcessor.onBackpressureBuffer()");
            return flowable;
        }

        public final void subscribe() {
            this.lifecycle.subscribe((Subscriber)this.lifecycleStateSubscriber);
        }

        public final void handleEvent(@NotNull Event event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.eventProcessor.onNext((Object)event);
            this.stateMachine.transition((Object)event);
        }

        private final Session open() {
            WebSocket webSocket = this.webSocketFactory.create();
            WebSocketEventSubscriber subscriber = new WebSocketEventSubscriber(this);
            Flowable.fromPublisher((Publisher)((Publisher)webSocket.open())).observeOn(this.scheduler).cast(WebSocket.Event.class).subscribe((FlowableSubscriber)subscriber);
            return new Session(webSocket, (Disposable)subscriber);
        }

        private final Disposable scheduleRetry(long duration) {
            RetryTimerSubscriber retryTimerScheduler = new RetryTimerSubscriber(this);
            Flowable.timer((long)duration, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)this.scheduler).onBackpressureBuffer().subscribe((FlowableSubscriber)retryTimerScheduler);
            return (Disposable)retryTimerScheduler;
        }

        private final void requestNextLifecycleState() {
            this.lifecycleStateSubscriber.requestNext();
        }

        private final void initiateShutdown(State.Connected $this$initiateShutdown, Lifecycle.State state) {
            Lifecycle.State state2 = state;
            if (state2 instanceof Lifecycle.State.Stopped.WithReason) {
                $this$initiateShutdown.getSession$scarlet().getWebSocket().close(((Lifecycle.State.Stopped.WithReason)state).getShutdownReason());
            } else if (Intrinsics.areEqual((Object)state2, (Object)Lifecycle.State.Stopped.AndAborted.INSTANCE)) {
                $this$initiateShutdown.getSession$scarlet().getWebSocket().cancel();
            }
        }

        private final void cancelRetry(State.WaitingToRetry $this$cancelRetry) {
            $this$cancelRetry.getTimerDisposable$scarlet().dispose();
        }

        private final StateMachine.Matcher<Event, Event.OnLifecycle.StateChange<?>> lifecycleStart() {
            StateMachine.Matcher.Companion this_$iv = StateMachine.Matcher.Companion;
            boolean $i$f$any = false;
            return this_$iv.any(Event.OnLifecycle.StateChange.class).where((Function1)lifecycleStart.1.INSTANCE);
        }

        private final StateMachine.Matcher<Event, Event.OnLifecycle.StateChange<?>> lifecycleStop() {
            StateMachine.Matcher.Companion this_$iv = StateMachine.Matcher.Companion;
            boolean $i$f$any = false;
            return this_$iv.any(Event.OnLifecycle.StateChange.class).where((Function1)lifecycleStop.1.INSTANCE);
        }

        private final StateMachine.Matcher<Event, Event.OnWebSocket.Event<?>> webSocketOpen() {
            StateMachine.Matcher.Companion this_$iv = StateMachine.Matcher.Companion;
            boolean $i$f$any = false;
            return this_$iv.any(Event.OnWebSocket.Event.class).where((Function1)webSocketOpen.1.INSTANCE);
        }

        public static final /* synthetic */ void access$requestNextLifecycleState(StateManager $this) {
            $this.requestNextLifecycleState();
        }

        public static final /* synthetic */ StateMachine.Matcher access$lifecycleStart(StateManager $this) {
            return $this.lifecycleStart();
        }

        public static final /* synthetic */ Session access$open(StateManager $this) {
            return $this.open();
        }

        public static final /* synthetic */ StateMachine.Matcher access$lifecycleStop(StateManager $this) {
            return $this.lifecycleStop();
        }

        public static final /* synthetic */ void access$cancelRetry(StateManager $this, State.WaitingToRetry $receiver) {
            $this.cancelRetry($receiver);
        }

        public static final /* synthetic */ StateMachine.Matcher access$webSocketOpen(StateManager $this) {
            return $this.webSocketOpen();
        }

        public static final /* synthetic */ BackoffStrategy access$getBackoffStrategy$p(StateManager $this) {
            return $this.backoffStrategy;
        }

        public static final /* synthetic */ Disposable access$scheduleRetry(StateManager $this, long duration) {
            return $this.scheduleRetry(duration);
        }

        public static final /* synthetic */ void access$initiateShutdown(StateManager $this, State.Connected $receiver, Lifecycle.State state) {
            $this.initiateShutdown($receiver, state);
        }

        public static final /* synthetic */ LifecycleStateSubscriber access$getLifecycleStateSubscriber$p(StateManager $this) {
            return $this.lifecycleStateSubscriber;
        }

        public static final /* synthetic */ PublishProcessor access$getEventProcessor$p(StateManager $this) {
            return $this.eventProcessor;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/tinder/scarlet/internal/connection/Connection$Factory;", "", "lifecycle", "Lcom/tinder/scarlet/Lifecycle;", "webSocketFactory", "Lcom/tinder/scarlet/WebSocket$Factory;", "backoffStrategy", "Lcom/tinder/scarlet/retry/BackoffStrategy;", "scheduler", "Lio/reactivex/Scheduler;", "(Lcom/tinder/scarlet/Lifecycle;Lcom/tinder/scarlet/WebSocket$Factory;Lcom/tinder/scarlet/retry/BackoffStrategy;Lio/reactivex/Scheduler;)V", "sharedLifecycle", "getSharedLifecycle", "()Lcom/tinder/scarlet/Lifecycle;", "sharedLifecycle$delegate", "Lkotlin/Lazy;", "create", "Lcom/tinder/scarlet/internal/connection/Connection;", "createSharedLifecycle", "Lcom/tinder/scarlet/lifecycle/LifecycleRegistry;", "scarlet"})
    public static final class Factory {
        @NotNull
        private final Lifecycle lifecycle;
        @NotNull
        private final WebSocket.Factory webSocketFactory;
        @NotNull
        private final BackoffStrategy backoffStrategy;
        @NotNull
        private final Scheduler scheduler;
        @NotNull
        private final Lazy sharedLifecycle$delegate;

        public Factory(@NotNull Lifecycle lifecycle, @NotNull WebSocket.Factory webSocketFactory, @NotNull BackoffStrategy backoffStrategy, @NotNull Scheduler scheduler) {
            Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
            Intrinsics.checkNotNullParameter((Object)webSocketFactory, (String)"webSocketFactory");
            Intrinsics.checkNotNullParameter((Object)backoffStrategy, (String)"backoffStrategy");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            this.lifecycle = lifecycle;
            this.webSocketFactory = webSocketFactory;
            this.backoffStrategy = backoffStrategy;
            this.scheduler = scheduler;
            this.sharedLifecycle$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LifecycleRegistry>(this){
                final /* synthetic */ Factory this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final LifecycleRegistry invoke() {
                    return Factory.access$createSharedLifecycle(this.this$0);
                }
            }));
        }

        private final Lifecycle getSharedLifecycle() {
            Lazy lazy = this.sharedLifecycle$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (Lifecycle)lazy.getValue();
        }

        @NotNull
        public final Connection create() {
            StateManager stateManager = new StateManager(this.getSharedLifecycle(), this.webSocketFactory, this.backoffStrategy, this.scheduler);
            return new Connection(stateManager);
        }

        private final LifecycleRegistry createSharedLifecycle() {
            LifecycleRegistry lifecycleRegistry = new LifecycleRegistry(0L, 1, null);
            boolean bl = false;
            boolean bl2 = false;
            LifecycleRegistry $this$createSharedLifecycle_u24lambda_u2d0 = lifecycleRegistry;
            boolean bl3 = false;
            this.lifecycle.subscribe((Subscriber)$this$createSharedLifecycle_u24lambda_u2d0);
            return lifecycleRegistry;
        }

        public static final /* synthetic */ LifecycleRegistry access$createSharedLifecycle(Factory $this) {
            return $this.createSharedLifecycle();
        }
    }
}

