/*
 * Decompiled with CFR 0.152.
 */
package com.tinder.scarlet.internal;

import com.tinder.scarlet.internal.connection.Connection;
import com.tinder.scarlet.internal.servicemethod.ServiceMethodExecutor;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/tinder/scarlet/internal/Service;", "", "connection", "Lcom/tinder/scarlet/internal/connection/Connection;", "serviceMethodExecutor", "Lcom/tinder/scarlet/internal/servicemethod/ServiceMethodExecutor;", "(Lcom/tinder/scarlet/internal/connection/Connection;Lcom/tinder/scarlet/internal/servicemethod/ServiceMethodExecutor;)V", "execute", "method", "Ljava/lang/reflect/Method;", "args", "", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "startForever", "", "Factory", "scarlet"})
public final class Service {
    @NotNull
    private final Connection connection;
    @NotNull
    private final ServiceMethodExecutor serviceMethodExecutor;

    public Service(@NotNull Connection connection, @NotNull ServiceMethodExecutor serviceMethodExecutor) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)serviceMethodExecutor, (String)"serviceMethodExecutor");
        this.connection = connection;
        this.serviceMethodExecutor = serviceMethodExecutor;
    }

    public final void startForever() {
        this.connection.startForever();
    }

    @NotNull
    public final Object execute(@NotNull Method method, @NotNull Object[] args) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.serviceMethodExecutor.execute(method, args);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nJ\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/tinder/scarlet/internal/Service$Factory;", "", "connectionFactory", "Lcom/tinder/scarlet/internal/connection/Connection$Factory;", "serviceMethodExecutorFactory", "Lcom/tinder/scarlet/internal/servicemethod/ServiceMethodExecutor$Factory;", "(Lcom/tinder/scarlet/internal/connection/Connection$Factory;Lcom/tinder/scarlet/internal/servicemethod/ServiceMethodExecutor$Factory;)V", "create", "Lcom/tinder/scarlet/internal/Service;", "serviceInterface", "Ljava/lang/Class;", "validateService", "", "service", "scarlet"})
    public static final class Factory {
        @NotNull
        private final Connection.Factory connectionFactory;
        @NotNull
        private final ServiceMethodExecutor.Factory serviceMethodExecutorFactory;

        public Factory(@NotNull Connection.Factory connectionFactory, @NotNull ServiceMethodExecutor.Factory serviceMethodExecutorFactory) {
            Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
            Intrinsics.checkNotNullParameter((Object)serviceMethodExecutorFactory, (String)"serviceMethodExecutorFactory");
            this.connectionFactory = connectionFactory;
            this.serviceMethodExecutorFactory = serviceMethodExecutorFactory;
        }

        @NotNull
        public final Service create(@NotNull Class<?> serviceInterface) {
            Intrinsics.checkNotNullParameter(serviceInterface, (String)"serviceInterface");
            this.validateService(serviceInterface);
            Connection connection = this.connectionFactory.create();
            ServiceMethodExecutor serviceMethodExecutor = this.serviceMethodExecutorFactory.create(serviceInterface, connection);
            return new Service(connection, serviceMethodExecutor);
        }

        private final void validateService(Class<?> service) {
            boolean bl = service.isInterface();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Service declarations must be interfaces.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Object[] objectArray = service.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(objectArray, (String)"service.interfaces");
            objectArray = objectArray;
            bl2 = false;
            boolean bl5 = objectArray.length == 0;
            bl2 = false;
            bl3 = false;
            if (!bl5) {
                boolean bl6 = false;
                String string = "Service interfaces must not extend other interfaces.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }
}

