/*
 * Decompiled with CFR 0.152.
 */
package com.next.easynavigation.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;
import com.next.easynavigation.R;
import com.next.easynavigation.adapter.ViewPagerAdapter;
import com.next.easynavigation.utils.NavigationUtil;
import com.next.easynavigation.view.CustomViewPager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class EasyNavigationBar
extends LinearLayout {
    private RelativeLayout AddContainerLayout;
    private int tabCount = 0;
    private LinearLayout navigationLayout;
    private RelativeLayout contentView;
    private View lineView;
    private List<View> hintPointList = new ArrayList<View>();
    private List<TextView> msgPointList = new ArrayList<TextView>();
    private List<ImageView> imageViewList = new ArrayList<ImageView>();
    private List<TextView> textViewList = new ArrayList<TextView>();
    private List<View> tabList = new ArrayList<View>();
    private ViewPager mViewPager;
    private ViewPager2 mViewPager2;
    private ViewGroup addViewLayout;
    private String[] titleItems = new String[0];
    private int[] normalIconItems = new int[0];
    private int[] selectIconItems = new int[0];
    private List<Fragment> fragmentList = new ArrayList<Fragment>();
    private FragmentManager fragmentManager;
    private boolean smoothScroll = false;
    private int iconSize;
    private float hintPointSize;
    private float hintPointLeft;
    private float hintPointTop;
    private OnTabClickListener onTabClickListener;
    private OnCenterTabSelectListener onCenterTabClickListener;
    private OnTabLoadListener onTabLoadListener;
    private float msgPointTextSize;
    private float msgPointSize;
    private float msgPointMoreWidth;
    private float msgPointMoreHeight;
    private int msgPointMoreRadius;
    private int msgPointColor;
    private float msgPointLeft;
    private float msgPointTop;
    private float tabTextTop;
    private float tabTextSize;
    private int normalTextColor;
    private int selectTextColor;
    private float lineHeight;
    private int lineColor;
    private int navigationBackground;
    private float navigationHeight;
    private ImageView.ScaleType scaleType = ImageView.ScaleType.CENTER_INSIDE;
    private boolean canScroll;
    private ViewPagerAdapter adapter;
    private float centerIconSize;
    private float centerLayoutHeight = this.navigationHeight;
    private float centerLayoutBottomMargin;
    private int centerLayoutRule = 0;
    public static final int RULE_CENTER = 0;
    public static final int RULE_BOTTOM = 1;
    private boolean hasPadding;
    private int mode;
    private boolean centerAsFragment;
    private View customAddView;
    private float centerTextSize;
    private int centerNormalTextColor;
    private int centerSelectTextColor;
    private float centerTextTopMargin;
    private boolean centerAlignBottom;
    private ImageView centerImage;
    private View empty_line;
    private int contentType;
    private int centerImageRes;
    private String centerTextStr;
    private boolean onlyNavigation;
    private int currentPosition;
    private int tabContentRule;
    private int tabContentBottomMargin;
    private int textSizeType;
    private boolean isViewPager2;

    public EasyNavigationBar(Context context) {
        super(context);
        this.initViews(context, null);
    }

    public EasyNavigationBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initViews(context, attrs);
    }

    private void initViews(Context context, AttributeSet attrs) {
        this.defaultSetting();
        this.contentView = (RelativeLayout)View.inflate((Context)context, (int)R.layout.container_layout, null);
        this.addViewLayout = (ViewGroup)this.contentView.findViewById(R.id.add_view_ll);
        this.AddContainerLayout = (RelativeLayout)this.contentView.findViewById(R.id.add_rl);
        this.empty_line = this.contentView.findViewById(R.id.empty_line);
        this.navigationLayout = (LinearLayout)this.contentView.findViewById(R.id.navigation_ll);
        this.lineView = this.contentView.findViewById(R.id.common_horizontal_line);
        this.lineView.setTag((Object)-100);
        this.empty_line.setTag((Object)-100);
        this.navigationLayout.setTag((Object)-100);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.EasyNavigationBar);
        this.parseStyle(attributes);
        this.addView((View)this.contentView);
    }

    private void parseStyle(TypedArray attributes) {
        if (attributes != null) {
            this.textSizeType = attributes.getInt(R.styleable.EasyNavigationBar_Easy_textSizeType, this.textSizeType);
            this.msgPointColor = attributes.getColor(R.styleable.EasyNavigationBar_Easy_msgPointColor, this.msgPointColor);
            this.navigationHeight = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_navigationHeight, this.navigationHeight);
            this.navigationBackground = attributes.getColor(R.styleable.EasyNavigationBar_Easy_navigationBackground, this.navigationBackground);
            this.msgPointMoreWidth = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_msgPointMoreWidth, this.msgPointMoreWidth);
            this.msgPointMoreHeight = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_msgPointMoreHeight, this.msgPointMoreHeight);
            this.msgPointMoreRadius = attributes.getInt(R.styleable.EasyNavigationBar_Easy_msgPointMoreRadius, this.msgPointMoreRadius);
            this.tabTextSize = NavigationUtil.compareTo(this.getContext(), attributes.getDimension(R.styleable.EasyNavigationBar_Easy_tabTextSize, 0.0f), this.tabTextSize, this.textSizeType);
            this.tabTextTop = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_tabTextTop, this.tabTextTop);
            this.iconSize = (int)attributes.getDimension(R.styleable.EasyNavigationBar_Easy_tabIconSize, (float)this.iconSize);
            this.hintPointSize = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_hintPointSize, this.hintPointSize);
            this.msgPointSize = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_msgPointSize, this.msgPointSize);
            this.hintPointLeft = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_hintPointLeft, this.hintPointLeft);
            this.msgPointTop = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_msgPointTop, (float)(-this.iconSize * 3 / 5));
            this.hintPointTop = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_hintPointTop, this.hintPointTop);
            this.msgPointLeft = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_msgPointLeft, (float)(-this.iconSize / 2));
            this.msgPointTextSize = NavigationUtil.compareTo(this.getContext(), attributes.getDimension(R.styleable.EasyNavigationBar_Easy_msgPointTextSize, 0.0f), this.msgPointTextSize, this.textSizeType);
            this.centerIconSize = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_centerIconSize, this.centerIconSize);
            this.centerLayoutBottomMargin = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_centerLayoutBottomMargin, this.centerLayoutBottomMargin);
            this.centerSelectTextColor = attributes.getColor(R.styleable.EasyNavigationBar_Easy_centerSelectTextColor, this.centerSelectTextColor);
            this.centerNormalTextColor = attributes.getColor(R.styleable.EasyNavigationBar_Easy_centerNormalTextColor, this.centerNormalTextColor);
            this.centerTextSize = NavigationUtil.compareTo(this.getContext(), attributes.getDimension(R.styleable.EasyNavigationBar_Easy_centerTextSize, 0.0f), this.centerTextSize, this.textSizeType);
            this.centerTextTopMargin = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_centerTextTopMargin, this.centerTextTopMargin);
            this.centerAlignBottom = attributes.getBoolean(R.styleable.EasyNavigationBar_Easy_centerAlignBottom, this.centerAlignBottom);
            this.lineHeight = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_lineHeight, this.lineHeight);
            this.lineColor = attributes.getColor(R.styleable.EasyNavigationBar_Easy_lineColor, this.lineColor);
            this.centerLayoutHeight = attributes.getDimension(R.styleable.EasyNavigationBar_Easy_centerLayoutHeight, this.navigationHeight + this.lineHeight);
            this.normalTextColor = attributes.getColor(R.styleable.EasyNavigationBar_Easy_tabNormalColor, this.normalTextColor);
            this.selectTextColor = attributes.getColor(R.styleable.EasyNavigationBar_Easy_tabSelectColor, this.selectTextColor);
            int type = attributes.getInt(R.styleable.EasyNavigationBar_Easy_scaleType, 0);
            if (type == 0) {
                this.scaleType = ImageView.ScaleType.CENTER_INSIDE;
            } else if (type == 1) {
                this.scaleType = ImageView.ScaleType.CENTER_CROP;
            } else if (type == 2) {
                this.scaleType = ImageView.ScaleType.CENTER;
            } else if (type == 3) {
                this.scaleType = ImageView.ScaleType.FIT_CENTER;
            } else if (type == 4) {
                this.scaleType = ImageView.ScaleType.FIT_END;
            } else if (type == 5) {
                this.scaleType = ImageView.ScaleType.FIT_START;
            } else if (type == 6) {
                this.scaleType = ImageView.ScaleType.FIT_XY;
            } else if (type == 7) {
                this.scaleType = ImageView.ScaleType.MATRIX;
            }
            this.centerLayoutRule = attributes.getInt(R.styleable.EasyNavigationBar_Easy_centerLayoutRule, this.centerLayoutRule);
            this.hasPadding = attributes.getBoolean(R.styleable.EasyNavigationBar_Easy_hasPadding, this.hasPadding);
            this.centerAsFragment = attributes.getBoolean(R.styleable.EasyNavigationBar_Easy_centerAsFragment, this.centerAsFragment);
            attributes.recycle();
        }
    }

    public EasyNavigationBar setupWithViewPager(@NonNull ViewPager viewPager) {
        this.isViewPager2 = false;
        this.onlyNavigation = true;
        this.mViewPager = viewPager;
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                EasyNavigationBar.this.selectTab(position, EasyNavigationBar.this.smoothScroll, false);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        return this;
    }

    public EasyNavigationBar setupWithViewPager(@NonNull ViewPager2 viewPager2) {
        this.isViewPager2 = true;
        this.onlyNavigation = true;
        this.mViewPager2 = viewPager2;
        this.mViewPager2.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                super.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }

            public void onPageSelected(int position) {
                EasyNavigationBar.this.selectTab(position, EasyNavigationBar.this.smoothScroll, false);
                super.onPageSelected(position);
            }

            public void onPageScrollStateChanged(int state) {
                super.onPageScrollStateChanged(state);
            }
        });
        return this;
    }

    public void build() {
        if (this.centerLayoutHeight < this.navigationHeight + this.lineHeight) {
            this.centerLayoutHeight = this.navigationHeight + this.lineHeight;
        }
        if (this.centerLayoutRule == 0) {
            RelativeLayout.LayoutParams addLayoutParams = (RelativeLayout.LayoutParams)this.AddContainerLayout.getLayoutParams();
            addLayoutParams.height = (int)this.centerLayoutHeight;
            this.AddContainerLayout.setLayoutParams((ViewGroup.LayoutParams)addLayoutParams);
        } else if (this.centerLayoutRule == 1) {
            // empty if block
        }
        this.navigationLayout.setBackgroundColor(this.navigationBackground);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.navigationLayout.getLayoutParams();
        params.height = (int)this.navigationHeight;
        this.navigationLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        RelativeLayout.LayoutParams lineParams = (RelativeLayout.LayoutParams)this.lineView.getLayoutParams();
        lineParams.height = (int)this.lineHeight;
        this.lineView.setBackgroundColor(this.lineColor);
        this.lineView.setLayoutParams((ViewGroup.LayoutParams)lineParams);
        if (this.centerTextSize == 0.0f) {
            this.centerTextSize = this.tabTextSize;
        }
        if (this.centerNormalTextColor == 0) {
            this.centerNormalTextColor = this.normalTextColor;
        }
        if (this.centerSelectTextColor == 0) {
            this.centerSelectTextColor = this.selectTextColor;
        }
        if (!this.checkCanBuild()) {
            return;
        }
        switch (this.mode) {
            case 0: {
                this.buildNavigation();
                break;
            }
            case 1: {
                this.buildAddNavigation();
                break;
            }
            case 2: {
                this.buildAddViewNavigation();
                break;
            }
            default: {
                this.buildNavigation();
            }
        }
    }

    public EasyNavigationBar defaultSetting() {
        this.titleItems = new String[0];
        this.normalIconItems = new int[0];
        this.selectIconItems = new int[0];
        this.fragmentList = new ArrayList<Fragment>();
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
        this.mViewPager2 = null;
        this.smoothScroll = false;
        this.iconSize = NavigationUtil.sp2px(this.getContext(), 22.0f);
        this.hintPointSize = NavigationUtil.sp2px(this.getContext(), 6.0f);
        this.hintPointLeft = NavigationUtil.dip2px(this.getContext(), -3.0f);
        this.hintPointTop = NavigationUtil.dip2px(this.getContext(), -3.0f);
        this.msgPointTextSize = 11.0f;
        this.msgPointSize = NavigationUtil.dip2px(this.getContext(), 16.0f);
        this.msgPointLeft = NavigationUtil.dip2px(this.getContext(), -10.0f);
        this.msgPointTop = NavigationUtil.dip2px(this.getContext(), -12.0f);
        this.tabTextTop = NavigationUtil.dip2px(this.getContext(), 2.0f);
        this.tabTextSize = 12.0f;
        this.normalTextColor = Color.parseColor((String)"#666666");
        this.selectTextColor = Color.parseColor((String)"#333333");
        this.lineHeight = 1.0f;
        this.lineColor = Color.parseColor((String)"#f7f7f7");
        this.navigationBackground = Color.parseColor((String)"#ffffff");
        this.navigationHeight = NavigationUtil.dip2px(this.getContext(), 60.0f);
        this.scaleType = ImageView.ScaleType.CENTER_INSIDE;
        this.canScroll = false;
        this.centerIconSize = 0.0f;
        this.centerLayoutHeight = this.navigationHeight;
        this.centerLayoutBottomMargin = NavigationUtil.dip2px(this.getContext(), 10.0f);
        this.centerLayoutRule = 0;
        this.hasPadding = true;
        this.mode = 0;
        this.centerAsFragment = false;
        this.centerTextSize = 0.0f;
        this.centerNormalTextColor = 0;
        this.centerSelectTextColor = 0;
        this.centerTextTopMargin = NavigationUtil.dip2px(this.getContext(), 3.0f);
        this.centerAlignBottom = false;
        this.contentType = 0;
        this.centerTextStr = "";
        this.onTabClickListener = null;
        this.onCenterTabClickListener = null;
        this.onTabClickListener = null;
        this.tabContentRule = 0;
        this.tabContentBottomMargin = 0;
        this.textSizeType = 1;
        this.msgPointMoreWidth = NavigationUtil.dip2px(this.getContext(), 30.0f);
        this.msgPointMoreHeight = NavigationUtil.dip2px(this.getContext(), 16.0f);
        this.msgPointMoreRadius = 10;
        this.msgPointColor = Color.parseColor((String)"#ff0000");
        this.isViewPager2 = false;
        return this;
    }

    public EasyNavigationBar centerImageRes(int centerImageRes) {
        this.centerImageRes = centerImageRes;
        return this;
    }

    public void updateNavigationIcon(int position, boolean isNormal, int res) {
        if (isNormal) {
            if (this.normalIconItems == null | position >= this.normalIconItems.length) {
                return;
            }
            this.normalIconItems[position] = res;
        } else {
            if (this.selectIconItems == null | position >= this.selectIconItems.length) {
                return;
            }
            this.selectIconItems[position] = res;
        }
        this.updateNavigation(false);
    }

    public void updateNavigationText(int position, boolean isNormal, String str) {
        if (this.titleItems == null | position >= this.titleItems.length) {
            return;
        }
        this.titleItems[position] = str;
        this.updateNavigation(false);
    }

    public void updateNavigation(boolean showAnim) {
        if (this.isCenterAsFragment()) {
            if (this.isCenterPosition(this.currentPosition)) {
                this.selectCenterTabUI();
            } else if (this.isBeforeCenter(this.currentPosition)) {
                this.selectNormalTabUI(this.currentPosition, showAnim);
            } else {
                this.selectNormalTabUI(this.currentPosition - 1, showAnim);
            }
        } else {
            this.selectNormalTabUI(this.currentPosition, showAnim);
        }
    }

    public EasyNavigationBar centerTextStr(String centerTextStr) {
        this.centerTextStr = centerTextStr;
        return this;
    }

    public void buildNavigation() {
        this.post(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < EasyNavigationBar.this.tabCount; ++i) {
                    EasyNavigationBar.this.addTabItemView(i);
                }
                EasyNavigationBar.this.selectNormalTabUI(0, false);
                if (EasyNavigationBar.this.onTabLoadListener != null) {
                    EasyNavigationBar.this.onTabLoadListener.onTabLoadCompleteEvent();
                }
            }
        });
    }

    private boolean checkCanBuild() {
        if (this.titleItems.length < 1 && this.normalIconItems.length < 1) {
            Log.e((String)((Object)((Object)this)).getClass().getName(), (String)"titleItems\u548cnormalIconItems\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return false;
        }
        this.buildCommonNavigation();
        return true;
    }

    private void buildCommonNavigation() {
        this.onlyNavigation = this.fragmentList == null || this.fragmentList.size() < 1 || this.fragmentManager == null;
        if (this.titleItems == null || this.titleItems.length < 1) {
            this.contentType = 1;
            this.tabCount = this.normalIconItems.length;
        } else if (this.normalIconItems == null || this.normalIconItems.length < 1) {
            this.contentType = 2;
            this.tabCount = this.titleItems.length;
        } else {
            this.contentType = 0;
            this.tabCount = this.titleItems.length > this.normalIconItems.length ? this.titleItems.length : this.normalIconItems.length;
        }
        if (this.isAddPage() && this.tabCount % 2 == 1) {
            Log.e((String)((Object)((Object)this)).getClass().getName(), (String)"1.5.0\u4e4b\u540e\u3001\u6dfb\u52a0\u4e2d\u95f4Tab\u3001\u5219\u666e\u901aTab\u6570\u91cf\u5e94\u4e3a\u5076\u6570");
            return;
        }
        if (this.selectIconItems == null || this.selectIconItems.length < 1) {
            this.selectIconItems = this.normalIconItems;
        }
        this.removeNavigationAllView();
        if (!this.onlyNavigation) {
            this.setViewPagerAdapter();
        }
        if (this.hasPadding) {
            if (this.isViewPager2) {
                if (this.getViewPager2() != null) {
                    this.getViewPager2().setPadding(0, 0, 0, (int)(this.navigationHeight + this.lineHeight));
                }
            } else if (this.getViewPager() != null) {
                this.getViewPager().setPadding(0, 0, 0, (int)(this.navigationHeight + this.lineHeight));
            }
        }
    }

    private ViewPager2 getViewPager2() {
        return this.mViewPager2;
    }

    private void setViewPagerAdapter() {
        if (this.mViewPager == null) {
            this.mViewPager = new CustomViewPager(this.getContext());
            this.mViewPager.setId(R.id.vp_layout);
            this.contentView.addView((View)this.mViewPager, 0);
        }
        this.adapter = new ViewPagerAdapter(this.fragmentManager, this.fragmentList);
        this.mViewPager.setAdapter((PagerAdapter)this.adapter);
        this.mViewPager.setOffscreenPageLimit(10);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                EasyNavigationBar.this.selectTab(position, EasyNavigationBar.this.smoothScroll, false);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        if (this.canScroll) {
            ((CustomViewPager)this.getViewPager()).setCanScroll(true);
        } else {
            ((CustomViewPager)this.getViewPager()).setCanScroll(false);
        }
    }

    private boolean isBeforeCenter(int position) {
        return position < this.tabCount / 2;
    }

    private boolean isCenterPosition(int position) {
        return position == this.tabCount / 2;
    }

    public void buildAddNavigation() {
        if (this.centerImageRes == 0) {
            Log.e((String)"EasyNavigation", (String)"MODE_ADD\u6a21\u5f0f\u4e0bcenterImageRes\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < EasyNavigationBar.this.tabCount; ++i) {
                    if (i == EasyNavigationBar.this.tabCount / 2) {
                        EasyNavigationBar.this.addCenterTabView(i);
                    }
                    EasyNavigationBar.this.addTabItemView(i);
                }
                EasyNavigationBar.this.selectNormalTabUI(0, false);
                if (EasyNavigationBar.this.onTabLoadListener != null) {
                    EasyNavigationBar.this.onTabLoadListener.onTabLoadCompleteEvent();
                }
            }
        });
    }

    private void addCenterTabView(int index) {
        RelativeLayout addItemView = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams addItemParams = new RelativeLayout.LayoutParams(-2, -1);
        addItemParams.width = this.getWidth() / (this.tabCount + 1);
        addItemView.setLayoutParams((ViewGroup.LayoutParams)addItemParams);
        this.navigationLayout.addView((View)addItemView);
        LinearLayout centerLinearLayout = new LinearLayout(this.getContext());
        centerLinearLayout.setOrientation(1);
        centerLinearLayout.setGravity(17);
        RelativeLayout.LayoutParams linearParams = new RelativeLayout.LayoutParams(-2, -2);
        this.centerImage = new ImageView(this.getContext());
        LinearLayout.LayoutParams imageParams = new LinearLayout.LayoutParams(-2, -2);
        if (this.centerIconSize > 0.0f) {
            imageParams.width = (int)this.centerIconSize;
            imageParams.height = (int)this.centerIconSize;
        }
        this.centerImage.setLayoutParams((ViewGroup.LayoutParams)imageParams);
        if (this.centerLayoutRule == 0) {
            linearParams.addRule(13);
        } else if (this.centerLayoutRule == 1) {
            linearParams.addRule(14);
            linearParams.addRule(2, R.id.empty_line);
            if (this.centerAlignBottom) {
                if (this.textViewList != null && this.textViewList.size() > 0) {
                    this.textViewList.get(0).post(new Runnable(){

                        @Override
                        public void run() {
                            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)EasyNavigationBar.this.empty_line.getLayoutParams();
                            params.height = (int)((EasyNavigationBar.this.navigationHeight - (float)((TextView)EasyNavigationBar.this.textViewList.get(0)).getHeight() - (float)EasyNavigationBar.this.iconSize - EasyNavigationBar.this.tabTextTop) / 2.0f);
                            EasyNavigationBar.this.empty_line.setLayoutParams((ViewGroup.LayoutParams)params);
                        }
                    });
                }
            } else {
                linearParams.bottomMargin = (int)this.centerLayoutBottomMargin;
            }
        }
        this.centerImage.setId(-1);
        this.centerImage.setImageResource(this.centerImageRes);
        this.centerImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (EasyNavigationBar.this.onCenterTabClickListener != null) {
                    if (!EasyNavigationBar.this.onCenterTabClickListener.onCenterTabSelectEvent(view) && EasyNavigationBar.this.centerAsFragment) {
                        EasyNavigationBar.this.selectTab(EasyNavigationBar.this.tabCount / 2, EasyNavigationBar.this.smoothScroll);
                    }
                } else if (EasyNavigationBar.this.centerAsFragment) {
                    EasyNavigationBar.this.selectTab(EasyNavigationBar.this.tabCount / 2, EasyNavigationBar.this.smoothScroll);
                }
            }
        });
        centerLinearLayout.addView((View)this.centerImage);
        if (!TextUtils.isEmpty((CharSequence)this.centerTextStr)) {
            TextView centerText = new TextView(this.getContext());
            centerText.setTextSize(this.textSizeType, this.centerTextSize);
            LinearLayout.LayoutParams addTextParams = new LinearLayout.LayoutParams(-2, -2);
            addTextParams.topMargin = (int)this.centerTextTopMargin;
            centerText.setLayoutParams((ViewGroup.LayoutParams)addTextParams);
            centerText.setText((CharSequence)this.centerTextStr);
            centerLinearLayout.addView((View)centerText);
        }
        this.AddContainerLayout.addView((View)centerLinearLayout, (ViewGroup.LayoutParams)linearParams);
    }

    private void addTabItemView(final int position) {
        View itemView = View.inflate((Context)this.getContext(), (int)R.layout.navigation_tab_layout, null);
        LinearLayout ll_tab_content = (LinearLayout)itemView.findViewById(R.id.ll_tab_content);
        RelativeLayout.LayoutParams llParams = (RelativeLayout.LayoutParams)ll_tab_content.getLayoutParams();
        if (this.tabContentRule == 0) {
            llParams.addRule(13);
        } else {
            llParams.addRule(12);
            llParams.addRule(14);
            llParams.bottomMargin = this.tabContentBottomMargin;
        }
        ll_tab_content.setLayoutParams((ViewGroup.LayoutParams)llParams);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
        int index = 0;
        index = this.isCenterAsFragment() ? (position < this.tabCount / 2 ? position : position + 1) : position;
        final int finalIndex = index;
        if (this.mode == 0) {
            params.width = this.getWidth() / this.tabCount;
        } else if (this.mode == 1) {
            params.width = this.getWidth() / (this.tabCount + 1);
        } else if (this.mode == 2) {
            params.width = this.getWidth() / (this.tabCount + 1);
        }
        itemView.setTag(R.id.tag_view_position, (Object)position);
        itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (EasyNavigationBar.this.onTabClickListener != null) {
                    if (EasyNavigationBar.this.currentPosition == position) {
                        EasyNavigationBar.this.onTabClickListener.onTabReSelectEvent(view, EasyNavigationBar.this.currentPosition);
                    }
                    if (!EasyNavigationBar.this.onTabClickListener.onTabSelectEvent(view, position)) {
                        EasyNavigationBar.this.selectTab(finalIndex, EasyNavigationBar.this.smoothScroll);
                    }
                } else {
                    EasyNavigationBar.this.selectTab(finalIndex, EasyNavigationBar.this.smoothScroll);
                }
            }
        });
        itemView.setLayoutParams((ViewGroup.LayoutParams)params);
        View hintPoint = itemView.findViewById(R.id.red_point);
        RelativeLayout.LayoutParams hintPointParams = (RelativeLayout.LayoutParams)hintPoint.getLayoutParams();
        hintPointParams.bottomMargin = (int)this.hintPointTop;
        hintPointParams.width = (int)this.hintPointSize;
        hintPointParams.height = (int)this.hintPointSize;
        hintPointParams.leftMargin = (int)this.hintPointLeft;
        NavigationUtil.setOvalBg(hintPoint, this.msgPointColor);
        hintPoint.setLayoutParams((ViewGroup.LayoutParams)hintPointParams);
        TextView msgPoint = (TextView)itemView.findViewById(R.id.msg_point_tv);
        msgPoint.setTextSize(this.textSizeType, this.msgPointTextSize);
        RelativeLayout.LayoutParams msgPointParams = (RelativeLayout.LayoutParams)msgPoint.getLayoutParams();
        msgPointParams.bottomMargin = (int)this.msgPointTop;
        msgPointParams.leftMargin = (int)this.msgPointLeft;
        msgPoint.setLayoutParams((ViewGroup.LayoutParams)msgPointParams);
        this.hintPointList.add(hintPoint);
        this.msgPointList.add(msgPoint);
        TextView text = (TextView)itemView.findViewById(R.id.tab_text_tv);
        ImageView icon = (ImageView)itemView.findViewById(R.id.tab_icon_iv);
        switch (this.contentType) {
            case 1: {
                text.setVisibility(8);
                icon.setScaleType(this.scaleType);
                LinearLayout.LayoutParams iconParams = (LinearLayout.LayoutParams)icon.getLayoutParams();
                iconParams.width = this.iconSize;
                iconParams.height = this.iconSize;
                icon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
                this.imageViewList.add(icon);
                icon.setVisibility(0);
                break;
            }
            case 2: {
                this.textViewList.add(text);
                LinearLayout.LayoutParams textParams = (LinearLayout.LayoutParams)text.getLayoutParams();
                textParams.topMargin = 0;
                text.setLayoutParams((ViewGroup.LayoutParams)textParams);
                text.setText((CharSequence)this.titleItems[position]);
                text.setTextSize(this.textSizeType, this.tabTextSize);
                text.setVisibility(0);
                icon.setVisibility(8);
                break;
            }
            default: {
                this.textViewList.add(text);
                LinearLayout.LayoutParams textParams2 = (LinearLayout.LayoutParams)text.getLayoutParams();
                textParams2.topMargin = (int)this.tabTextTop;
                text.setLayoutParams((ViewGroup.LayoutParams)textParams2);
                text.setText((CharSequence)this.titleItems[position]);
                text.setTextSize(this.textSizeType, this.tabTextSize);
                icon.setScaleType(this.scaleType);
                LinearLayout.LayoutParams iconParams2 = (LinearLayout.LayoutParams)icon.getLayoutParams();
                iconParams2.width = this.iconSize;
                iconParams2.height = this.iconSize;
                icon.setLayoutParams((ViewGroup.LayoutParams)iconParams2);
                this.imageViewList.add(icon);
                text.setVisibility(0);
                icon.setVisibility(0);
            }
        }
        this.tabList.add(itemView);
        this.navigationLayout.addView(itemView);
    }

    public void selectTab(int position, boolean smoothScroll, boolean selectPager) {
        if (this.currentPosition == position) {
            return;
        }
        this.currentPosition = position;
        if (selectPager) {
            if (this.isViewPager2) {
                if (this.getViewPager2() != null) {
                    this.getViewPager2().setCurrentItem(position, smoothScroll);
                }
            } else if (this.getViewPager() != null) {
                this.getViewPager().setCurrentItem(position, smoothScroll);
            }
        }
        this.updateNavigation(true);
    }

    public void selectTab(int position, boolean smoothScroll) {
        this.selectTab(position, smoothScroll, true);
    }

    private boolean isAddPage() {
        return this.mode == 1 || this.mode == 2;
    }

    private void removeNavigationAllView() {
        for (int i = 0; i < this.AddContainerLayout.getChildCount(); ++i) {
            if (this.AddContainerLayout.getChildAt(i).getTag() != null) continue;
            this.AddContainerLayout.removeViewAt(i);
        }
        this.msgPointList.clear();
        this.hintPointList.clear();
        this.imageViewList.clear();
        this.textViewList.clear();
        this.tabList.clear();
        this.navigationLayout.removeAllViews();
    }

    public void buildAddViewNavigation() {
        this.post(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < EasyNavigationBar.this.tabCount; ++i) {
                    if (i == EasyNavigationBar.this.tabCount / 2) {
                        EasyNavigationBar.this.addCenterTabCustomView(i);
                    }
                    EasyNavigationBar.this.addTabItemView(i);
                }
                EasyNavigationBar.this.selectNormalTabUI(0, false);
                if (EasyNavigationBar.this.onTabLoadListener != null) {
                    EasyNavigationBar.this.onTabLoadListener.onTabLoadCompleteEvent();
                }
            }
        });
    }

    private void addCenterTabCustomView(int i) {
        RelativeLayout addItemView = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams addItemParams = new RelativeLayout.LayoutParams(-2, -1);
        addItemParams.width = this.getWidth() / (this.tabCount + 1);
        addItemView.setLayoutParams((ViewGroup.LayoutParams)addItemParams);
        this.navigationLayout.addView((View)addItemView);
        final RelativeLayout.LayoutParams linearParams = new RelativeLayout.LayoutParams(-2, -2);
        if (this.centerLayoutRule == 0) {
            linearParams.addRule(13);
        } else if (this.centerLayoutRule == 1) {
            linearParams.addRule(14);
            if (this.centerAlignBottom) {
                linearParams.addRule(2, R.id.empty_line);
                if (this.textViewList != null && this.textViewList.size() > 0) {
                    this.textViewList.get(0).post(new Runnable(){

                        @Override
                        public void run() {
                            linearParams.bottomMargin = (int)((EasyNavigationBar.this.navigationHeight - (float)((TextView)EasyNavigationBar.this.textViewList.get(0)).getHeight() - (float)EasyNavigationBar.this.iconSize - EasyNavigationBar.this.tabTextTop) / 2.0f);
                        }
                    });
                }
            } else {
                linearParams.addRule(2, R.id.empty_line);
                linearParams.bottomMargin = (int)this.centerLayoutBottomMargin;
            }
        }
        this.customAddView.setId(-1);
        this.customAddView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (EasyNavigationBar.this.onCenterTabClickListener != null) {
                    if (!EasyNavigationBar.this.onCenterTabClickListener.onCenterTabSelectEvent(view) && EasyNavigationBar.this.centerAsFragment) {
                        EasyNavigationBar.this.selectTab(EasyNavigationBar.this.tabCount / 2, EasyNavigationBar.this.smoothScroll);
                    }
                } else if (EasyNavigationBar.this.centerAsFragment) {
                    EasyNavigationBar.this.selectTab(EasyNavigationBar.this.tabCount / 2, EasyNavigationBar.this.smoothScroll);
                }
            }
        });
        this.AddContainerLayout.addView(this.customAddView, (ViewGroup.LayoutParams)linearParams);
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public void setAddViewLayout(View addViewLayout) {
        FrameLayout.LayoutParams addParams = new FrameLayout.LayoutParams(-1, -1);
        this.addViewLayout.addView(addViewLayout, (ViewGroup.LayoutParams)addParams);
    }

    public ViewGroup getAddViewLayout() {
        return this.addViewLayout;
    }

    private void selectCenterTabUI() {
        block5: for (int i = 0; i < this.tabCount; ++i) {
            switch (this.contentType) {
                case 0: {
                    this.imageViewList.get(i).setImageResource(this.normalIconItems[i]);
                    this.textViewList.get(i).setTextColor(this.normalTextColor);
                    this.textViewList.get(i).setText((CharSequence)this.titleItems[i]);
                }
                case 1: {
                    this.imageViewList.get(i).setImageResource(this.normalIconItems[i]);
                    continue block5;
                }
                case 2: {
                    this.textViewList.get(i).setTextColor(this.normalTextColor);
                    this.textViewList.get(i).setText((CharSequence)this.titleItems[i]);
                }
            }
        }
    }

    private void selectNormalTabUI(int position, boolean showAnim) {
        block10: for (int i = 0; i < this.tabCount; ++i) {
            if (i == position) {
                switch (this.contentType) {
                    case 0: {
                        this.imageViewList.get(i).setImageResource(this.selectIconItems[i]);
                        this.textViewList.get(i).setTextColor(this.selectTextColor);
                        this.textViewList.get(i).setText((CharSequence)this.titleItems[i]);
                        break;
                    }
                    case 1: {
                        this.imageViewList.get(i).setImageResource(this.selectIconItems[i]);
                        break;
                    }
                    case 2: {
                        this.textViewList.get(i).setTextColor(this.selectTextColor);
                        this.textViewList.get(i).setText((CharSequence)this.titleItems[i]);
                    }
                }
                continue;
            }
            switch (this.contentType) {
                case 0: {
                    this.imageViewList.get(i).setImageResource(this.normalIconItems[i]);
                    this.textViewList.get(i).setTextColor(this.normalTextColor);
                    this.textViewList.get(i).setText((CharSequence)this.titleItems[i]);
                }
                case 1: {
                    this.imageViewList.get(i).setImageResource(this.normalIconItems[i]);
                    continue block10;
                }
                case 2: {
                    this.textViewList.get(i).setTextColor(this.normalTextColor);
                    this.textViewList.get(i).setText((CharSequence)this.titleItems[i]);
                }
            }
        }
    }

    public void setHintPoint(int position, boolean isShow) {
        if (this.hintPointList == null || this.hintPointList.size() < position + 1) {
            return;
        }
        if (isShow) {
            this.hintPointList.get(position).setVisibility(0);
        } else {
            this.hintPointList.get(position).setVisibility(8);
        }
    }

    public void setMsgPointCount(int position, int count) {
        if (this.msgPointList == null || this.msgPointList.size() < position + 1) {
            return;
        }
        TextView msgPointView = this.msgPointList.get(position);
        if (count > 99) {
            NavigationUtil.setRoundRectBg(this.getContext(), (View)msgPointView, this.msgPointMoreRadius, this.msgPointColor);
            msgPointView.setText((CharSequence)"99+");
            ViewGroup.LayoutParams params = msgPointView.getLayoutParams();
            params.width = (int)this.msgPointMoreWidth;
            params.height = (int)this.msgPointMoreHeight;
            msgPointView.setLayoutParams(params);
            msgPointView.setVisibility(0);
        } else if (count < 1) {
            msgPointView.setVisibility(8);
        } else {
            ViewGroup.LayoutParams params = msgPointView.getLayoutParams();
            params.width = (int)this.msgPointSize;
            params.height = (int)this.msgPointSize;
            msgPointView.setLayoutParams(params);
            NavigationUtil.setOvalBg((View)msgPointView, this.msgPointColor);
            msgPointView.setText((CharSequence)(count + ""));
            msgPointView.setVisibility(0);
        }
    }

    public void clearMsgPoint(int position) {
        if (this.msgPointList == null || this.msgPointList.size() < position + 1) {
            return;
        }
        this.msgPointList.get(position).setVisibility(8);
    }

    public void clearHintPoint(int position) {
        if (this.hintPointList == null || this.hintPointList.size() < position + 1) {
            return;
        }
        this.hintPointList.get(position).setVisibility(8);
    }

    public void clearAllHintPoint() {
        for (int i = 0; i < this.hintPointList.size(); ++i) {
            this.hintPointList.get(i).setVisibility(8);
        }
    }

    public void clearAllMsgPoint() {
        for (int i = 0; i < this.msgPointList.size(); ++i) {
            this.msgPointList.get(i).setVisibility(8);
        }
    }

    public EasyNavigationBar centerLayoutHeight(int centerLayoutHeight) {
        this.centerLayoutHeight = NavigationUtil.dip2px(this.getContext(), centerLayoutHeight);
        return this;
    }

    public EasyNavigationBar scaleType(ImageView.ScaleType scaleType) {
        this.scaleType = scaleType;
        return this;
    }

    public EasyNavigationBar mode(int mode) {
        this.mode = mode;
        return this;
    }

    public EasyNavigationBar hasPadding(boolean hasPadding) {
        this.hasPadding = hasPadding;
        return this;
    }

    public EasyNavigationBar centerIconSize(float centerIconSize) {
        this.centerIconSize = NavigationUtil.dip2px(this.getContext(), centerIconSize);
        return this;
    }

    public EasyNavigationBar navigationBackground(int navigationBackground) {
        this.navigationBackground = navigationBackground;
        return this;
    }

    public EasyNavigationBar navigationHeight(int navigationHeight) {
        this.navigationHeight = NavigationUtil.dip2px(this.getContext(), navigationHeight);
        return this;
    }

    public EasyNavigationBar normalTextColor(int normalTextColor) {
        this.normalTextColor = normalTextColor;
        return this;
    }

    public EasyNavigationBar selectTextColor(int selectTextColor) {
        this.selectTextColor = selectTextColor;
        return this;
    }

    public EasyNavigationBar lineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public EasyNavigationBar lineColor(int lineColor) {
        this.lineColor = lineColor;
        return this;
    }

    public EasyNavigationBar tabTextSize(int tabTextSize) {
        this.tabTextSize = tabTextSize;
        return this;
    }

    public EasyNavigationBar tabTextTop(int tabTextTop) {
        this.tabTextTop = NavigationUtil.dip2px(this.getContext(), tabTextTop);
        return this;
    }

    public EasyNavigationBar msgPointTextSize(int msgPointTextSize) {
        this.msgPointTextSize = msgPointTextSize;
        return this;
    }

    public EasyNavigationBar msgPointSize(float msgPointSize) {
        this.msgPointSize = NavigationUtil.dip2px(this.getContext(), msgPointSize);
        return this;
    }

    public EasyNavigationBar msgPointLeft(int msgPointLeft) {
        this.msgPointLeft = NavigationUtil.dip2px(this.getContext(), msgPointLeft);
        return this;
    }

    public EasyNavigationBar msgPointTop(int msgPointTop) {
        this.msgPointTop = NavigationUtil.dip2px(this.getContext(), msgPointTop);
        return this;
    }

    public EasyNavigationBar hintPointSize(float hintPointSize) {
        this.hintPointSize = NavigationUtil.dip2px(this.getContext(), hintPointSize);
        return this;
    }

    public EasyNavigationBar hintPointLeft(int hintPointLeft) {
        this.hintPointLeft = NavigationUtil.dip2px(this.getContext(), hintPointLeft);
        return this;
    }

    public EasyNavigationBar hintPointTop(int hintPointTop) {
        this.hintPointTop = NavigationUtil.dip2px(this.getContext(), hintPointTop);
        return this;
    }

    public EasyNavigationBar titleItems(String[] titleItems) {
        this.titleItems = titleItems;
        return this;
    }

    public EasyNavigationBar normalIconItems(int[] normalIconItems) {
        this.normalIconItems = normalIconItems;
        return this;
    }

    public EasyNavigationBar selectIconItems(int[] selectIconItems) {
        this.selectIconItems = selectIconItems;
        return this;
    }

    public EasyNavigationBar fragmentList(List<Fragment> fragmentList) {
        this.fragmentList = fragmentList;
        return this;
    }

    public EasyNavigationBar fragmentManager(FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
        return this;
    }

    public EasyNavigationBar centerLayoutRule(int centerLayoutRule) {
        this.centerLayoutRule = centerLayoutRule;
        return this;
    }

    public EasyNavigationBar canScroll(boolean canScroll) {
        this.canScroll = canScroll;
        return this;
    }

    public EasyNavigationBar smoothScroll(boolean smoothScroll) {
        this.smoothScroll = smoothScroll;
        return this;
    }

    public EasyNavigationBar setOnTabClickListener(OnTabClickListener onTabClickListener) {
        this.onTabClickListener = onTabClickListener;
        return this;
    }

    public EasyNavigationBar setOnCenterTabClickListener(OnCenterTabSelectListener onCenterTabClickListener) {
        this.onCenterTabClickListener = onCenterTabClickListener;
        return this;
    }

    public EasyNavigationBar iconSize(float iconSize) {
        this.iconSize = NavigationUtil.dip2px(this.getContext(), iconSize);
        return this;
    }

    public EasyNavigationBar centerLayoutBottomMargin(int centerLayoutBottomMargin) {
        this.centerLayoutBottomMargin = NavigationUtil.dip2px(this.getContext(), centerLayoutBottomMargin);
        return this;
    }

    public EasyNavigationBar centerAsFragment(boolean centerAsFragment) {
        this.centerAsFragment = centerAsFragment;
        return this;
    }

    public EasyNavigationBar addCustomView(View customAddView) {
        this.customAddView = customAddView;
        return this;
    }

    public EasyNavigationBar centerTextSize(int centerTextSize) {
        this.centerTextSize = NavigationUtil.dip2px(this.getContext(), centerTextSize);
        return this;
    }

    public EasyNavigationBar centerNormalTextColor(int centerNormalTextColor) {
        this.centerNormalTextColor = centerNormalTextColor;
        return this;
    }

    public EasyNavigationBar centerSelectTextColor(int centerSelectTextColor) {
        this.centerSelectTextColor = centerSelectTextColor;
        return this;
    }

    public EasyNavigationBar centerTextTopMargin(int centerTextTopMargin) {
        this.centerTextTopMargin = NavigationUtil.dip2px(this.getContext(), centerTextTopMargin);
        return this;
    }

    public EasyNavigationBar centerAlignBottom(boolean centerAlignBottom) {
        this.centerAlignBottom = centerAlignBottom;
        return this;
    }

    public String[] getTitleItems() {
        return this.titleItems;
    }

    public int[] getNormalIconItems() {
        return this.normalIconItems;
    }

    public int[] getSelectIconItems() {
        return this.selectIconItems;
    }

    public List<Fragment> getFragmentList() {
        return this.fragmentList;
    }

    public FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    public boolean isSmoothScroll() {
        return this.smoothScroll;
    }

    public OnTabClickListener getOnTabClickListener() {
        return this.onTabClickListener;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public float getHintPointSize() {
        return this.hintPointSize;
    }

    public float getHintPointLeft() {
        return this.hintPointLeft;
    }

    public float getHintPointTop() {
        return this.hintPointTop;
    }

    public float getMsgPointTextSize() {
        return this.msgPointTextSize;
    }

    public float getMsgPointSize() {
        return this.msgPointSize;
    }

    public float getMsgPointLeft() {
        return this.msgPointLeft;
    }

    public float getMsgPointTop() {
        return this.msgPointTop;
    }

    public float getTabTextTop() {
        return this.tabTextTop;
    }

    public float getTabTextSize() {
        return this.tabTextSize;
    }

    public int getNormalTextColor() {
        return this.normalTextColor;
    }

    public int getSelectTextColor() {
        return this.selectTextColor;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public float getcenterIconSize() {
        return this.centerIconSize;
    }

    public float getcenterLayoutHeight() {
        return this.centerLayoutHeight;
    }

    public int getNavigationBackground() {
        return this.navigationBackground;
    }

    public float getNavigationHeight() {
        return this.navigationHeight;
    }

    public boolean isCanScroll() {
        return this.canScroll;
    }

    public ViewPagerAdapter getAdapter() {
        return this.adapter;
    }

    public ImageView.ScaleType getScaleType() {
        return this.scaleType;
    }

    public int getMode() {
        return this.mode;
    }

    public LinearLayout getNavigationLayout() {
        return this.navigationLayout;
    }

    public RelativeLayout getContentView() {
        return this.contentView;
    }

    public View getLineView() {
        return this.lineView;
    }

    public ViewGroup getAddLayout() {
        return this.addViewLayout;
    }

    public float getcenterLayoutBottomMargin() {
        return this.centerLayoutBottomMargin;
    }

    public int getCenterLayoutRule() {
        return this.centerLayoutRule;
    }

    public RelativeLayout getAddContainerLayout() {
        return this.AddContainerLayout;
    }

    public boolean isHasPadding() {
        return this.hasPadding;
    }

    public boolean isCenterAsFragment() {
        return this.centerAsFragment && this.isAddPage();
    }

    public View getCustomAddView() {
        return this.customAddView;
    }

    public float getcenterTextSize() {
        return this.centerTextSize;
    }

    public int getcenterNormalTextColor() {
        return this.centerNormalTextColor;
    }

    public int getcenterSelectTextColor() {
        return this.centerSelectTextColor;
    }

    public float getcenterTextTopMargin() {
        return this.centerTextTopMargin;
    }

    public boolean iscenterAlignBottom() {
        return this.centerAlignBottom;
    }

    public ImageView getCenterImage() {
        return this.centerImage;
    }

    public EasyNavigationBar textSizeType(int textSizeType) {
        this.textSizeType = textSizeType;
        return this;
    }

    public int getTextSizeType() {
        return this.textSizeType;
    }

    public float getMsgPointMoreWidth() {
        return this.msgPointMoreWidth;
    }

    public EasyNavigationBar setMsgPointMoreWidth(float msgPointMoreWidth) {
        this.msgPointMoreWidth = NavigationUtil.dip2px(this.getContext(), msgPointMoreWidth);
        return this;
    }

    public float getMsgPointMoreHeight() {
        return this.msgPointMoreHeight;
    }

    public EasyNavigationBar setMsgPointMoreHeight(float msgPointMoreHeight) {
        this.msgPointMoreHeight = NavigationUtil.dip2px(this.getContext(), msgPointMoreHeight);
        return this;
    }

    public float getMsgPointMoreRadius() {
        return this.msgPointMoreRadius;
    }

    public EasyNavigationBar setMsgPointMoreRadius(int msgPointMoreRadius) {
        this.msgPointMoreRadius = msgPointMoreRadius;
        return this;
    }

    public int getMsgPointColor() {
        return this.msgPointColor;
    }

    public EasyNavigationBar setMsgPointColor(int msgPointColor) {
        this.msgPointColor = msgPointColor;
        return this;
    }

    public EasyNavigationBar setOnTabLoadListener(OnTabLoadListener onTabLoadListener) {
        this.onTabLoadListener = onTabLoadListener;
        return this;
    }

    public List<View> getTabList() {
        return this.tabList;
    }

    public List<ImageView> getImageViewList() {
        return this.imageViewList;
    }

    public List<TextView> getTextViewList() {
        return this.textViewList;
    }

    public static interface OnTabLoadListener {
        public void onTabLoadCompleteEvent();
    }

    public static interface OnCenterTabSelectListener {
        public boolean onCenterTabSelectEvent(View var1);
    }

    public static interface OnTabClickListener {
        public boolean onTabSelectEvent(View var1, int var2);

        public boolean onTabReSelectEvent(View var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NavigationMode {
        public static final int MODE_NORMAL = 0;
        public static final int MODE_ADD = 1;
        public static final int MODE_ADD_VIEW = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TabContentType {
        public static final int TYPE_NORMAL = 0;
        public static final int TYPE_ONLY_IMAGE = 1;
        public static final int TYPE_ONLY_TEXT = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextSizeType {
        public static final int TYPE_DP = 1;
        public static final int TYPE_SP = 2;
    }
}

