/*
 * Decompiled with CFR 0.152.
 */
package com.autofit.et.lib;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.widget.EditText;

public class AutoFitEditText
extends EditText {
    private static final int NO_LINE_LIMIT = -1;
    private final RectF _availableSpaceRect = new RectF();
    private final SparseIntArray _textCachedSizes = new SparseIntArray();
    private final SizeTester _sizeTester;
    private float _maxTextSize;
    private float _spacingMult = 1.0f;
    private float _spacingAdd = 0.0f;
    private Float _minTextSize = Float.valueOf(TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
    private int _widthLimit;
    private int _maxLines;
    private boolean _enableSizeCache = true;
    private boolean _initiallized = false;
    private TextPaint paint;

    public AutoFitEditText(Context context) {
        this(context, null, 0);
    }

    public AutoFitEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AutoFitEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this._maxTextSize = this.getTextSize();
        if (this._maxLines == 0) {
            this._maxLines = -1;
        }
        this._sizeTester = new SizeTester(){
            final RectF textRect = new RectF();

            @Override
            @TargetApi(value=16)
            public int onTestSize(int suggestedSize, RectF availableSPace) {
                boolean singleline;
                AutoFitEditText.this.paint.setTextSize((float)suggestedSize);
                String text = AutoFitEditText.this.getText().toString();
                boolean bl = singleline = AutoFitEditText.this.getMaxLines() == 1;
                if (singleline) {
                    this.textRect.bottom = AutoFitEditText.this.paint.getFontSpacing();
                    this.textRect.right = AutoFitEditText.this.paint.measureText(text);
                } else {
                    StaticLayout layout = new StaticLayout((CharSequence)text, AutoFitEditText.this.paint, AutoFitEditText.this._widthLimit, Layout.Alignment.ALIGN_NORMAL, AutoFitEditText.this._spacingMult, AutoFitEditText.this._spacingAdd, true);
                    if (AutoFitEditText.this.getMaxLines() != -1 && layout.getLineCount() > AutoFitEditText.this.getMaxLines()) {
                        return 1;
                    }
                    this.textRect.bottom = layout.getHeight();
                    int maxWidth = -1;
                    for (int i = 0; i < layout.getLineCount(); ++i) {
                        if (!((float)maxWidth < layout.getLineWidth(i))) continue;
                        maxWidth = (int)layout.getLineWidth(i);
                    }
                    this.textRect.right = maxWidth;
                }
                this.textRect.offsetTo(0.0f, 0.0f);
                if (availableSPace.contains(this.textRect)) {
                    return -1;
                }
                return 1;
            }
        };
        this._initiallized = true;
    }

    public void setTypeface(Typeface tf) {
        if (this.paint == null) {
            this.paint = new TextPaint((Paint)this.getPaint());
        }
        this.paint.setTypeface(tf);
        super.setTypeface(tf);
    }

    public void setTextSize(float size) {
        this._maxTextSize = size;
        this._textCachedSizes.clear();
        this.adjustTextSize();
    }

    public void setMaxLines(int maxlines) {
        super.setMaxLines(maxlines);
        this._maxLines = maxlines;
        this.reAdjust();
    }

    public int getMaxLines() {
        return this._maxLines;
    }

    public void setSingleLine() {
        super.setSingleLine();
        this._maxLines = 1;
        this.reAdjust();
    }

    public void setSingleLine(boolean singleLine) {
        super.setSingleLine(singleLine);
        this._maxLines = singleLine ? 1 : -1;
        this.reAdjust();
    }

    public void setLines(int lines) {
        super.setLines(lines);
        this._maxLines = lines;
        this.reAdjust();
    }

    public void setTextSize(int unit, float size) {
        Context c = this.getContext();
        Resources r = c == null ? Resources.getSystem() : c.getResources();
        this._maxTextSize = TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics());
        this._textCachedSizes.clear();
        this.adjustTextSize();
    }

    public void setLineSpacing(float add, float mult) {
        super.setLineSpacing(add, mult);
        this._spacingMult = mult;
        this._spacingAdd = add;
    }

    public void setMinTextSize(Float minTextSize) {
        this._minTextSize = minTextSize;
        this.reAdjust();
    }

    public Float get_minTextSize() {
        return this._minTextSize;
    }

    private void reAdjust() {
        this.adjustTextSize();
    }

    private void adjustTextSize() {
        if (!this._initiallized) {
            return;
        }
        int startSize = Math.round(this._minTextSize.floatValue());
        int heightLimit = this.getMeasuredHeight() - this.getCompoundPaddingBottom() - this.getCompoundPaddingTop();
        this._widthLimit = this.getMeasuredWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (this._widthLimit <= 0) {
            return;
        }
        this._availableSpaceRect.right = this._widthLimit;
        this._availableSpaceRect.bottom = heightLimit;
        super.setTextSize(0, (float)this.efficientTextSizeSearch(startSize, (int)this._maxTextSize, this._sizeTester, this._availableSpaceRect));
    }

    public void setEnableSizeCache(boolean enable) {
        this._enableSizeCache = enable;
        this._textCachedSizes.clear();
        this.adjustTextSize();
    }

    private int efficientTextSizeSearch(int start, int end, SizeTester sizeTester, RectF availableSpace) {
        if (!this._enableSizeCache) {
            return this.binarySearch(start, end, sizeTester, availableSpace);
        }
        String text = this.getText().toString();
        int key = text == null ? 0 : text.length();
        int size = this._textCachedSizes.get(key);
        if (size != 0) {
            return size;
        }
        size = this.binarySearch(start, end, sizeTester, availableSpace);
        this._textCachedSizes.put(key, size);
        return size;
    }

    private int binarySearch(int start, int end, SizeTester sizeTester, RectF availableSpace) {
        int lastBest = start;
        int lo = start;
        int hi = end - 1;
        int mid = 0;
        while (lo <= hi) {
            mid = lo + hi >>> 1;
            int midValCmp = sizeTester.onTestSize(mid, availableSpace);
            if (midValCmp < 0) {
                lastBest = lo;
                lo = mid + 1;
                continue;
            }
            if (midValCmp > 0) {
                lastBest = hi = mid - 1;
                continue;
            }
            return mid;
        }
        return lastBest;
    }

    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        super.onTextChanged(text, start, before, after);
        this.reAdjust();
    }

    protected void onSizeChanged(int width, int height, int oldwidth, int oldheight) {
        this._textCachedSizes.clear();
        super.onSizeChanged(width, height, oldwidth, oldheight);
        if (width != oldwidth || height != oldheight) {
            this.reAdjust();
        }
    }

    private static interface SizeTester {
        public int onTestSize(int var1, RectF var2);
    }
}

