/*
 * Decompiled with CFR 0.152.
 */
package io.rx_cache;

import com.google.auto.common.SuperficialValidation;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import io.rx_cache.Actionable;
import io.rx_cache.DynamicKey;
import io.rx_cache.DynamicKeyGroup;
import io.rx_cache.EvictDynamicKey;
import io.rx_cache.EvictDynamicKeyGroup;
import io.rx_cache.EvictProvider;
import io.rx_cache.ProvidersClass;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import rx.Observable;

final class GetProvidersClass {
    GetProvidersClass() {
    }

    ProvidersClass from(Element element) throws ValidationException {
        if (!SuperficialValidation.validateElement((Element)element)) {
            return null;
        }
        if (element.getKind() != ElementKind.INTERFACE) {
            return null;
        }
        ClassName className = ClassName.get((TypeElement)((TypeElement)element));
        List<ProvidersClass.Method> methods = this.getMethods(element);
        return new ProvidersClass(className, element, methods);
    }

    private List<ProvidersClass.Method> getMethods(Element classElement) throws ValidationException {
        List<? extends Element> enclosedElements = classElement.getEnclosedElements();
        ArrayList<ProvidersClass.Method> methods = new ArrayList<ProvidersClass.Method>();
        for (Element element : enclosedElements) {
            if (!this.isAnnotatedWithActionable(element) || element.getKind() != ElementKind.METHOD) continue;
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)element;
            String nameMethod = ((Name)methodSymbol.getSimpleName()).toString();
            Type returnType = methodSymbol.getReturnType();
            if (!returnType.tsym.toString().equals(TypeName.get(Observable.class).toString())) {
                throw new ValidationException(methodSymbol, "Error parsing %s provider. Only Observable<List> type is supported as observable loader", nameMethod);
            }
            Type enclosingTypeObservable = returnType.getTypeArguments().get(0);
            if (!enclosingTypeObservable.tsym.toString().equals(TypeName.get(List.class).toString())) {
                throw new ValidationException(methodSymbol, "Error parsing %s provider. Only Observable<List> type is supported as observable loader", nameMethod);
            }
            List params = methodSymbol.getParameters();
            boolean hasEvictProvider = this.hasEvictProvider(params);
            boolean hasEvictDynamicKey = this.hasEvictDynamicKey(params);
            boolean hasEvictDynamicKeyGroup = this.hasEvictDynamicKeyGroup(params);
            if (!(hasEvictProvider || hasEvictDynamicKey || hasEvictDynamicKeyGroup)) {
                throw new ValidationException(element, "Error parsing %s provider. The provider requires one evicting argument: EvictProvider, EvictDynamicKey or EvictDynamicKeyGroup", nameMethod);
            }
            if (hasEvictProvider && hasEvictDynamicKey) {
                throw new ValidationException(element, "Error parsing %s provider. The provider requires one evicting argument: EvictProvider, EvictDynamicKey or EvictDynamicKeyGroup", nameMethod);
            }
            if (hasEvictProvider && hasEvictDynamicKeyGroup) {
                throw new ValidationException(element, "Error parsing %s provider. The provider requires one evicting argument: EvictProvider, EvictDynamicKey or EvictDynamicKeyGroup", nameMethod);
            }
            if (hasEvictDynamicKey && hasEvictDynamicKeyGroup) {
                throw new ValidationException(element, "Error parsing %s provider. The provider requires one evicting argument: EvictProvider, EvictDynamicKey or EvictDynamicKeyGroup", nameMethod);
            }
            boolean hasDynamicKey = this.hasDynamicKey(params);
            boolean hasDynamicKeyGroup = this.hasDynamicKeyGroup(params);
            methods.add(new ProvidersClass.Method(nameMethod, element, enclosingTypeObservable, hasDynamicKey, hasDynamicKeyGroup));
        }
        return methods;
    }

    private boolean isAnnotatedWithActionable(Element element) {
        Actionable actionable = element.getAnnotation(Actionable.class);
        return actionable != null;
    }

    private boolean hasDynamicKey(List<Symbol.VarSymbol> symbols) {
        return this.hasSymbol(symbols, DynamicKey.class);
    }

    private boolean hasDynamicKeyGroup(List<Symbol.VarSymbol> symbols) {
        return this.hasSymbol(symbols, DynamicKeyGroup.class);
    }

    private boolean hasEvictProvider(List<Symbol.VarSymbol> symbols) {
        return this.hasSymbol(symbols, EvictProvider.class);
    }

    private boolean hasEvictDynamicKey(List<Symbol.VarSymbol> symbols) {
        return this.hasSymbol(symbols, EvictDynamicKey.class);
    }

    private boolean hasEvictDynamicKeyGroup(List<Symbol.VarSymbol> symbols) {
        return this.hasSymbol(symbols, EvictDynamicKeyGroup.class);
    }

    private boolean hasSymbol(List<Symbol.VarSymbol> symbols, Class candidateClass) {
        for (Symbol.VarSymbol symbol : symbols) {
            String candidateClassName;
            String symbolClassName = symbol.type.toString();
            if (!symbolClassName.equals(candidateClassName = candidateClass.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    static class ValidationException
    extends Exception {
        private final Element element;

        public ValidationException(Element element, String msg, Object ... args) {
            super(String.format(msg, args));
            this.element = element;
        }

        public Element getElement() {
            return this.element;
        }
    }
}

