/*
 * Decompiled with CFR 0.152.
 */
package io.rx_cache;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.rx_cache.ActionsList;
import io.rx_cache.ActionsProcessor;
import io.rx_cache.DynamicKey;
import io.rx_cache.DynamicKeyGroup;
import io.rx_cache.EvictDynamicKey;
import io.rx_cache.EvictDynamicKeyGroup;
import io.rx_cache.EvictProvider;
import io.rx_cache.ProvidersClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import rx.Observable;

final class BrewJavaFile {
    BrewJavaFile() {
    }

    JavaFile from(ProvidersClass providersClass) throws IOException {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        for (ProvidersClass.Method method : providersClass.methods) {
            methodSpecs.add(this.getActionProvider(providersClass.className, method));
        }
        TypeSpec typeSpec = this.classProviders(providersClass.className, methodSpecs);
        return JavaFile.builder((String)providersClass.className.packageName(), (TypeSpec)typeSpec).build();
    }

    private MethodSpec getActionProvider(ClassName providersClassName, ProvidersClass.Method method) {
        String methodName = method.name;
        TypeName list = ClassName.get((TypeMirror)method.enclosingTypeObservable);
        TypeName enclosingTypeList = ClassName.get((TypeMirror)method.enclosingTypeObservable.getTypeArguments().get(0));
        String enclosingTypeListName = enclosingTypeList.toString();
        ParameterizedTypeName action = ParameterizedTypeName.get((ClassName)ClassName.get(ActionsList.class), (TypeName[])new TypeName[]{enclosingTypeList});
        ParameterizedTypeName evict = ParameterizedTypeName.get((ClassName)ClassName.get(ActionsList.Evict.class), (TypeName[])new TypeName[]{enclosingTypeList});
        ParameterizedTypeName arrayList = ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{enclosingTypeList});
        ParameterizedTypeName observable = ParameterizedTypeName.get((ClassName)ClassName.get(Observable.class), (TypeName[])new TypeName[]{list});
        ParameterSpec rxProvidersInstance = ParameterSpec.builder((TypeName)providersClassName, (String)"proxy", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(rxProvidersInstance).returns((TypeName)action);
        if (method.hasDynamicKey) {
            builder.addParameter(DynamicKey.class, "dynamicKey", new Modifier[]{Modifier.FINAL});
        } else if (method.hasDynamicKeyGroup) {
            builder.addParameter(DynamicKeyGroup.class, "dynamicKeyGroup", new Modifier[]{Modifier.FINAL});
        }
        builder.beginControlFlow("$T evict = new $T()", new Object[]{evict, evict}).beginControlFlow("@Override public $T call($T elements)", new Object[]{observable, observable});
        if (method.hasDynamicKey) {
            this.setReturnEvictForEvictDynamicKey(builder, methodName);
        } else if (method.hasDynamicKeyGroup) {
            this.setReturnEvictForEvictDynamicKeyGroup(builder, methodName);
        } else {
            this.setReturnEvictForEvictProvider(builder, methodName);
        }
        builder.endControlFlow().endControlFlow(";", new Object[0]);
        if (method.hasDynamicKey) {
            this.setCacheForEvictDynamicKey(builder, observable, arrayList, methodName, enclosingTypeListName);
        } else if (method.hasDynamicKeyGroup) {
            this.setCacheForEvictDynamicKeyGroup(builder, observable, arrayList, methodName, enclosingTypeListName);
        } else {
            this.setCacheForEvictProvider(builder, observable, arrayList, methodName, enclosingTypeListName);
        }
        builder.addStatement("return ActionsList.with(evict, oCache)", new Object[0]);
        return builder.build();
    }

    private void setReturnEvictForEvictProvider(MethodSpec.Builder builder, String methodName) {
        builder.addStatement("return proxy." + methodName + "(elements, new $T(true))", new Object[]{EvictProvider.class});
    }

    private void setReturnEvictForEvictDynamicKey(MethodSpec.Builder builder, String methodName) {
        builder.addStatement("return proxy." + methodName + "(elements, dynamicKey, new $T(true))", new Object[]{EvictDynamicKey.class});
    }

    private void setReturnEvictForEvictDynamicKeyGroup(MethodSpec.Builder builder, String methodName) {
        builder.addStatement("return proxy." + methodName + "(elements, dynamicKeyGroup, new $T(true))", new Object[]{EvictDynamicKeyGroup.class});
    }

    private void setCacheForEvictProvider(MethodSpec.Builder builder, ParameterizedTypeName observable, ParameterizedTypeName arrayList, String methodName, String typeName) {
        builder.addStatement("$T oCache = proxy." + methodName + "(Observable.<List<" + typeName + ">>just(new $T()), new EvictProvider(false))", new Object[]{observable, arrayList});
    }

    private void setCacheForEvictDynamicKey(MethodSpec.Builder builder, ParameterizedTypeName observable, ParameterizedTypeName arrayList, String methodName, String typeName) {
        builder.addStatement("$T oCache = proxy." + methodName + "(Observable.<List<" + typeName + ">>just(new $T()), dynamicKey, new EvictDynamicKey(false))", new Object[]{observable, arrayList});
    }

    private void setCacheForEvictDynamicKeyGroup(MethodSpec.Builder builder, ParameterizedTypeName observable, ParameterizedTypeName arrayList, String methodName, String typeName) {
        builder.addStatement("$T oCache = proxy." + methodName + "(Observable.<List<" + typeName + ">>just(new $T()), dynamicKeyGroup, new EvictDynamicKeyGroup(false))", new Object[]{observable, arrayList});
    }

    private TypeSpec classProviders(ClassName className, List<MethodSpec> methodSpecs) {
        return TypeSpec.classBuilder((String)(className.simpleName() + "Actionable")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{ActionsProcessor.class.getCanonicalName()}).addMember("comments", "$S", new Object[]{"Generated code from RxCache. Don't modify. Or modify. It doesn't matter."}).build()).addMethods(methodSpecs).build();
    }
}

