/*
 * Decompiled with CFR 0.152.
 */
package io.rx_cache;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.JavaFile;
import io.rx_cache.Actionable;
import io.rx_cache.BrewJavaFile;
import io.rx_cache.GetProvidersClass;
import io.rx_cache.ProvidersClass;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public final class ActionsProcessor
extends AbstractProcessor {
    private Messager messager;
    private Filer filer;
    private GetProvidersClass getProvidersClass;
    private BrewJavaFile brewJavaFile;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.messager = env.getMessager();
        this.filer = env.getFiler();
        this.getProvidersClass = new GetProvidersClass();
        this.brewJavaFile = new BrewJavaFile();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            try {
                ProvidersClass testClass = this.getProvidersClass.from(element);
                if (testClass == null || testClass.methods.isEmpty()) continue;
                JavaFile javaFile = this.brewJavaFile.from(testClass);
                javaFile.writeTo(this.filer);
            }
            catch (GetProvidersClass.ValidationException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement());
            }
            catch (IOException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), element);
            }
        }
        return false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(Actionable.class.getCanonicalName());
        return annotations;
    }
}

