/*
 * Decompiled with CFR 0.152.
 */
package io.rx_cache2.internal;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.rx_cache2.EncryptKey;
import io.rx_cache2.Migration;
import io.rx_cache2.MigrationCache;
import io.rx_cache2.SchemeMigration;
import io.rx_cache2.internal.DaggerRxCacheComponent;
import io.rx_cache2.internal.ProcessorProviders;
import io.rx_cache2.internal.ProxyTranslator;
import io.rx_cache2.internal.RxCache;
import io.rx_cache2.internal.RxCacheModule;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class ProxyProviders
implements InvocationHandler {
    private final ProcessorProviders processorProviders;
    private final ProxyTranslator proxyTranslator;

    public ProxyProviders(RxCache.Builder builder, Class<?> providersClass) {
        this.processorProviders = DaggerRxCacheComponent.builder().rxCacheModule(new RxCacheModule(builder.getCacheDirectory(), Boolean.valueOf(builder.useExpiredDataIfLoaderNotAvailable()), builder.getMaxMBPersistenceCache(), this.getEncryptKey(providersClass), this.getMigrations(providersClass), builder.getJolyglot())).build().providers();
        this.proxyTranslator = new ProxyTranslator();
    }

    public String getEncryptKey(Class<?> providersClass) {
        EncryptKey encryptKey = providersClass.getAnnotation(EncryptKey.class);
        if (encryptKey == null) {
            return null;
        }
        return encryptKey.value();
    }

    public List<MigrationCache> getMigrations(Class<?> providersClass) {
        ArrayList<MigrationCache> migrations = new ArrayList<MigrationCache>();
        SchemeMigration annotation = providersClass.getAnnotation(SchemeMigration.class);
        if (annotation == null) {
            return migrations;
        }
        SchemeMigration schemeMigration = annotation;
        for (Migration migration : schemeMigration.value()) {
            migrations.add(new MigrationCache(migration.version(), migration.evictClasses()));
        }
        return migrations;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        return Observable.defer((Callable)new Callable<ObservableSource<Object>>(){

            @Override
            public ObservableSource<Object> call() throws Exception {
                return ProxyProviders.this.processorProviders.process(ProxyProviders.this.proxyTranslator.processMethod(method, args));
            }
        });
    }

    Observable<Void> evictAll() {
        return this.processorProviders.evictAll();
    }
}

