/*
 * Decompiled with CFR 0.152.
 */
package rx_activity_result;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import java.util.List;
import rx.Observable;
import rx.functions.Action1;
import rx.subjects.PublishSubject;
import rx_activity_result.ActivitiesLifecycleCallbacks;
import rx_activity_result.HolderActivity;
import rx_activity_result.OnPreResult;
import rx_activity_result.OnResult;
import rx_activity_result.Request;
import rx_activity_result.RequestIntentSender;
import rx_activity_result.Result;

public class RxActivityResult {
    private static ActivitiesLifecycleCallbacks activitiesLifecycle;

    public static void register(Application application) {
        activitiesLifecycle = new ActivitiesLifecycleCallbacks(application);
    }

    public static <T extends Activity> Builder<T> on(T activity) {
        return new Builder<T>(activity);
    }

    public static <T extends Fragment> Builder<T> on(T fragment) {
        return new Builder<T>(fragment);
    }

    public static class Builder<T> {
        final Class clazz;
        final PublishSubject<Result<T>> subject = PublishSubject.create();
        private final boolean uiTargetActivity;

        public Builder(T t) {
            if (activitiesLifecycle == null) {
                throw new IllegalStateException("You must call RxActivityResult.register(application) before attempting to use startIntent");
            }
            this.clazz = t.getClass();
            this.uiTargetActivity = t instanceof Activity;
        }

        public Observable<Result<T>> startIntentSender(IntentSender intentSender, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) {
            return this.startIntentSender(intentSender, fillInIntent, flagsMask, flagsValues, extraFlags, null);
        }

        public Observable<Result<T>> startIntentSender(IntentSender intentSender, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) {
            RequestIntentSender requestIntentSender = new RequestIntentSender(intentSender, fillInIntent, flagsMask, flagsValues, extraFlags, options);
            return this.startHolderActivity(requestIntentSender, null);
        }

        public Observable<Result<T>> startIntent(Intent intent) {
            return this.startIntent(intent, null);
        }

        public Observable<Result<T>> startIntent(Intent intent, OnPreResult onPreResult) {
            return this.startHolderActivity(new Request(intent), onPreResult);
        }

        private Observable<Result<T>> startHolderActivity(Request request, OnPreResult onPreResult) {
            OnResult onResult = this.uiTargetActivity ? this.onResultActivity() : this.onResultFragment();
            request.setOnResult(onResult);
            request.setOnPreResult(onPreResult);
            HolderActivity.setRequest(request);
            activitiesLifecycle.getOLiveActivity().subscribe((Action1)new Action1<Activity>(){

                public void call(Activity activity) {
                    activity.startActivity(new Intent((Context)activity, HolderActivity.class).addFlags(65536));
                }
            });
            return this.subject.asObservable();
        }

        private OnResult onResultActivity() {
            return new OnResult(){

                @Override
                public void response(int resultCode, Intent data) {
                    if (activitiesLifecycle.getLiveActivity() == null) {
                        return;
                    }
                    if (activitiesLifecycle.getLiveActivity().getClass() != Builder.this.clazz) {
                        return;
                    }
                    Activity activity = activitiesLifecycle.getLiveActivity();
                    Builder.this.subject.onNext(new Result<Activity>(activity, resultCode, data));
                    Builder.this.subject.onCompleted();
                }
            };
        }

        private OnResult onResultFragment() {
            return new OnResult(){

                @Override
                public void response(int resultCode, Intent data) {
                    if (activitiesLifecycle.getLiveActivity() == null) {
                        return;
                    }
                    Activity activity = activitiesLifecycle.getLiveActivity();
                    FragmentActivity fragmentActivity = (FragmentActivity)activity;
                    FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
                    Fragment targetFragment = Builder.this.getTargetFragment(fragmentManager.getFragments());
                    if (targetFragment != null) {
                        Builder.this.subject.onNext(new Result<Fragment>(targetFragment, resultCode, data));
                        Builder.this.subject.onCompleted();
                    }
                }
            };
        }

        @Nullable
        private Fragment getTargetFragment(List<Fragment> fragments) {
            if (fragments == null) {
                return null;
            }
            for (Fragment fragment : fragments) {
                List childFragments;
                Fragment candidate;
                if (fragment != null && fragment.isVisible() && fragment.getClass() == this.clazz) {
                    return fragment;
                }
                if (fragment == null || fragment.getChildFragmentManager() == null || (candidate = this.getTargetFragment(childFragments = fragment.getChildFragmentManager().getFragments())) == null) continue;
                return candidate;
            }
            return null;
        }
    }
}

