/*
 * Decompiled with CFR 0.152.
 */
package io.victoralbertos.jolyglot;

import com.google.gson.Gson;
import io.victoralbertos.jolyglot.JolyglotGenerics;
import io.victoralbertos.jolyglot.Types;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GsonSpeaker
implements JolyglotGenerics {
    private final Gson gson;

    public GsonSpeaker(Gson gson) {
        this.gson = gson;
    }

    public GsonSpeaker() {
        this.gson = new Gson();
    }

    public String toJson(Object src) {
        return this.gson.toJson(src);
    }

    public String toJson(Object src, Type typeOfSrc) {
        return this.gson.toJson(src, typeOfSrc);
    }

    public <T> T fromJson(String json, Class<T> classOfT) throws RuntimeException {
        return (T)this.gson.fromJson(json, classOfT);
    }

    public <T> T fromJson(String json, Type typeOfT) throws RuntimeException {
        return (T)this.gson.fromJson(json, typeOfT);
    }

    public <T> T fromJson(File file, Class<T> classOfT) throws RuntimeException {
        Object object;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file.getAbsoluteFile()));
            Object object2 = this.gson.fromJson((Reader)reader, classOfT);
            reader.close();
            object = object2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)object;
    }

    public <T> T fromJson(File file, Type typeOfT) throws RuntimeException {
        Object object;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file.getAbsoluteFile()));
            Object object2 = this.gson.fromJson((Reader)reader, typeOfT);
            reader.close();
            object = object2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)object;
    }

    public GenericArrayType arrayOf(Type componentType) {
        return Types.arrayOf((Type)componentType);
    }

    public ParameterizedType newParameterizedType(Type rawType, Type ... typeArguments) {
        return Types.newParameterizedType((Type)rawType, (Type[])typeArguments);
    }
}

