/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.reflection.util;

import idea.verlif.reflection.domain.ClassGrc;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SignatureUtil {
    public static String getSignature(Object o) throws IllegalAccessException {
        Field signature;
        try {
            signature = o.getClass().getDeclaredField("signature");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        boolean acc = signature.isAccessible();
        if (!acc) {
            signature.setAccessible(true);
        }
        String sig = (String)signature.get(o);
        if (!acc) {
            signature.setAccessible(false);
        }
        return sig;
    }

    public static ClassGrc parseClassBySignature(String signature, Map<String, ClassGrc> genericsMap) throws ClassNotFoundException {
        int tag;
        if (signature.charAt(signature.length() - 1) == ';') {
            signature = signature.substring(0, signature.length() - 1);
        }
        if ((tag = signature.indexOf(60)) < 0) {
            if (signature.charAt(0) == '[') {
                Class<?> cl;
                int i = 1;
                while (signature.charAt(i) == '[') {
                    ++i;
                }
                if (signature.charAt(i) == 'L') {
                    cl = Class.forName(signature + ";");
                } else {
                    if (signature.charAt(i) == 'T') {
                        return SignatureUtil.getClassGrcFromKey(signature.substring(i + 1), genericsMap);
                    }
                    cl = Class.forName(signature);
                }
                return new ClassGrc(cl);
            }
            if (signature.charAt(0) == 'T' || signature.charAt(0) == '*') {
                signature = signature.substring(1);
                return SignatureUtil.getClassGrcFromKey(signature, genericsMap);
            }
            signature = signature.substring(1).replace("/", ".");
            Class<?> cl = Class.forName(signature);
            return new ClassGrc(cl);
        }
        String tarName = signature.substring(1, tag).replace("/", ".");
        String genericsStr = signature.substring(tag + 1, signature.length() - 1);
        List<String> genericsNames = SignatureUtil.splitSignature(genericsStr);
        ClassGrc[] genericsInfo = new ClassGrc[genericsNames.size()];
        for (int i = 0; i < genericsNames.size(); ++i) {
            if (genericsNames.get(i).length() <= 0) continue;
            genericsInfo[i] = SignatureUtil.parseClassBySignature(genericsNames.get(i), genericsMap);
        }
        Class<?> target = Class.forName(tarName);
        return new ClassGrc(target, genericsInfo);
    }

    public static List<String> splitSignature(String signatureStr) {
        ArrayList<String> list = new ArrayList<String>();
        if (signatureStr.indexOf(60) == -1) {
            Collections.addAll(list, signatureStr.split(";"));
        } else {
            char[] chars = signatureStr.toCharArray();
            int count = 0;
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == ';' && count == 0) {
                    if (i == chars.length - 1) break;
                    list.add(signatureStr.substring(0, i++));
                    signatureStr = signatureStr.substring(i);
                    continue;
                }
                if (c == '<') {
                    ++count;
                    continue;
                }
                if (c != '>') continue;
                --count;
            }
            if (signatureStr.length() > 0) {
                list.add(signatureStr);
            }
        }
        return list;
    }

    private static ClassGrc getClassGrcFromKey(String key, Map<String, ClassGrc> genericsMap) {
        ClassGrc classGrc = genericsMap.get(key);
        if (classGrc == null) {
            classGrc = new ClassGrc();
            genericsMap.put(key, classGrc);
        }
        return classGrc;
    }
}

