/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.reflection.util;

import idea.verlif.reflection.domain.ActualClass;
import idea.verlif.reflection.domain.ClassGrc;
import idea.verlif.reflection.domain.FieldGrc;
import idea.verlif.reflection.domain.MethodGrc;
import idea.verlif.reflection.domain.SFunction;
import idea.verlif.reflection.util.SignatureUtil;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;
import sun.reflect.generics.repository.ClassRepository;

public class ReflectUtil {
    private static final Pattern PARAMETER_TYPE_PATTERN = Pattern.compile("\\((.*)\\).*");

    public static List<Field> getAllFields(Class<?> cla) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            Collections.addAll(fields, cla.getDeclaredFields());
        } while ((cla = cla.getSuperclass()) != null);
        return fields;
    }

    public static List<Method> getAllMethods(Class<?> cla) {
        ArrayList<Method> methods = new ArrayList<Method>();
        do {
            Collections.addAll(methods, cla.getDeclaredMethods());
        } while ((cla = cla.getSuperclass()) != null);
        return methods;
    }

    public static Map<String, ClassGrc> getGenericsMap(Class<?> cl) throws NoSuchFieldException, IllegalAccessException {
        Type[] interfaces;
        HashMap<String, ClassGrc> genericsMap = new HashMap<String, ClassGrc>();
        Type type = cl.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            genericsMap.putAll(ReflectUtil.getGenericsMap(pType));
        }
        for (Type iType : interfaces = cl.getGenericInterfaces()) {
            if (!(iType instanceof ParameterizedType)) continue;
            genericsMap.putAll(ReflectUtil.getGenericsMap((ParameterizedType)iType));
        }
        return genericsMap;
    }

    public static Map<String, ClassGrc> getGenericsMap(ClassGrc classGrc) throws NoSuchFieldException, IllegalAccessException {
        if (classGrc.getGenericsInfos().length == 0) {
            return ReflectUtil.getGenericsMap(classGrc.getClass());
        }
        HashMap<String, ClassGrc> genericsMap = new HashMap<String, ClassGrc>();
        TypeVariable<Class<?>>[] typeParameters = classGrc.getTarget().getTypeParameters();
        ClassGrc[] genericsInfos = classGrc.getGenericsInfos();
        int size = Math.min(typeParameters.length, genericsInfos.length);
        for (int i = 0; i < size; ++i) {
            genericsMap.put(typeParameters[i].getName(), genericsInfos[i]);
        }
        return genericsMap;
    }

    public static Map<String, ClassGrc> getGenericsMap(ParameterizedType pType) throws NoSuchFieldException, IllegalAccessException {
        HashMap<String, ClassGrc> genericsMap = new HashMap<String, ClassGrc>();
        Type rawType = pType.getRawType();
        Type[] arguments = pType.getActualTypeArguments();
        if (arguments.length > 0) {
            Field genericInfoField = Class.class.getDeclaredField("genericInfo");
            boolean acc = genericInfoField.isAccessible();
            if (!acc) {
                genericInfoField.setAccessible(true);
            }
            ClassRepository genericInfo = (ClassRepository)genericInfoField.get(rawType);
            if (!acc) {
                genericInfoField.setAccessible(false);
            }
            TypeVariable<?>[] parameters = genericInfo.getTypeParameters();
            for (int i = 0; i < parameters.length; ++i) {
                genericsMap.put(parameters[i].getName(), ReflectUtil.getClassGrc(arguments[i]));
            }
        }
        if (rawType instanceof Class) {
            genericsMap.putAll(ReflectUtil.getGenericsMap((Class)rawType));
        }
        return genericsMap;
    }

    public static ClassGrc getClassGrc(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedTypeImpl pType = (ParameterizedTypeImpl)type;
            Type rawType = pType.getRawType();
            Type[] arguments = pType.getActualTypeArguments();
            ClassGrc[] argumentInfos = new ClassGrc[arguments.length];
            for (int i = 0; i < argumentInfos.length; ++i) {
                argumentInfos[i] = ReflectUtil.getClassGrc(arguments[i]);
            }
            return new ClassGrc((Class<?>)rawType, argumentInfos);
        }
        if (type instanceof Class) {
            return new ClassGrc((Class)type);
        }
        return new ClassGrc();
    }

    public static FieldGrc getFieldGrc(Field field) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        return ReflectUtil.getFieldGrc(field, field.getDeclaringClass());
    }

    public static FieldGrc getFieldGrc(Field field, Class<?> target) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        Map<String, ClassGrc> genericsMap = ReflectUtil.getGenericsMap(target);
        return ReflectUtil.getFieldGrc(field, genericsMap);
    }

    public static FieldGrc getFieldGrc(Field field, Map<String, ClassGrc> genericsMap) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        String sig = SignatureUtil.getSignature(field);
        if (sig == null) {
            return new FieldGrc(field);
        }
        ClassGrc classGrc = SignatureUtil.parseClassBySignature(sig.substring(0, sig.length() - 1), genericsMap);
        return new FieldGrc(field, classGrc.getTarget(), classGrc.getGenericsInfos());
    }

    public static MethodGrc getMethodGrc(Method method, Class<?> target) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        Map<String, ClassGrc> genericsMap = ReflectUtil.getGenericsMap(target);
        String sig = SignatureUtil.getSignature(method);
        if (sig != null) {
            String sigName;
            int i;
            if (sig.charAt(0) == '<') {
                String generics = sig.substring(1, sig.indexOf(62) - 1);
                sig = sig.substring(generics.length() + 3);
                List<String> sigList = SignatureUtil.splitSignature(generics);
                for (String s : sigList) {
                    if (s.length() <= 0) continue;
                    i = s.indexOf(58);
                    String name = s.substring(0, i);
                    String className = s.substring(i + 2).replace("/", ".");
                    Class<?> aClass = Class.forName(className);
                    genericsMap.put(name, new ClassGrc(aClass));
                }
            }
            ClassGrc[] infos = new ClassGrc[]{};
            if (sig.charAt(0) == '(') {
                int end = sig.indexOf(41);
                if (end == 1) {
                    sig = sig.substring(2);
                } else {
                    String params = sig.substring(1, end - 1);
                    sig = sig.substring(params.length() + 3);
                    List<String> sigList = SignatureUtil.splitSignature(params);
                    infos = new ClassGrc[sigList.size()];
                    for (i = 0; i < sigList.size(); ++i) {
                        ClassGrc info;
                        infos[i] = info = SignatureUtil.parseClassBySignature(sigList.get(i), genericsMap);
                    }
                }
            }
            ClassGrc info = null;
            if (sig.length() > 0 && (sigName = sig.substring(0, sig.length() - 1)).length() > 0) {
                info = SignatureUtil.parseClassBySignature(sigName, genericsMap);
            }
            return new MethodGrc(method, info, infos);
        }
        ClassGrc result = ReflectUtil.getClassGrc(method.getReturnType());
        Class<?>[] parameterTypes = method.getParameterTypes();
        ClassGrc[] argumentInfos = new ClassGrc[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            argumentInfos[i] = ReflectUtil.getClassGrc(parameterTypes[i]);
        }
        return new MethodGrc(method, result, argumentInfos);
    }

    public static MethodGrc getMethodGrc(Method method) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        return ReflectUtil.getMethodGrc(method, method.getDeclaringClass());
    }

    public static ActualClass getActualClass(Class<?> target) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        Map<String, ClassGrc> genericsMap = ReflectUtil.getGenericsMap(target);
        List<Field> allFields = ReflectUtil.getAllFields(target);
        HashMap<String, FieldGrc> fieldGrcMap = new HashMap<String, FieldGrc>(allFields.size());
        for (Field field : allFields) {
            fieldGrcMap.put(field.getName(), ReflectUtil.getFieldGrc(field, genericsMap));
        }
        List<Method> allMethods = ReflectUtil.getAllMethods(target);
        HashMap<String, MethodGrc> methodGrcMap = new HashMap<String, MethodGrc>(allMethods.size());
        for (Method method : allMethods) {
            methodGrcMap.put(method.getName(), ReflectUtil.getMethodGrc(method, target));
        }
        return new ActualClass(ReflectUtil.getClassGrc(target), fieldGrcMap, methodGrcMap);
    }

    public static <T> Field getFieldFromLambda(SFunction<T, ?> function) {
        SerializedLambda serializedLambda = ReflectUtil.getSerializedLambda(function);
        String implMethodName = serializedLambda.getImplMethodName();
        if (!implMethodName.startsWith("is") && !implMethodName.startsWith("get")) {
            throw new RuntimeException("It's not the standard name - " + implMethodName);
        }
        int prefixLen = implMethodName.startsWith("is") ? 2 : 3;
        String fieldName = implMethodName.substring(prefixLen);
        String firstChar = fieldName.substring(0, 1);
        fieldName = fieldName.replaceFirst(firstChar, firstChar.toLowerCase());
        try {
            return Class.forName(serializedLambda.getImplClass().replace("/", ".")).getDeclaredField(fieldName);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, R> Method getMethodFromLambda(SFunction<T, R> function) {
        SerializedLambda serializedLambda = ReflectUtil.getSerializedLambda(function);
        String expr = serializedLambda.getImplMethodSignature();
        Matcher matcher = PARAMETER_TYPE_PATTERN.matcher(expr);
        if (!matcher.find() || matcher.groupCount() != 1) {
            throw new RuntimeException("Lambda parsing failed!");
        }
        expr = matcher.group(1);
        Class[] claArray = expr.length() == 0 ? new Class[]{} : (Class[])Arrays.stream(expr.split(";")).filter(s -> !s.isEmpty()).map(s -> s.replace("L", "").replace("/", ".")).map(s -> {
            try {
                return Class.forName(s);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Can not found class - " + s, e);
            }
        }).toArray(Class[]::new);
        try {
            Class<?> aClass = Class.forName(serializedLambda.getImplClass().replace("/", "."));
            return aClass.getMethod(serializedLambda.getImplMethodName(), claArray);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> SerializedLambda getSerializedLambda(SFunction<T, ?> function) {
        SerializedLambda serializedLambda;
        Method writeReplaceMethod;
        try {
            writeReplaceMethod = function.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        boolean isAccessible = writeReplaceMethod.isAccessible();
        if (!isAccessible) {
            writeReplaceMethod.setAccessible(true);
        }
        try {
            serializedLambda = (SerializedLambda)writeReplaceMethod.invoke(function, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (!isAccessible) {
            writeReplaceMethod.setAccessible(false);
        }
        return serializedLambda;
    }

    public static <T> T newInstance(Class<T> cla, Object ... params) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<?>[] constructors;
        if (params.length == 0) {
            return cla.newInstance();
        }
        block0: for (Constructor<?> constructor : constructors = cla.getConstructors()) {
            if (constructor.getParameterCount() != params.length) continue;
            Class<?>[] types = constructor.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (!ReflectUtil.recalculate(types[i]).isAssignableFrom(params[i].getClass())) continue block0;
            }
            return (T)constructor.newInstance(params);
        }
        return null;
    }

    private static Class<?> recalculate(Class<?> cl) {
        switch (cl.getSimpleName()) {
            case "int": {
                cl = Integer.class;
                break;
            }
            case "double": {
                cl = Double.class;
                break;
            }
            case "float": {
                cl = Float.class;
                break;
            }
            case "byte": {
                cl = Byte.class;
                break;
            }
            case "short": {
                cl = Short.class;
                break;
            }
            case "long": {
                cl = Long.class;
                break;
            }
            case "boolean": {
                cl = Boolean.class;
                break;
            }
            case "char": {
                cl = Character.class;
                break;
            }
        }
        return cl;
    }
}

