/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.domain;

import java.util.HashMap;
import java.util.Map;

public abstract class Counter<T> {
    protected int defaultCount;
    protected final Map<T, Integer> countMap;

    public Counter() {
        this(0);
    }

    public Counter(int defaultCount) {
        this.defaultCount = defaultCount;
        this.countMap = new HashMap<T, Integer>();
    }

    public synchronized int getCount(T t) {
        return this.countMap.computeIfAbsent(t, k -> this.defaultCount);
    }

    public Integer getCountWithNull(T t) {
        return this.countMap.get(t);
    }

    public int count(T t) {
        return this.count(t, 1);
    }

    public synchronized int count(T t, int count) {
        int c = this.getCount(t) + count;
        this.countMap.put(t, c);
        return c;
    }

    public synchronized void setCount(T t, int count) {
        this.countMap.put(t, count);
    }

    public int getDefaultCount() {
        return this.defaultCount;
    }

    public synchronized void setDefaultCount(int defaultCount) {
        this.defaultCount = defaultCount;
    }

    public synchronized void clear(T t) {
        this.countMap.put(t, this.defaultCount);
    }

    public synchronized void clearAll() {
        this.countMap.clear();
    }
}

