/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.creator.data;

import idea.verlif.mock.data.MockDataCreator;
import idea.verlif.mock.data.creator.DataCreator;
import idea.verlif.mock.data.domain.MockSrc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DictDataCreator<T>
implements DataCreator<T> {
    protected final T[] arrays;
    private final Random random;

    public DictDataCreator(T[] arrays) {
        this.arrays = arrays;
        this.random = new Random();
    }

    @Override
    public T mock(MockSrc src, MockDataCreator.Creator creator) {
        if (this.arrays.length == 0) {
            return null;
        }
        if (this.arrays.length == 1) {
            return this.arrays[0];
        }
        return this.arrays[this.random.nextInt(this.arrays.length)];
    }

    @Override
    public List<Class<?>> types() {
        ArrayList list = new ArrayList();
        Class<?> cla = this.arrays.getClass().getComponentType();
        list.add(cla);
        return list;
    }
}

