/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.creator.data;

import idea.verlif.mock.data.MockDataCreator;
import idea.verlif.mock.data.creator.DataCreator;
import idea.verlif.mock.data.domain.MockSrc;
import java.util.Date;
import java.util.Random;

public class DateRandomCreator
implements DataCreator<Date> {
    private final long start;
    private final long end;
    private final Random random;

    public DateRandomCreator() {
        this(null, null);
    }

    public DateRandomCreator(Date start, Date end) {
        this.start = start == null ? 0L : start.getTime();
        this.end = end == null ? new Date().getTime() + 31536000000L : end.getTime();
        this.random = new Random();
    }

    @Override
    public Date mock(MockSrc src, MockDataCreator.Creator creator) {
        long offset = this.end - this.start;
        long ran = (long)(this.random.nextDouble() * (double)offset + (double)this.start);
        return new Date(ran);
    }
}

