/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.config.filter.impl;

import idea.verlif.mock.data.config.filter.ClassFilter;
import idea.verlif.mock.data.util.ContainsUtil;
import idea.verlif.mock.data.util.NamingUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ClassKeyFilter
implements ClassFilter {
    private final Set<Class<?>> ignoredClassSet = new HashSet();
    private final List<Pattern> ignoredClassPattern = new ArrayList<Pattern>();

    private void addIgnoredClass(Class<?> cla) {
        this.ignoredClassSet.add(cla);
    }

    public ClassKeyFilter ignoredClass(Class<?> ... clas) {
        for (Class<?> cla : clas) {
            this.addIgnoredClass(cla);
        }
        return this;
    }

    private void addIgnoredClassRegex(String regex) {
        this.ignoredClassPattern.add(Pattern.compile(regex));
    }

    public ClassKeyFilter ignoredClassRegex(String ... regex) {
        for (String s : regex) {
            this.addIgnoredClassRegex(s);
        }
        return this;
    }

    public ClassKeyFilter ignoredClassPackage(String ... packName) {
        for (String s : packName) {
            this.addIgnoredClassPackage(s);
        }
        return this;
    }

    private void addIgnoredClassPackage(String packName) {
        this.addIgnoredClassRegex(packName + ".*" + ".class");
    }

    @Override
    public boolean accept(Class<?> cla) {
        if (this.ignoredClassSet.contains(cla)) {
            return false;
        }
        return !ContainsUtil.checkContains(NamingUtil.getKeyName(cla), null, this.ignoredClassPattern);
    }
}

