/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.config;

import idea.verlif.mock.data.config.CommonConfig;
import idea.verlif.mock.data.config.SizeCreator;
import idea.verlif.mock.data.domain.counter.StringCounter;
import idea.verlif.mock.data.util.NamingUtil;
import idea.verlif.reflection.domain.SFunction;
import idea.verlif.reflection.util.ReflectUtil;

public class MockDataConfig
extends CommonConfig {
    private static final int ARRAY_SIZE = 5;
    private static final int DEFAULT_DEPTH = 2;
    private StringCounter depthCounter;
    private SizeCreator arraySizeCreator;
    private boolean autoCascade;
    private int fieldOptions = 0;

    public MockDataConfig copy() {
        MockDataConfig config = new MockDataConfig();
        config.depthCounter = this.depthCounter;
        config.arraySizeCreator = this.arraySizeCreator;
        config.fieldCreatorMap.putAll(this.fieldCreatorMap);
        config.interfaceCreatorMap.putAll(this.interfaceCreatorMap);
        config.instanceCreatorMap.putAll(this.instanceCreatorMap);
        config.autoCascade = this.autoCascade;
        config.cascadeCreateSet.addAll(this.cascadeCreateSet);
        config.cascadeCreatePattern.addAll(this.cascadeCreatePattern);
        config.fieldFilters.addAll(this.fieldFilters);
        config.classFilters.addAll(this.classFilters);
        config.fieldOptions = this.fieldOptions;
        config.fieldDataPool = this.fieldDataPool;
        return config;
    }

    public int getCreatingDepth(String key) {
        if (this.depthCounter == null) {
            return 2;
        }
        return this.depthCounter.getCount(key);
    }

    public MockDataConfig creatingDepth(int defaultDepth) {
        if (this.depthCounter == null) {
            this.depthCounter = new StringCounter(defaultDepth);
        } else {
            this.depthCounter.setDefaultCount(defaultDepth);
        }
        return this;
    }

    public <T> MockDataConfig creatingDepth(SFunction<T, ?> function, int depth) {
        this.setKeyDepth(NamingUtil.getKeyName(ReflectUtil.getFieldFromLambda(function)), depth);
        return this;
    }

    public MockDataConfig creatingDepth(Class<?> cla, int depth) {
        this.setKeyDepth(NamingUtil.getKeyName(cla), depth);
        return this;
    }

    private void setKeyDepth(String key, int depth) {
        if (this.depthCounter == null) {
            this.depthCounter = new StringCounter(2);
        }
        this.depthCounter.setCount(key, depth);
    }

    public int getArraySize(Class<?> cla) {
        if (this.arraySizeCreator == null) {
            return 5;
        }
        return this.arraySizeCreator.getSize(cla);
    }

    public MockDataConfig arraySize(int arraySize) {
        this.arraySizeCreator = new StaticSizeCreator(arraySize);
        return this;
    }

    public MockDataConfig arraySize(SizeCreator sizeCreator) {
        this.arraySizeCreator = sizeCreator;
        return this;
    }

    public boolean acceptFieldOption(int fieldOptions) {
        return (this.fieldOptions | fieldOptions) == this.fieldOptions;
    }

    public MockDataConfig appendFieldOption(int fieldOptions) {
        this.fieldOptions |= fieldOptions;
        return this;
    }

    public boolean isForceNew() {
        return (this.fieldOptions & 2) > 0;
    }

    public MockDataConfig forceNew(boolean forceNew) {
        this.fieldOptions |= 0xE;
        return this;
    }

    public int getFieldOptions() {
        return this.fieldOptions;
    }

    public MockDataConfig setFieldOptions(int fieldOptions) {
        this.fieldOptions = fieldOptions;
        return this;
    }

    public MockDataConfig autoCascade(boolean autoCascade) {
        this.autoCascade = autoCascade;
        return this;
    }

    @Override
    public boolean isCascadeCreate(String key) {
        return this.autoCascade || super.isCascadeCreate(key);
    }

    private static final class StaticSizeCreator
    implements SizeCreator {
        private final int size;

        public StaticSizeCreator(int size) {
            this.size = size;
        }

        @Override
        public int getSize(Class<?> cla) {
            return this.size;
        }
    }
}

