/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.config;

import idea.verlif.reflection.domain.SFunction;
import idea.verlif.reflection.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class FieldDataPool {
    private final Map<Class<?>, PatternValues<?>> patternValuesMap = new HashMap();

    public void addPatternValues(Class<?> cl, PatternValues<?> pv) {
        if (this.patternValuesMap.containsKey(cl)) {
            PatternValues<?> oldPv = this.patternValuesMap.get(cl);
            oldPv.addPatternValues(pv);
        } else {
            this.patternValuesMap.put(cl, pv);
        }
    }

    public <T> T[] getValues(Class<?> cl) {
        return this.getValues(cl, "");
    }

    public <T> T[] getValues(Class<?> cl, String key) {
        PatternValues<?> patternValues = this.patternValuesMap.get(cl);
        if (patternValues != null) {
            return patternValues.getValues(key);
        }
        return null;
    }

    public <T> PatternValues<T> type(Class<? extends T> cl, T ... values) {
        return this.type(cl, null, values);
    }

    public <T> PatternValues<T> type(Class<? extends T> cl, String fieldName, T ... values) {
        PatternValues<Object> pv = this.patternValuesMap.get(cl);
        if (pv == null) {
            pv = new PatternValues();
            this.patternValuesMap.put(cl, pv);
        }
        if (values.length == 0) {
            return pv;
        }
        if (fieldName == null) {
            return pv.values(values);
        }
        return pv.values(values, fieldName);
    }

    public <C, T> PatternValues<T> like(SFunction<C, T> function, T ... values) {
        Field field = ReflectUtil.getFieldFromLambda(function);
        return this.like(field.getType(), field.getName(), values);
    }

    public <T> PatternValues<T> like(Class<? extends T> cl, String fieldName, T ... values) {
        PatternValues<Object> pv = this.type(cl, new Object[0]);
        pv.values(values, ".*" + fieldName + ".*", 2);
        return pv;
    }

    public final class PatternValues<T> {
        private final ArrayList<Pattern> patterns = new ArrayList();
        private final ArrayList<T[]> values = new ArrayList();

        public PatternValues<T> values(T ... values) {
            return this.values(values, ".*");
        }

        public PatternValues<T> values(T[] values, String ... regexes) {
            for (String regex : regexes) {
                this.patterns.add(Pattern.compile(regex));
                this.values.add(values);
            }
            return this;
        }

        public PatternValues<T> values(T[] values, String regex, int flags) {
            this.patterns.add(Pattern.compile(regex, flags));
            this.values.add(values);
            return this;
        }

        public synchronized void addPatternValues(PatternValues<?> pv) {
            for (T[] value : pv.values) {
                this.values.add(value);
            }
            for (Pattern pattern : pv.patterns) {
                this.patterns.add(pattern);
            }
        }

        public FieldDataPool next() {
            return FieldDataPool.this;
        }

        public boolean isMatched(String str) {
            if (this.patterns.size() == 0) {
                return true;
            }
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(str).matches()) continue;
                return true;
            }
            return false;
        }

        public T[] getValues(String str) {
            for (int i = 0; i < this.patterns.size(); ++i) {
                Pattern pattern = this.patterns.get(i);
                if (!pattern.matcher(str).matches()) continue;
                return this.values.get(i);
            }
            return null;
        }
    }
}

