/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.ztest;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.UnsupportedStyleException;
import nl.fountain.xelem.XFactory;
import nl.fountain.xelem.XelemException;
import nl.fountain.xelem.excel.NamedRange;
import nl.fountain.xelem.excel.Worksheet;
import nl.fountain.xelem.excel.ss.XLWorkbook;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StyleFactoryWorkbook
extends XLWorkbook {
    protected XFactory xFactory;
    private Document doc;

    public StyleFactoryWorkbook() {
        super("xelem");
    }

    public StyleFactoryWorkbook(String name) {
        super(name);
    }

    public Element createStyle(String id) throws ParserConfigurationException {
        Element style = this.getDoc().createElement("Style");
        Attr attr = this.getDoc().createAttributeNS("urn:schemas-microsoft-com:office:spreadsheet", "ID");
        attr.setPrefix("ss");
        attr.setNodeValue(id);
        style.setAttributeNodeNS(attr);
        return style;
    }

    public Element createFont() throws ParserConfigurationException {
        Element font = this.getDoc().createElement("Font");
        Attr attr = this.getDoc().createAttributeNS("urn:schemas-microsoft-com:office:spreadsheet", "Color");
        attr.setPrefix("ss");
        attr.setNodeValue("#00FF00");
        font.setAttributeNodeNS(attr);
        return font;
    }

    @Override
    public Document createDocument() throws ParserConfigurationException {
        GIO gio = new GIO();
        Document doc = this.getDoc();
        Element root = doc.getDocumentElement();
        this.assemble(root, gio);
        return doc;
    }

    public XFactory getFactory() {
        if (this.xFactory == null) {
            try {
                this.xFactory = XFactory.newInstance();
            }
            catch (XelemException e) {
                this.xFactory = XFactory.emptyFactory();
            }
        }
        return this.xFactory;
    }

    @Override
    public void mergeStyles(String newID, String id1, String id2) throws UnsupportedStyleException {
        this.getFactory().mergeStyles(newID, id1, id2);
    }

    @Override
    public Element assemble(Element root, GIO gio) {
        Document doc = root.getOwnerDocument();
        gio.setPrintComments(this.isPrintingElementComments());
        doc.insertBefore(doc.createProcessingInstruction("mso-application", "progid=\"Excel.Sheet\""), root);
        if (this.isPrintingDocComments()) {
            for (String s : this.getFactory().getDocComments()) {
                doc.insertBefore(doc.createComment(s), root);
            }
        }
        root.setAttribute("xmlns", "urn:schemas-microsoft-com:office:spreadsheet");
        root.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        root.setAttribute("xmlns:x", "urn:schemas-microsoft-com:office:excel");
        root.setAttribute("xmlns:ss", "urn:schemas-microsoft-com:office:spreadsheet");
        root.setAttribute("xmlns:html", "http://www.w3.org/TR/REC-html40");
        if (this.isPrintingElementComments() && this.getElementComments() != null) {
            for (String s : this.getElementComments()) {
                root.appendChild(doc.createComment(s));
            }
        }
        if (this.hasDocumentProperties()) {
            super.getDocumentProperties().assemble(root, gio);
        }
        Element xlwbe = this.getExcelWorkbook().assemble(root, gio);
        Element styles = doc.createElement("Styles");
        root.appendChild(styles);
        this.appendDefaultStyle(doc, styles);
        if (this.getNamedRanges().size() > 0) {
            Element names = doc.createElement("Names");
            root.appendChild(names);
            for (NamedRange nr : this.getNamedRanges().values()) {
                nr.assemble(names, gio);
            }
        }
        if (this.getWorksheets().size() < 1) {
            this.addSheet();
        }
        for (Worksheet ws : this.getWorksheets()) {
            ws.assemble(root, gio);
        }
        int selectedSheets = gio.getSelectedSheetsCount();
        if (selectedSheets > 1) {
            Element n = doc.createElementNS("urn:schemas-microsoft-com:office:excel", "SelectedSheets");
            n.setPrefix("x");
            n.appendChild(doc.createTextNode("" + selectedSheets));
            xlwbe.appendChild(n);
        }
        this.appendStyles(doc, styles, gio);
        return root;
    }

    private Document getDoc() throws ParserConfigurationException {
        if (this.doc == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            this.doc = domImpl.createDocument("urn:schemas-microsoft-com:office:spreadsheet", this.getTagName(), null);
        }
        return this.doc;
    }

    private void appendDefaultStyle(Document doc, Element styles) {
        Element dse = this.getFactory().getStyle("Default");
        if (dse == null) {
            dse = doc.createElement("Style");
            dse.setAttributeNodeNS(this.createAttributeNS(doc, "ID", "Default"));
            dse.setAttributeNodeNS(this.createAttributeNS(doc, "Name", "Normal"));
            Element alignment = doc.createElement("Alignment");
            dse.appendChild(alignment);
            alignment.setAttributeNodeNS(this.createAttributeNS(doc, "Vertical", "Bottom"));
            dse.appendChild(doc.createElement("Borders"));
            dse.appendChild(doc.createElement("Font"));
            dse.appendChild(doc.createElement("Interior"));
            dse.appendChild(doc.createElement("NumberFormat"));
            dse.appendChild(doc.createElement("Protection"));
        } else {
            dse = (Element)doc.importNode(dse, true);
        }
        styles.appendChild(dse);
    }

    private void appendStyles(Document doc, Element styles, GIO gio) {
        for (String id : gio.getStyleIDSet()) {
            Element style = this.getFactory().getStyle(id);
            if (style == null) {
                style = doc.createElement("Style");
                style.setAttributeNodeNS(this.createAttributeNS(doc, "ID", id));
            } else {
                style = (Element)doc.importNode(style, true);
            }
            styles.appendChild(style);
        }
    }
}

