/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import nl.fountain.xelem.excel.o.ODocumentProperties;
import nl.fountain.xelem.excel.ss.SSNamedRange;
import nl.fountain.xelem.excel.ss.SSWorksheet;
import nl.fountain.xelem.excel.x.XExcelWorkbook;
import nl.fountain.xelem.lex.AnonymousBuilder;
import nl.fountain.xelem.lex.Director;
import nl.fountain.xelem.lex.ExcelReaderListener;
import nl.fountain.xelem.lex.SSWorksheetBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class XLWorkbookBuilder
extends AnonymousBuilder {
    private int sheetCounter;

    XLWorkbookBuilder(Director director) {
        super(director);
    }

    @Override
    public void build(XMLReader reader, ContentHandler parent) {
        super.build(reader, parent);
        this.sheetCounter = 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("urn:schemas-microsoft-com:office:office".equals(uri) && "DocumentProperties".equals(localName)) {
            ODocumentProperties docprops = new ODocumentProperties();
            AnonymousBuilder builder = this.director.getAnonymousBuilder();
            builder.build(this.reader, this, docprops);
        } else if ("urn:schemas-microsoft-com:office:excel".equals(uri) && "ExcelWorkbook".equals(localName)) {
            XExcelWorkbook xlwb = new XExcelWorkbook();
            AnonymousBuilder builder = this.director.getAnonymousBuilder();
            builder.build(this.reader, this, xlwb);
        } else if ("urn:schemas-microsoft-com:office:spreadsheet".equals(uri) && "NamedRange".equals(localName)) {
            SSNamedRange nr = new SSNamedRange(atts.getValue("urn:schemas-microsoft-com:office:spreadsheet", "Name"), null);
            nr.setAttributes(atts);
            for (ExcelReaderListener listener : this.director.getListeners()) {
                listener.setNamedRange(nr);
            }
        } else if ("urn:schemas-microsoft-com:office:spreadsheet".equals(uri) && "Worksheet".equals(localName)) {
            String sheetName = atts.getValue("urn:schemas-microsoft-com:office:spreadsheet", "Name");
            SSWorksheet sheet = new SSWorksheet(sheetName);
            this.director.setCurrentSheetIndex(this.sheetCounter);
            this.director.setCurrentSheetName(sheetName);
            sheet.setAttributes(atts);
            for (ExcelReaderListener listener : this.director.getListeners()) {
                listener.startWorksheet(this.sheetCounter, sheet);
            }
            ++this.sheetCounter;
            SSWorksheetBuilder builder = this.director.getSSWorksheetBuilder();
            builder.build(this.reader, this);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("urn:schemas-microsoft-com:office:spreadsheet".equals(uri) && "Workbook".equals(localName)) {
            this.reader.setContentHandler(this.parent);
            return;
        }
    }
}

