/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import java.io.File;
import nl.fountain.xelem.excel.AutoFilter;
import nl.fountain.xelem.excel.Column;
import nl.fountain.xelem.excel.DocumentProperties;
import nl.fountain.xelem.excel.ExcelWorkbook;
import nl.fountain.xelem.excel.NamedRange;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.Table;
import nl.fountain.xelem.excel.Workbook;
import nl.fountain.xelem.excel.Worksheet;
import nl.fountain.xelem.excel.WorksheetOptions;
import nl.fountain.xelem.excel.ss.XLWorkbook;
import nl.fountain.xelem.lex.DefaultExcelReaderListener;

public class WorkbookListener
extends DefaultExcelReaderListener {
    private Workbook currentWorkbook;
    private Worksheet currentWorksheet;
    private Table currentTable;

    public Workbook getWorkbook() {
        return this.currentWorkbook;
    }

    @Override
    public void startWorkbook(String systemID) {
        this.currentWorkbook = new XLWorkbook(this.getWorkbookName(systemID));
        this.currentWorkbook.setFileName(systemID);
    }

    @Override
    public void setDocumentProperties(DocumentProperties docProps) {
        this.currentWorkbook.setDocumentProperties(docProps);
    }

    @Override
    public void setExcelWorkbook(ExcelWorkbook excelWb) {
        this.currentWorkbook.setExcelWorkbook(excelWb);
    }

    @Override
    public void setNamedRange(NamedRange namedRange) {
        this.currentWorkbook.addNamedRange(namedRange);
    }

    @Override
    public void startWorksheet(int sheetIndex, Worksheet sheet) {
        this.currentWorksheet = sheet;
        this.currentWorkbook.addSheet(this.currentWorksheet);
    }

    @Override
    public void setNamedRange(int sheetIndex, String sheetName, NamedRange namedRange) {
        this.currentWorksheet.addNamedRange(namedRange);
    }

    @Override
    public void startTable(int sheetIndex, String sheetName, Table table) {
        this.currentTable = table;
        this.currentWorksheet.setTable(table);
    }

    @Override
    public void setColumn(int sheetIndex, String sheetName, Column column) {
        this.currentTable.addColumnAt(column.getIndex(), column);
    }

    @Override
    public void setRow(int sheetIndex, String sheetName, Row row) {
        this.currentTable.addRowAt(row.getIndex(), row);
    }

    @Override
    public void setWorksheetOptions(int sheetIndex, String sheetName, WorksheetOptions wsOptions) {
        this.currentWorksheet.setWorksheetOptions(wsOptions);
    }

    @Override
    public void setAutoFilter(int sheetIndex, String sheetName, AutoFilter autoFilter) {
        this.currentWorksheet.setAutoFilter(autoFilter);
    }

    private String getWorkbookName(String systemId) {
        File file = new File(systemId);
        String[] s = file.getName().split("\\.");
        if (s.length > 0) {
            return s[0];
        }
        return "";
    }
}

