/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nl.fountain.xelem.Area;
import nl.fountain.xelem.excel.Workbook;
import nl.fountain.xelem.lex.Director;
import nl.fountain.xelem.lex.ExcelReaderListener;
import nl.fountain.xelem.lex.WorkbookListener;
import nl.fountain.xelem.lex.XLWorkbookBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ExcelReader {
    private SAXParser parser;
    XMLReader reader;
    Director director;
    private Handler handler;
    private Map<String, String> uris;

    public ExcelReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        this.parser = spf.newSAXParser();
        this.director = new Director();
    }

    public ExcelReader(SAXParser parser) throws ParserConfigurationException {
        if (!parser.isNamespaceAware()) {
            throw new ParserConfigurationException("cannot read with a parser that is unaware of namespaces.");
        }
        this.parser = parser;
        this.director = new Director();
    }

    public SAXParser getSaxParser() {
        return this.parser;
    }

    public void setReadArea(Area area) {
        this.director.setBuildArea(area);
    }

    public void clearReadArea() {
        this.director.setBuildArea(null);
    }

    public Area getReadArea() {
        if (this.director.hasBuildArea()) {
            return this.director.getBuildArea();
        }
        return null;
    }

    public boolean hasReadArea() {
        return this.director.hasBuildArea();
    }

    public List<ExcelReaderListener> getListeners() {
        return this.director.getListeners();
    }

    public void addExcelReaderListener(ExcelReaderListener listener) {
        this.director.addExcelReaderListener(listener);
    }

    public boolean removeExcelReaderListener(ExcelReaderListener listener) {
        return this.director.removeExcelReaderListener(listener);
    }

    public void clearExcelReaderListeners() {
        this.director.clearExcelReaderListeners();
    }

    public Workbook getWorkbook(String fileName) throws IOException, SAXException {
        InputSource in = new InputSource(fileName);
        return this.getWorkbook(in);
    }

    public Workbook getWorkbook(InputSource source) throws IOException, SAXException {
        WorkbookListener wbl = new WorkbookListener();
        this.addExcelReaderListener(wbl);
        this.read(source);
        this.removeExcelReaderListener(wbl);
        return wbl.getWorkbook();
    }

    public void read(String fileName) throws IOException, SAXException {
        InputSource in = new InputSource(fileName);
        this.read(in);
    }

    public void read(InputSource source) throws IOException, SAXException {
        this.getPrefixMap().clear();
        this.reader = this.parser.getXMLReader();
        this.reader.setContentHandler(this.getHandler());
        this.reader.setErrorHandler(this.getHandler());
        this.reader.parse(source);
    }

    public Map<String, String> getPrefixMap() {
        if (this.uris == null) {
            this.uris = new HashMap<String, String>();
        }
        return this.uris;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    private class Handler
    extends DefaultHandler {
        private Locator locator;

        private Handler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            for (ExcelReaderListener listener : ExcelReader.this.director.getListeners()) {
                listener.processingInstruction(target, data);
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            ExcelReader.this.getPrefixMap().put(prefix, uri);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("urn:schemas-microsoft-com:office:spreadsheet".equals(uri) && "Workbook".equals(localName)) {
                String systemId = this.getSystemId();
                XLWorkbookBuilder builder = ExcelReader.this.director.getXLWorkbookBuilder();
                for (ExcelReaderListener listener : ExcelReader.this.director.getListeners()) {
                    listener.startWorkbook(systemId);
                }
                builder.build(ExcelReader.this.reader, this);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            for (ExcelReaderListener listener : ExcelReader.this.director.getListeners()) {
                listener.startDocument();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            for (ExcelReaderListener listener : ExcelReader.this.director.getListeners()) {
                listener.endDocument(ExcelReader.this.getPrefixMap());
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        private String getSystemId() {
            String systemId = null;
            if (this.locator != null) {
                systemId = this.locator.getSystemId();
            }
            if (systemId == null) {
                systemId = "source";
            }
            return systemId;
        }
    }
}

