/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.expat;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import nl.fountain.xelem.XSerializer;
import nl.fountain.xelem.XelemException;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.ss.SSCell;
import nl.fountain.xelem.excel.ss.SSRow;
import nl.fountain.xelem.expat.XLDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XLDocumentTest
extends TestCase {
    private String testOutputDir = "testoutput/XLDocumentTest/";
    private boolean toFile = true;
    private String templateFile;

    public static void main(String[] args) {
        TestRunner.run(XLDocumentTest.class);
    }

    public void setUp() {
        this.templateFile = "testsuitefiles/XLDocumentTest/aviso.xml";
    }

    public void testAdvise() {
        if (this.toFile) {
            System.out.println();
            System.out.println(((Object)((Object)this)).getClass() + " is writing files to: " + this.testOutputDir);
        }
    }

    public void testConstructor() {
        try {
            new XLDocument("this/file/does/not/exist");
            XLDocumentTest.fail((String)"geen exceptie gegooid.");
        }
        catch (XelemException e) {
            XLDocumentTest.assertEquals((String)"java.io.FileNotFoundException", (String)e.getCause().getClass().getName());
        }
        try {
            XLDocument xldoc = new XLDocument(this.templateFile);
            XLDocumentTest.assertNotNull((Object)xldoc.getDocument());
        }
        catch (XelemException e1) {
            XLDocumentTest.fail((String)e1.getMessage());
        }
    }

    public void testGetTable() throws Exception {
        XLDocument xldoc = new XLDocument(this.templateFile);
        Element table = xldoc.getTableElement("Sheet1");
        XLDocumentTest.assertNotNull((Object)table);
        try {
            table.getAttributes().removeNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "ExpandedColumnCount");
            XLDocumentTest.fail((String)"should have thrown exception.");
        }
        catch (DOMException e) {
            // empty catch block
        }
        try {
            table.getAttributes().removeNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "ExpandedRowCount");
            XLDocumentTest.fail((String)"should have thrown exception.");
        }
        catch (DOMException e) {
            // empty catch block
        }
        try {
            xldoc.getTableElement("nosheetwiththisname");
            XLDocumentTest.fail((String)"should have thrown exception.");
        }
        catch (RuntimeException e1) {
            XLDocumentTest.assertEquals((String)"The worksheet 'nosheetwiththisname' does not exist.", (String)e1.getMessage());
        }
    }

    public void testAppendRow() throws Exception {
        SSRow row = new SSRow();
        row.addCell("419900");
        row.addCell("wk 43, piet 45,8 u.");
        row.addCell("002020");
        row.addCell(-12345.67);
        XLDocument xldoc = new XLDocument(this.templateFile);
        xldoc.appendRow("Sheet1", row);
        Document doc = xldoc.getDocument();
        String xml = this.serialize(doc);
        String expected = "<Data ss:Type=\"Number\">-12345.67</Data>";
        XLDocumentTest.assertTrue((xml.indexOf(expected) > 0 ? 1 : 0) != 0);
        if (this.toFile) {
            this.serialize(doc, this.testOutputDir + "aviso01.xls");
        }
    }

    public void testAppendRows() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        SSRow row = new SSRow();
        row.addCell("501000");
        row.addCell("wk 02, Claude 5,8 u.");
        row.addCell("123456");
        row.addCell(45.67);
        rows.add(row);
        row = new SSRow();
        row.addCell("551000");
        row.addCell("wk 02, Claude voor 123456 5,8 u.");
        row.addCell("002020");
        row.addCell(-45.67);
        rows.add(row);
        XLDocument xldoc = new XLDocument(this.templateFile);
        xldoc.appendRows("Sheet1", rows);
        SSCell cell = new SSCell();
        cell.setData(new Date());
        xldoc.setCellData(cell, "Sheet1", 7, 2);
        Document doc = xldoc.getDocument();
        String xml = this.serialize(doc);
        String expected = "<Data ss:Type=\"Number\">-45.67</Data>";
        XLDocumentTest.assertTrue((xml.indexOf(expected) > 0 ? 1 : 0) != 0);
        expected = "<Data ss:Type=\"String\">wk 02, Claude voor 123456 5,8 u.</Data>";
        XLDocumentTest.assertTrue((xml.indexOf(expected) > 0 ? 1 : 0) != 0);
        if (this.toFile) {
            this.serialize(doc, this.testOutputDir + "aviso02.xls");
        }
    }

    public void testSetCellData() throws Exception {
        XLDocument xldoc = new XLDocument(this.templateFile);
        SSCell cell = new SSCell();
        cell.setData("nieuw gegeven");
        xldoc.setCellData(cell, "Sheet1", 1, 2);
        Document doc = xldoc.getDocument();
        String xml = this.serialize(doc);
        String expected = "<Data ss:Type=\"String\">nieuw gegeven</Data>";
        XLDocumentTest.assertTrue((xml.indexOf(expected) > 0 ? 1 : 0) != 0);
    }

    public void testPivotWithNamedRange() throws Exception {
        if (this.toFile) {
            Collection<Row> rows = this.getData();
            String template = "testsuitefiles/XLDocumentTest/prices0.xml";
            XLDocument xlDoc = new XLDocument(template);
            SSCell cel = new SSCell();
            cel.setData("created on " + new Date());
            xlDoc.setCellData(cel, "average prices", 1, 5);
            xlDoc.appendRows("data", rows);
            String fileName = "prices_nr.xls";
            xlDoc.setPTSourceFileName(fileName);
            this.serialize(xlDoc.getDocument(), this.testOutputDir + fileName);
        }
    }

    public void testPivotWithRange() throws Exception {
        String template = "testsuitefiles/XLDocumentTest/prices1.1.xml";
        XLDocument xlDoc = new XLDocument(template);
        Collection<Row> rows = this.getData();
        SSCell cel = new SSCell();
        cel.setData("created on " + new Date());
        xlDoc.setCellData(cel, "prices", 1, 1);
        xlDoc.appendRows("Sheet1", rows);
        String fileName = "prices r.xls";
        XLDocumentTest.assertEquals((int)1, (int)xlDoc.setPTSourceFileName(fileName, "Sheet1"));
        xlDoc.setPTSourceReference(1, 1, rows.size() + 1, 5);
        if (this.toFile) {
            this.serialize(xlDoc.getDocument(), this.testOutputDir + fileName);
        }
    }

    public void testPivot() {
        Object[][] data = new Object[][]{{"blue", "A", "Star", new Double(2.95), new Double(55.6)}, {"red", "A", "Planet", new Double(3.1), new Double(123.5)}, {"green", "C", "Star", new Double(3.21), new Double(20.356)}, {"green", "B", "Star", new Double(4.23), new Double(456.0)}, {"red", "B", "Planet", new Double(4.21), new Double(789.0)}, {"blue", "D", "Planet", new Double(4.51), new Double(9.6)}, {"yellow", "A", "Commet", new Double(4.15), new Double(19.8)}};
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int r = 0; r < data.length; ++r) {
            SSRow row = new SSRow();
            for (int c = 0; c < data[r].length; ++c) {
                row.addCell(data[r][c]);
            }
            rows.add(row);
        }
        try {
            XLDocument xlDoc = new XLDocument("testsuitefiles/XLDocumentTest/prices0.xml");
            xlDoc.appendRows("data", rows);
            String fileName = "prices.xls";
            xlDoc.setPTSourceFileName(fileName, "data");
            xlDoc.setPTSourceReference(1, 1, rows.size() + 1, 5);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.testOutputDir + fileName));
            new XSerializer().serialize(xlDoc.getDocument(), (OutputStream)out);
            ((OutputStream)out).close();
        }
        catch (XelemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Collection<Row> getData() {
        Object[][] data = new Object[][]{{"blue", "A", "Star", new Double(2.95), new Double(55.6)}, {"red", "A", "Planet", new Double(3.1), new Double(123.5)}, {"green", "C", "Star", new Double(3.21), new Double(20.356)}, {"green", "B", "Star", new Double(4.23), new Double(456.0)}, {"red", "B", "Planet", new Double(4.21), new Double(789.0)}, {"blue", "D", "Planet", new Double(4.51), new Double(9.6)}, {"yellow", "A", "Commet", new Double(4.15), new Double(19.8)}};
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int r = 0; r < data.length; ++r) {
            SSRow row = new SSRow();
            for (int c = 0; c < data[r].length; ++c) {
                row.addCell(data[r][c]);
            }
            rows.add(row);
        }
        return rows;
    }

    private void serialize(Document doc, String fileName) throws Exception {
        FileOutputStream out = new FileOutputStream(fileName);
        this.serialize(doc, out);
        ((OutputStream)out).close();
    }

    private String serialize(Document doc) throws Exception {
        XSerializer xs = new XSerializer("US-ASCII");
        StringWriter sw = new StringWriter();
        xs.serialize(doc, (Writer)sw);
        return sw.toString();
    }

    private void serialize(Document doc, OutputStream out) throws Exception {
        XSerializer xs = new XSerializer("US-ASCII");
        xs.serialize(doc, out);
    }
}

