/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import junit.textui.TestRunner;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Column;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.Table;
import nl.fountain.xelem.excel.Worksheet;
import nl.fountain.xelem.excel.WorksheetOptions;
import nl.fountain.xelem.excel.XLElementTest;
import nl.fountain.xelem.excel.ss.SSCell;
import nl.fountain.xelem.excel.ss.SSWorksheet;

public class SSWorksheetTest
extends XLElementTest {
    private Worksheet ws;

    public static void main(String[] args) {
        TestRunner.run(SSWorksheetTest.class);
    }

    protected void setUp() throws Exception {
        this.ws = new SSWorksheet("Sheet1");
    }

    public void testConstructor() {
        SSWorksheetTest.assertEquals((String)"Sheet1", (String)this.ws.getName());
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getCellPointer().getHorizontalStepDistance());
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getCellPointer().getVerticalStepDistance());
        SSWorksheetTest.assertEquals((int)0, (int)this.ws.getCellPointer().getMovement());
        SSWorksheet ws2 = new SSWorksheet("Blad1");
        SSWorksheetTest.assertEquals((String)"Blad1", (String)ws2.getName());
        SSWorksheet ws3 = new SSWorksheet("this & that");
        SSWorksheetTest.assertEquals((String)"this & that", (String)ws3.getName());
        SSWorksheet ws4 = new SSWorksheet(null);
        SSWorksheetTest.assertEquals(null, (String)ws4.getName());
    }

    public void testGetTable() {
        SSWorksheetTest.assertNotNull((Object)this.ws.getTable());
        Table table = this.ws.getTable();
        SSWorksheetTest.assertSame((Object)table, (Object)this.ws.getTable());
        Table table3 = this.ws.getTable();
        SSWorksheetTest.assertSame((Object)table, (Object)this.ws.getTable());
        SSWorksheetTest.assertSame((Object)table3, (Object)this.ws.getTable());
    }

    public void testAddCell() {
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getCellPointer().getRowIndex());
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getCellPointer().getColumnIndex());
        Cell cell = this.ws.addCell();
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getCellPointer().getRowIndex());
        SSWorksheetTest.assertEquals((int)2, (int)this.ws.getCellPointer().getColumnIndex());
        SSWorksheetTest.assertNotNull((Object)cell);
        Cell rCell = this.ws.getCellAt(1, 1);
        SSWorksheetTest.assertSame((Object)cell, (Object)rCell);
        Cell rCell2 = this.ws.getTable().getRowAt(1).getCellAt(1);
        SSWorksheetTest.assertSame((Object)cell, (Object)rCell2);
    }

    public void testAddCellRC() {
        Cell cell = this.ws.addCellAt(5, 7);
        SSWorksheetTest.assertEquals((int)5, (int)this.ws.getCellPointer().getRowIndex());
        SSWorksheetTest.assertEquals((int)8, (int)this.ws.getCellPointer().getColumnIndex());
        SSWorksheetTest.assertNotNull((Object)cell);
        Cell rCell = this.ws.getCellAt(5, 7);
        SSWorksheetTest.assertSame((Object)cell, (Object)rCell);
        Cell rCell2 = this.ws.getTable().getRowAt(5).getCellAt(7);
        SSWorksheetTest.assertSame((Object)cell, (Object)rCell2);
        Cell rCell3 = this.ws.getRowAt(5).getCellAt(7);
        SSWorksheetTest.assertSame((Object)cell, (Object)rCell3);
    }

    public void testAddCellCell() {
        SSCell cell = new SSCell();
        this.ws.addCell(cell);
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getCellPointer().getRowIndex());
        SSWorksheetTest.assertEquals((int)2, (int)this.ws.getCellPointer().getColumnIndex());
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getTable().rowCount());
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getRowAt(1).size());
        Cell rCell = this.ws.getCellAt(1, 1);
        SSWorksheetTest.assertSame((Object)cell, (Object)rCell);
        Cell rCell2 = this.ws.getTable().getRowAt(1).getCellAt(1);
        SSWorksheetTest.assertSame((Object)cell, (Object)rCell2);
    }

    public void testAddCell_CellPointer() {
        this.ws.getCellPointer().moveTo(5, 60);
        Cell cell = this.ws.addCell();
        SSWorksheetTest.assertSame((Object)cell, (Object)this.ws.getCellAt(5, 60));
        this.ws.getCellPointer().move(1, -60);
        Cell cell2 = this.ws.addCell();
        SSWorksheetTest.assertSame((Object)cell2, (Object)this.ws.getCellAt(6, 1));
        this.ws.getCellPointer().moveTo(10, 256);
        Cell cell3 = this.ws.addCell();
        SSWorksheetTest.assertSame((Object)cell3, (Object)this.ws.getCellAt(10, 256));
        Cell cell4 = null;
        try {
            cell4 = this.ws.addCell();
            SSWorksheetTest.fail((String)"geen exceptie gegooid.");
        }
        catch (IndexOutOfBoundsException e) {
            SSWorksheetTest.assertEquals((String)"columnIndex = 257", (String)e.getMessage());
        }
        SSWorksheetTest.assertNull((Object)cell4);
        SSWorksheetTest.assertEquals((int)256, (int)this.ws.getTable().maxCellIndex());
        SSWorksheetTest.assertEquals((int)258, (int)this.ws.getCellPointer().getColumnIndex());
    }

    public void testRemoveCell() {
        SSWorksheetTest.assertNull((Object)this.ws.removeCellAt(5, 9));
        Cell cell = this.ws.addCellAt(5, 9);
        Cell cell2 = this.ws.removeCellAt(5, 9);
        SSWorksheetTest.assertSame((Object)cell, (Object)cell2);
    }

    public void testAddColumn() {
        SSWorksheetTest.assertEquals((int)0, (int)this.ws.getTable().maxColumnIndex());
        SSWorksheetTest.assertEquals((int)0, (int)this.ws.getTable().columnCount());
        Column column = this.ws.addColumn();
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getTable().maxColumnIndex());
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getTable().columnCount());
        Column column2 = this.ws.getColumnAt(1);
        SSWorksheetTest.assertSame((Object)column, (Object)column2);
        Column column3 = this.ws.addColumn();
        SSWorksheetTest.assertEquals((int)2, (int)this.ws.getTable().maxColumnIndex());
        SSWorksheetTest.assertEquals((int)2, (int)this.ws.getTable().columnCount());
        Column column4 = this.ws.getColumnAt(2);
        SSWorksheetTest.assertSame((Object)column3, (Object)column4);
        SSWorksheetTest.assertNotSame((Object)column4, (Object)column2);
    }

    public void testAddColumnint() {
        Column column = this.ws.addColumnAt(5);
        SSWorksheetTest.assertEquals((int)5, (int)this.ws.getTable().maxColumnIndex());
        SSWorksheetTest.assertEquals((int)1, (int)this.ws.getTable().columnCount());
        Column column5 = this.ws.getColumnAt(5);
        SSWorksheetTest.assertSame((Object)column, (Object)column5);
        Column column6 = this.ws.addColumn();
        SSWorksheetTest.assertEquals((int)6, (int)this.ws.getTable().maxColumnIndex());
        SSWorksheetTest.assertEquals((int)2, (int)this.ws.getTable().columnCount());
        Column column6r = this.ws.getColumnAt(6);
        SSWorksheetTest.assertSame((Object)column6, (Object)column6r);
        Column column300 = null;
        try {
            column300 = this.ws.addColumnAt(300);
            SSWorksheetTest.fail((String)"geen exceptie gegooid.");
        }
        catch (IndexOutOfBoundsException e) {
            SSWorksheetTest.assertEquals((String)"columnIndex = 300", (String)e.getMessage());
        }
        SSWorksheetTest.assertNull((Object)column300);
    }

    public void testColumnExceptions() {
        SSWorksheetTest.assertFalse((boolean)this.ws.hasColumnAt(""));
        SSWorksheetTest.assertFalse((boolean)this.ws.hasColumnAt("ALL"));
        SSWorksheetTest.assertNotNull((Object)this.ws.getColumnAt("BQ"));
        SSWorksheetTest.assertNull((Object)this.ws.removeColumnAt("ALL"));
        try {
            this.ws.getColumnAt("");
            SSWorksheetTest.fail((String)"should be error");
        }
        catch (IndexOutOfBoundsException e) {
            SSWorksheetTest.assertEquals((String)"columnIndex = 0", (String)e.getMessage());
        }
    }

    public void testRowExceptions() {
        SSWorksheetTest.assertFalse((boolean)this.ws.hasRowAt(0));
        SSWorksheetTest.assertFalse((boolean)this.ws.hasRowAt(123456789));
        SSWorksheetTest.assertNotNull((Object)this.ws.getRowAt(10));
        SSWorksheetTest.assertNull((Object)this.ws.removeRowAt(-3));
        try {
            this.ws.getRowAt(66666666);
            SSWorksheetTest.fail((String)"should be error");
        }
        catch (IndexOutOfBoundsException e) {
            SSWorksheetTest.assertEquals((String)"rowIndex = 66666666", (String)e.getMessage());
        }
    }

    public void testAddGetHasColumn() {
        SSWorksheetTest.assertFalse((boolean)this.ws.hasColumnAt(7));
        SSWorksheetTest.assertFalse((boolean)this.ws.hasTable());
        Column col1 = this.ws.getColumnAt(7);
        SSWorksheetTest.assertNotNull((Object)col1);
        Column col2 = this.ws.addColumnAt(7);
        SSWorksheetTest.assertNotSame((Object)col1, (Object)col2);
    }

    public void testAddGetHasRow() {
        SSWorksheetTest.assertFalse((boolean)this.ws.hasRowAt(7));
        SSWorksheetTest.assertFalse((boolean)this.ws.hasTable());
        Row row1 = this.ws.getRowAt(7);
        SSWorksheetTest.assertNotNull((Object)row1);
        Row row2 = this.ws.addRowAt(7);
        SSWorksheetTest.assertNotSame((Object)row1, (Object)row2);
    }

    public void testAddGetHasCell() {
        SSWorksheetTest.assertFalse((boolean)this.ws.hasCellAt(7, 3));
        SSWorksheetTest.assertFalse((boolean)this.ws.hasTable());
        Cell cell1 = this.ws.getCellAt(7, 3);
        SSWorksheetTest.assertNotNull((Object)cell1);
        Cell cell2 = this.ws.addCellAt(7, 3);
        SSWorksheetTest.assertNotSame((Object)cell1, (Object)cell2);
    }

    public void testAssemble() {
        this.ws.addRowAt(5);
        this.ws.setProtected(true);
        this.ws.setRightToLeft(true);
        WorksheetOptions wso = this.ws.getWorksheetOptions();
        wso.setGridlineColor(0, 0, 255);
        wso.setSelected(true);
        GIO gio = new GIO();
        String xml = this.xmlToString(this.ws, gio);
        SSWorksheetTest.assertTrue((xml.indexOf("<ss:Worksheet ss:Name=\"Sheet1\" ss:Protected=\"1\" ss:RightToLeft=\"1\">") > 0 ? 1 : 0) != 0);
        SSWorksheetTest.assertTrue((xml.indexOf("<ss:Row ss:Index=\"5\"/>") > 0 ? 1 : 0) != 0);
        SSWorksheetTest.assertTrue((xml.indexOf("<x:WorksheetOptions>") > 0 ? 1 : 0) != 0);
        SSWorksheetTest.assertTrue((xml.indexOf("<x:Selected/>") > 0 ? 1 : 0) != 0);
        SSWorksheetTest.assertTrue((xml.indexOf("<x:GridlineColor>#0000ff</x:GridlineColor>") > 0 ? 1 : 0) != 0);
        SSWorksheetTest.assertEquals((int)1, (int)gio.getSelectedSheetsCount());
        SSWorksheetTest.assertEquals((int)1, (int)gio.getSelectedSheetsCount());
    }
}

