/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.lang.reflect.Method;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.AbstractXLElement;
import nl.fountain.xelem.excel.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SSComment
extends AbstractXLElement
implements Comment {
    private String author;
    private boolean showAlways;
    private String data;

    @Override
    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setShowAlways(boolean show) {
        this.showAlways = show;
    }

    private void setShowAlways(String s) {
        this.showAlways = "1".equals(s);
    }

    @Override
    public boolean showsAlways() {
        return this.showAlways;
    }

    @Override
    public void setData(String data) {
        this.data = data;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public String getDataClean() {
        if (this.data != null) {
            String s = this.data;
            if (this.author != null) {
                s = s.replaceFirst(this.author + ":", "");
            }
            return s.trim();
        }
        return this.data;
    }

    @Override
    public String getTagName() {
        return "Comment";
    }

    @Override
    public String getNameSpace() {
        return "urn:schemas-microsoft-com:office:spreadsheet";
    }

    @Override
    public String getPrefix() {
        return "ss";
    }

    @Override
    public Element assemble(Element parent, GIO gio) {
        if (this.data == null) {
            return null;
        }
        Document doc = parent.getOwnerDocument();
        Element coe = this.assemble(doc, gio);
        if (this.author != null) {
            coe.setAttributeNodeNS(this.createAttributeNS(doc, "Author", this.author));
        }
        if (this.showAlways) {
            coe.setAttributeNodeNS(this.createAttributeNS(doc, "ShowAlways", "1"));
        }
        Element dae = doc.createElementNS("urn:schemas-microsoft-com:office:spreadsheet", "Data");
        dae.setPrefix("ss");
        dae.appendChild(doc.createTextNode(this.data));
        coe.appendChild(dae);
        parent.appendChild(coe);
        return coe;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.invokeMethod(attrs.getLocalName(i), attrs.getValue(i));
        }
    }

    @Override
    public void setChildElement(String localName, String content) {
        this.setData(content);
    }

    private void invokeMethod(String name, Object value) {
        Class[] types = new Class[]{value.getClass()};
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("set" + name, types);
            method.invoke((Object)this, value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

