/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.o;

import java.lang.reflect.Method;
import java.util.Date;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.XLUtil;
import nl.fountain.xelem.excel.AbstractXLElement;
import nl.fountain.xelem.excel.DocumentProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ODocumentProperties
extends AbstractXLElement
implements DocumentProperties {
    private String title;
    private String subject;
    private String keywords;
    private String description;
    private String category;
    private String author;
    private String lastAuthor;
    private String manager;
    private String created;
    private String lastsaved;
    private String lastprinted;
    private String company;
    private String hyperlinkbase;
    private String appname;
    private String version;

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public void setLastAuthor(String lastAuthor) {
        this.lastAuthor = lastAuthor;
    }

    @Override
    public void setManager(String manager) {
        this.manager = manager;
    }

    @Override
    public void setCompany(String company) {
        this.company = company;
    }

    @Override
    public void setHyperlinkBase(String hyperlinkbase) {
        this.hyperlinkbase = hyperlinkbase;
    }

    @Override
    public void setAppName(String appname) {
        this.appname = appname;
    }

    @Override
    public void setCreated(Date created) {
        this.created = XLUtil.format(created).substring(0, 16) + "Z";
    }

    private void setCreated(String created) {
        this.created = created;
    }

    @Override
    public void setLastSaved(Date lastsaved) {
        this.lastsaved = XLUtil.format(lastsaved).substring(0, 16) + "Z";
    }

    private void setLastSaved(String lastsaved) {
        this.lastsaved = lastsaved;
    }

    private void setLastPrinted(String lastprinted) {
        this.lastprinted = lastprinted;
    }

    @Override
    public String getTagName() {
        return "DocumentProperties";
    }

    @Override
    public String getNameSpace() {
        return "urn:schemas-microsoft-com:office:office";
    }

    @Override
    public String getPrefix() {
        return "o";
    }

    @Override
    public Element assemble(Element parent, GIO gio) {
        Document doc = parent.getOwnerDocument();
        Element dpe = this.assemble(doc, gio);
        if (this.title != null) {
            dpe.appendChild(this.createElementNS(doc, "Title", this.title));
        }
        if (this.subject != null) {
            dpe.appendChild(this.createElementNS(doc, "Subject", this.subject));
        }
        if (this.keywords != null) {
            dpe.appendChild(this.createElementNS(doc, "Keywords", this.keywords));
        }
        if (this.description != null) {
            dpe.appendChild(this.createElementNS(doc, "Description", this.description));
        }
        if (this.category != null) {
            dpe.appendChild(this.createElementNS(doc, "Category", this.category));
        }
        if (this.author != null) {
            dpe.appendChild(this.createElementNS(doc, "Author", this.author));
        }
        if (this.lastAuthor != null) {
            dpe.appendChild(this.createElementNS(doc, "LastAuthor", this.lastAuthor));
        }
        if (this.manager != null) {
            dpe.appendChild(this.createElementNS(doc, "Manager", this.manager));
        }
        if (this.company != null) {
            dpe.appendChild(this.createElementNS(doc, "Company", this.company));
        }
        if (this.hyperlinkbase != null) {
            dpe.appendChild(this.createElementNS(doc, "HyperlinkBase", this.hyperlinkbase));
        }
        if (this.appname != null) {
            dpe.appendChild(this.createElementNS(doc, "AppName", this.appname));
        }
        if (this.created != null) {
            dpe.appendChild(this.createElementNS(doc, "Created", this.created));
        }
        if (this.lastsaved != null) {
            dpe.appendChild(this.createElementNS(doc, "LastSaved", this.lastsaved));
        }
        parent.appendChild(dpe);
        return dpe;
    }

    @Override
    public void setChildElement(String localName, String content) {
        this.invokeMethod(localName, content);
    }

    private void invokeMethod(String name, Object value) {
        Class[] types = new Class[]{value.getClass()};
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("set" + name, types);
            method.invoke((Object)this, value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getKeywords() {
        return this.keywords;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getLastAuthor() {
        return this.lastAuthor;
    }

    @Override
    public String getManager() {
        return this.manager;
    }

    @Override
    public String getCompany() {
        return this.company;
    }

    @Override
    public String getHyperlinkBase() {
        return this.hyperlinkbase;
    }

    @Override
    public String getAppName() {
        return this.appname;
    }

    @Override
    public Date getCreated() {
        Date date = null;
        if (this.created != null) {
            date = XLUtil.parse(this.created);
        }
        return date;
    }

    @Override
    public Date getLastSaved() {
        Date date = null;
        if (this.lastsaved != null) {
            date = XLUtil.parse(this.lastsaved);
        }
        return date;
    }

    @Override
    public Date getLastPrinted() {
        Date date = null;
        if (this.lastprinted != null) {
            date = XLUtil.parse(this.lastprinted);
        }
        return date;
    }

    private void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

