/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel;

import java.util.ArrayList;
import java.util.List;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.XLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public abstract class AbstractXLElement
implements XLElement {
    private List<String> comments;
    private boolean printComments;

    protected AbstractXLElement() {
    }

    @Override
    public void addElementComment(String comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(comment);
    }

    @Override
    public List<String> getElementComments() {
        return this.comments;
    }

    @Override
    public void setAttributes(Attributes attrs) {
    }

    @Override
    public void setChildElement(String localName, String content) {
    }

    protected Element assemble(Document doc, GIO gio) {
        Element element = doc.createElementNS(this.getNameSpace(), this.getTagName());
        element.setPrefix(this.getPrefix());
        if (gio.isPrintingComments() && this.getElementComments() != null) {
            for (String s : this.getElementComments()) {
                element.appendChild(doc.createComment(s));
            }
        }
        return element;
    }

    protected Element createElementNS(Document doc, String qName) {
        Element n = doc.createElementNS(this.getNameSpace(), qName);
        n.setPrefix(this.getPrefix());
        return n;
    }

    protected Element createElementNS(Document doc, String qName, String value) {
        Element n = doc.createElementNS(this.getNameSpace(), qName);
        n.setPrefix(this.getPrefix());
        n.appendChild(doc.createTextNode(value));
        return n;
    }

    protected Element createElementNS(Document doc, String qName, int i) {
        Element n = doc.createElementNS(this.getNameSpace(), qName);
        n.setPrefix(this.getPrefix());
        n.appendChild(doc.createTextNode("" + i));
        return n;
    }

    protected Element createElementNS(Document doc, String qName, boolean b) {
        Element n = doc.createElementNS(this.getNameSpace(), qName);
        n.setPrefix(this.getPrefix());
        n.appendChild(doc.createTextNode(b ? "True" : "False"));
        return n;
    }

    protected Attr createAttributeNS(Document doc, String qName, int i) {
        Attr attr = doc.createAttributeNS(this.getNameSpace(), qName);
        attr.setPrefix(this.getPrefix());
        attr.setValue("" + i);
        return attr;
    }

    protected Attr createAttributeNS(Document doc, String qName, String value) {
        Attr attr = doc.createAttributeNS(this.getNameSpace(), qName);
        attr.setPrefix(this.getPrefix());
        attr.setValue(value);
        return attr;
    }
}

