/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.SlackField;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class SlackJSONAttachmentFormatter {
    SlackJSONAttachmentFormatter() {
    }

    public static List<JSONObject> encodeAttachments(SlackAttachment ... attachments) {
        ArrayList<JSONObject> toReturn = new ArrayList<JSONObject>();
        for (int i = 0; i < attachments.length; ++i) {
            JSONObject attachmentJSON = new JSONObject();
            toReturn.add(attachmentJSON);
            if (attachments[i].title != null) {
                attachmentJSON.put((Object)"title", (Object)attachments[i].title);
            }
            if (attachments[i].thumb_url != null) {
                attachmentJSON.put((Object)"thumb_url", (Object)attachments[i].thumb_url);
            }
            if (attachments[i].titleLink != null) {
                attachmentJSON.put((Object)"title_link", (Object)attachments[i].titleLink);
            }
            if (attachments[i].text != null) {
                attachmentJSON.put((Object)"text", (Object)attachments[i].text);
            }
            if (attachments[i].color != null) {
                attachmentJSON.put((Object)"color", (Object)attachments[i].color);
            }
            if (attachments[i].pretext != null) {
                attachmentJSON.put((Object)"pretext", (Object)attachments[i].pretext);
            }
            if (attachments[i].fallback != null) {
                attachmentJSON.put((Object)"fallback", (Object)attachments[i].fallback);
            }
            if (attachments[i].miscRootFields != null) {
                for (Map.Entry<String, String> entry : attachments[i].miscRootFields.entrySet()) {
                    attachmentJSON.put((Object)entry.getKey(), (Object)entry.getValue());
                }
            }
            if (attachments[i].markdown_in != null && !attachments[i].markdown_in.isEmpty()) {
                JSONArray array = new JSONArray();
                array.addAll(attachments[i].markdown_in);
                attachmentJSON.put((Object)"mrkdwn_in", (Object)array);
            }
            if (attachments[i].fields == null || attachments[i].fields.isEmpty()) continue;
            attachmentJSON.put((Object)"fields", SlackJSONAttachmentFormatter.encodeAttachmentFields(attachments[i].fields));
        }
        return toReturn;
    }

    private static List<JSONObject> encodeAttachmentFields(List<SlackField> fields) {
        ArrayList<JSONObject> toReturn = new ArrayList<JSONObject>();
        for (SlackField field : fields) {
            JSONObject fieldJSON = new JSONObject();
            toReturn.add(fieldJSON);
            if (field.title != null) {
                fieldJSON.put((Object)"title", (Object)field.title);
            }
            if (field.value != null) {
                fieldJSON.put((Object)"value", (Object)field.value);
            }
            fieldJSON.put((Object)"short", (Object)field.isShort);
        }
        return toReturn;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(new String("Lo\u00efc Herve".getBytes(), "UTF-8"));
    }
}

