/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JavaUtil {
    public static boolean isSubInterface(Class<?> sup, Class<?> sub) {
        if (sup.isInterface() && sub.isInterface()) {
            if (sup.equals(sub)) {
                return true;
            }
            for (Class<?> c : sub.getInterfaces()) {
                if (!JavaUtil.isSubInterface(sup, c)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> readTextFromJar(String path) throws IOException {
        try (InputStream is = JavaUtil.readResource(path);){
            List<String> list;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                list = reader.lines().collect(Collectors.toList());
            }
            return list;
        }
    }

    @NotNull
    public static InputStream readResource(String resource) throws IOException {
        InputStream is = JavaUtil.class.getResourceAsStream(resource);
        if (is == null) {
            throw new FileNotFoundException("Could not find '" + resource + "' inside the jar as a resource.");
        }
        return is;
    }

    public static void saveResource(String resource, Path destination, CopyOption ... options) throws IOException {
        try (InputStream is = JavaUtil.readResource(resource);){
            Files.copy(is, destination, options);
        }
    }

    public static boolean classExists(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }
}

