/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.google.common.collect.ImmutableSet;
import com.palmergames.bukkit.towny.object.AbstractRegistryList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ItemLists
extends AbstractRegistryList<Material> {
    public static final ItemLists AXES = ItemLists.newBuilder().withTag("items", NamespacedKey.minecraft((String)"axes")).endsWith("_AXE").build();
    public static final ItemLists DYES = ItemLists.newBuilder().endsWith("_DYE").endsWith("INK_SAC").build();
    public static final ItemLists REDSTONE_INTERACTABLES = ItemLists.newBuilder().add("COMPARATOR", "REPEATER", "DAYLIGHT_DETECTOR", "NOTE_BLOCK", "REDSTONE_WIRE").build();
    public static final ItemLists POTTED_PLANTS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"potted_plants")).startsWith("POTTED_").build();
    public static final ItemLists PLANTS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"flowers")).add("TALL_GRASS", "BROWN_MUSHROOM", "RED_MUSHROOM", "CACTUS", "ALLIUM", "AZURE_BLUET", "BLUE_ORCHID", "CORNFLOWER", "DANDELION", "LILAC", "LILY_OF_THE_VALLEY", "ORANGE_TULIP", "OXEYE_DAISY", "PEONY", "PINK_TULIP", "POPPY", "RED_TULIP", "ROSE_BUSH", "SUNFLOWER", "WHITE_TULIP", "WITHER_ROSE", "CRIMSON_FUNGUS", "LARGE_FERN", "PUMPKIN", "VINE", "TWISTING_VINES_PLANT", "WEEPING_VINES_PLANT", "NETHER_WART_BLOCK", "COCOA", "SUGAR_CANE", "CRIMSON_ROOTS", "WARPED_ROOTS", "NETHER_SPROUTS", "BIG_DRIPLEAF", "SMALL_DRIPLEAF", "TORCHFLOWER").build();
    public static final ItemLists ORES = ItemLists.newBuilder().endsWith("_ORE").add("RAW_IRON_BLOCK", "RAW_GOLD_BLOCK", "RAW_COPPER_BLOCK", "ANCIENT_DEBRIS", "CLAY", "GLOWSTONE", "GILDED_BLACKSTONE").build();
    public static final ItemLists SAPLINGS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"saplings")).endsWith("_SAPLING").add("MANGROVE_PROPAGULE", "CRIMSON_FUNGUS", "WARPED_FUNGUS").build();
    public static final ItemLists TREES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"logs")).withTag("blocks", NamespacedKey.minecraft((String)"leaves")).endsWith("_WOOD").endsWith("_HYPHAE").notStartsWith("STRIPPED_").endsWith("_LEAVES").endsWith("_LOG").add("CRIMSON_STEM", "WARPED_STEM").add("BAMBOO_BLOCK").build();
    public static final ItemLists BEDS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"beds")).endsWith("_BED").build();
    public static final ItemLists SIGNS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"signs")).withTag("blocks", NamespacedKey.minecraft((String)"all_signs")).endsWith("_SIGN").build();
    public static final ItemLists TORCHES = ItemLists.newBuilder().endsWith("TORCH").build();
    public static final ItemLists SKULLS = ItemLists.newBuilder().endsWith("_HEAD").endsWith("_SKULL").build();
    public static final ItemLists BOATS = ItemLists.newBuilder().withTag("items", NamespacedKey.minecraft((String)"boats")).endsWith("_BOAT").endsWith("_RAFT").build();
    public static final ItemLists MINECARTS = ItemLists.newBuilder().endsWith("MINECART").build();
    public static final ItemLists WOOD_DOORS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"wooden_doors")).endsWith("_DOOR").not("IRON_DOOR").build();
    public static final ItemLists DOORS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"doors")).endsWith("_DOOR").build();
    public static final ItemLists FENCE_GATES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"fence_gates")).endsWith("_FENCE_GATE").build();
    public static final ItemLists TRAPDOORS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"trapdoors")).endsWith("_TRAPDOOR").build();
    public static final ItemLists SHULKER_BOXES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"shulker_boxes")).endsWith("SHULKER_BOX").build();
    public static final ItemLists PRESSURE_PLATES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"pressure_plates")).endsWith("_PRESSURE_PLATE").build();
    public static final ItemLists NON_WOODEN_PRESSURE_PLATES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"pressure_plates")).excludeTag("blocks", NamespacedKey.minecraft((String)"wooden_pressure_plates")).build();
    public static final ItemLists BUTTONS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"buttons")).endsWith("_BUTTON").build();
    public static final ItemLists PROJECTILE_TRIGGERED_REDSTONE = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"wooden_buttons")).endsWith("_BUTTON").not("STONE_BUTTON").withTag("blocks", NamespacedKey.minecraft((String)"wooden_pressure_plates")).endsWith("_PRESSURE_PLATE").not("STONE_PRESSURE_PLATE").build();
    public static final ItemLists BUCKETS = ItemLists.newBuilder().endsWith("BUCKET").build();
    public static final ItemLists COPPER_BLOCKS = ItemLists.newBuilder().add("COPPER_BLOCK", "COPPER_ORE", "DEEPSLATE_COPPER_ORE", "CUT_COPPER", "CUT_COPPER_SLAB", "CUT_COPPER_STAIRS", "EXPOSED_COPPER", "EXPOSED_CUT_COPPER", "EXPOSED_CUT_COPPER_SLAB", "EXPOSED_CUT_COPPER_STAIRS", "OXIDIZED_COPPER", "OXIDIZED_CUT_COPPER", "OXIDIZED_CUT_COPPER_SLAB", "OXIDIZED_CUT_COPPER_STAIRS", "RAW_COPPER_BLOCK", "WAXED_COPPER_BLOCK", "WAXED_CUT_COPPER", "WAXED_CUT_COPPER_SLAB", "WAXED_CUT_COPPER_STAIRS", "WAXED_EXPOSED_CUT_COPPER_SLAB", "WAXED_EXPOSED_COPPER", "WAXED_EXPOSED_CUT_COPPER", "WAXED_OXIDIZED_COPPER", "WAXED_OXIDIZED_CUT_COPPER", "WAXED_OXIDIZED_CUT_COPPER_SLAB", "WAXED_WEATHERED_COPPER", "WAXED_WEATHERED_CUT_COPPER", "WEATHERED_COPPER", "WEATHERED_CUT_COPPER", "CUT_COPPER_STAIRS", "EXPOSED_CUT_COPPER_STAIRS", "OXIDIZED_CUT_COPPER_STAIRS", "WAXED_EXPOSED_CUT_COPPER_STAIRS", "WAXED_OXIDIZED_CUT_COPPER_STAIRS", "WAXED_WEATHERED_CUT_COPPER_STAIRS", "WAXED_WEATHERED_CUT_COPPER_SLAB", "WEATHERED_CUT_COPPER_STAIRS").build();
    public static final ItemLists WEATHERABLE_BLOCKS = ItemLists.newBuilder().add("COPPER_BLOCK", "EXPOSED_COPPER", "OXIDIZED_COPPER", "WEATHERED_COPPER", "CUT_COPPER", "EXPOSED_CUT_COPPER", "OXIDIZED_CUT_COPPER", "WEATHERED_CUT_COPPER", "CUT_COPPER_SLAB", "EXPOSED_CUT_COPPER_SLAB", "OXIDIZED_CUT_COPPER_SLAB", "WEATHERED_CUT_COPPER_SLAB", "CUT_COPPER_STAIRS", "EXPOSED_CUT_COPPER_STAIRS", "OXIDIZED_CUT_COPPER_STAIRS", "WEATHERED_CUT_COPPER_STAIRS").build();
    public static final ItemLists WAXED_BLOCKS = ItemLists.newBuilder().add("WAXED_COPPER_BLOCK", "WAXED_EXPOSED_COPPER", "WAXED_WEATHERED_COPPER", "WAXED_OXIDIZED_COPPER", "WAXED_CUT_COPPER", "WAXED_EXPOSED_CUT_COPPER", "WAXED_WEATHERED_CUT_COPPER", "WAXED_OXIDIZED_CUT_COPPER", "WAXED_CUT_COPPER_SLAB", "WAXED_EXPOSED_CUT_COPPER_SLAB", "WAXED_WEATHERED_CUT_COPPER_SLAB", "WAXED_OXIDIZED_CUT_COPPER_SLAB", "WAXED_CUT_COPPER_STAIRS", "WAXED_EXPOSED_CUT_COPPER_STAIRS", "WAXED_WEATHERED_CUT_COPPER_STAIRS", "WAXED_OXIDIZED_CUT_COPPER_STAIRS").build();
    public static final ItemLists CANDLES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"candles")).withTag("blocks", NamespacedKey.minecraft((String)"candle_cakes")).endsWith("CANDLE").endsWith("_CANDLE_CAKE").build();
    public static final ItemLists ITEM_FRAMES = ItemLists.newBuilder().add("ITEM_FRAME", "GLOW_ITEM_FRAME").build();
    public static final ItemLists HANGING_ENTITIES = ItemLists.newBuilder().add("ITEM_FRAME", "GLOW_ITEM_FRAME", "PAINTING").build();
    public static final ItemLists CAMPFIRES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"campfires")).add("CAMPFIRE", "SOUL_CAMPFIRE").build();
    public static final ItemLists BOOK_CONTAINERS = ItemLists.newBuilder().add("CHISELED_BOOKSHELF", "LECTERN").build();
    public static final ItemLists PLACEABLE_BOOKS = ItemLists.newBuilder().add("BOOK", "ENCHANTED_BOOK", "WRITABLE_BOOK", "WRITTEN_BOOK").build();
    public static final ItemLists HARVESTABLE_BERRIES = ItemLists.newBuilder().add("CAVE_VINES_PLANT", "SWEET_BERRY_BUSH").build();
    public static final ItemLists MINECART_KILLERS = ItemLists.newBuilder().add("CACTUS").build();
    public static final ItemLists UNSTRIPPED_WOOD = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"logs")).endsWith("_LOG").notStartsWith("STRIPPED_").add("CRIMSON_STEM", "WARPED_STEM").add("BAMBOO_BLOCK").build();
    public static final ItemLists CAULDRONS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"cauldrons")).endsWith("CAULDRON").build();
    public static final ItemLists FILLED_CAULDRONS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"cauldrons")).endsWith("CAULDRON").not("CAULDRON").build();
    public static final ItemLists CAULDRON_FILLABLE = ItemLists.newBuilder().add("WATER_BUCKET", "LAVA_BUCKET", "POWDER_SNOW_BUCKET").build();
    public static final ItemLists HOES = ItemLists.newBuilder().withTag("items", NamespacedKey.minecraft((String)"hoes")).endsWith("_hoe").build();
    public static final ItemLists BRUSHABLE_BLOCKS = ItemLists.newBuilder().add("SUSPICIOUS_SAND", "SUSPICIOUS_GRAVEL").build();
    public static final Set<String> GROUPS = Arrays.stream(ItemLists.class.getFields()).filter(field -> Modifier.isStatic(field.getModifiers())).map(Field::getName).filter(name -> !name.equals("GROUPS")).collect(Collectors.toSet());

    private ItemLists(Collection<Material> taggedMaterials) {
        super(Registry.MATERIAL, taggedMaterials);
    }

    @Override
    public boolean contains(@NotNull ItemStack itemStack) {
        return this.contains(itemStack.getType());
    }

    @NotNull
    public static @Unmodifiable Set<Material> getGrouping(String groupName) {
        if (!GROUPS.contains(groupName)) {
            return ImmutableSet.of();
        }
        try {
            return ImmutableSet.copyOf((Collection)((ItemLists)ItemLists.class.getField((String)groupName).get(null)).tagged);
        }
        catch (Exception e) {
            return ImmutableSet.of();
        }
    }

    public static AbstractRegistryList.Builder<Material, ItemLists> newBuilder() {
        return new AbstractRegistryList.Builder<Material, ItemLists>(Registry.MATERIAL, Material.class, ItemLists::new).notStartsWith("LEGACY_");
    }
}

