/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.adventure.text.format.NamedTextColor;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.util.StringMgmt;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Colors {
    private static final Map<String, String> LEGACY_LOOKUP = new HashMap<String, String>();
    private static final Pattern LEGACY_PATTERN = Pattern.compile("[\u00a7&][0-9a-fk-or]");
    public static final String Black = "\u00a70";
    public static final String Navy = "\u00a71";
    public static final String Green = "\u00a72";
    public static final String Blue = "\u00a73";
    public static final String Red = "\u00a74";
    public static final String Purple = "\u00a75";
    public static final String Gold = "\u00a76";
    public static final String LightGray = "\u00a77";
    public static final String Gray = "\u00a78";
    public static final String DarkPurple = "\u00a79";
    public static final String LightGreen = "\u00a7a";
    public static final String LightBlue = "\u00a7b";
    public static final String Rose = "\u00a7c";
    public static final String LightPurple = "\u00a7d";
    public static final String Yellow = "\u00a7e";
    public static final String White = "\u00a7f";
    public static final String DARK_RED = "<dark_red>";
    public static final String RED = "<red>";
    public static final String GOLD = "<gold>";
    public static final String YELLOW = "<yellow>";
    public static final String DARK_GREEN = "<dark_green>";
    public static final String GREEN = "<green>";
    public static final String DARK_AQUA = "<dark_aqua>";
    public static final String AQUA = "<aqua>";
    public static final String DARK_BLUE = "<dark_blue>";
    public static final String BLUE = "<blue>";
    public static final String LIGHT_PURPLE = "<light_purple>";
    public static final String DARK_PURPLE = "<dark_purple>";
    public static final String WHITE = "<white>";
    public static final String GRAY = "<gray>";
    public static final String DARK_GRAY = "<dark_gray>";
    public static final String BLACK = "<black>";
    public static final String OBFUSCATED = "<obfuscated>";
    public static final String BOLD = "<bold>";
    public static final String STRIKETHROUGH = "<strikethrough>";
    public static final String UNDERLINED = "<underlined>";
    public static final String ITALIC = "<italic>";
    public static final String RESET = "<reset>";
    private static final Function<String, String> modernHexFunction = hex -> "<#" + hex + ">";

    public static String strip(String line) {
        return TownyComponents.stripTags(ChatColor.stripColor((String)line));
    }

    public static String translateColorCodes(String str) {
        return StringMgmt.translateHexColors(ChatColor.translateAlternateColorCodes((char)'&', (String)str));
    }

    public static String translateLegacyCharacters(String input) {
        Matcher matcher = LEGACY_PATTERN.matcher(input);
        while (matcher.find()) {
            String legacy = matcher.group();
            input = input.replace(legacy, LEGACY_LOOKUP.getOrDefault(legacy.substring(1), legacy));
        }
        return input;
    }

    public static String translateLegacyHex(String input) {
        return StringMgmt.translateHexColors(input, modernHexFunction);
    }

    @Nullable
    public static NamedTextColor toNamedTextColor(@NotNull String color) {
        NamedTextColor namedTextColor;
        switch (color) {
            case "\u00a70": 
            case "<black>": {
                namedTextColor = NamedTextColor.BLACK;
                break;
            }
            case "\u00a71": 
            case "<dark_blue>": {
                namedTextColor = NamedTextColor.DARK_BLUE;
                break;
            }
            case "\u00a72": 
            case "<dark_green>": {
                namedTextColor = NamedTextColor.DARK_GREEN;
                break;
            }
            case "\u00a73": 
            case "<dark_aqua>": {
                namedTextColor = NamedTextColor.DARK_AQUA;
                break;
            }
            case "\u00a74": 
            case "<dark_red>": {
                namedTextColor = NamedTextColor.DARK_RED;
                break;
            }
            case "\u00a75": 
            case "<dark_purple>": {
                namedTextColor = NamedTextColor.DARK_PURPLE;
                break;
            }
            case "\u00a76": 
            case "<gold>": {
                namedTextColor = NamedTextColor.GOLD;
                break;
            }
            case "\u00a77": 
            case "<gray>": {
                namedTextColor = NamedTextColor.GRAY;
                break;
            }
            case "\u00a78": 
            case "<dark_gray>": {
                namedTextColor = NamedTextColor.DARK_GRAY;
                break;
            }
            case "\u00a79": 
            case "<blue>": {
                namedTextColor = NamedTextColor.BLUE;
                break;
            }
            case "\u00a7a": 
            case "<green>": {
                namedTextColor = NamedTextColor.GREEN;
                break;
            }
            case "\u00a7b": 
            case "<aqua>": {
                namedTextColor = NamedTextColor.AQUA;
                break;
            }
            case "\u00a7c": 
            case "<red>": {
                namedTextColor = NamedTextColor.RED;
                break;
            }
            case "\u00a7d": 
            case "<light_purple>": {
                namedTextColor = NamedTextColor.LIGHT_PURPLE;
                break;
            }
            case "\u00a7e": 
            case "<yellow>": {
                namedTextColor = NamedTextColor.YELLOW;
                break;
            }
            case "\u00a7f": 
            case "<white>": {
                namedTextColor = NamedTextColor.WHITE;
                break;
            }
            default: {
                namedTextColor = null;
            }
        }
        return namedTextColor;
    }

    public static String colorTown(String townName) {
        return Colors.translateColorCodes(Colors.getTownColor() + townName);
    }

    public static String colorTown(Town town) {
        return Colors.translateColorCodes(Colors.getTownColor() + town);
    }

    public static String colorNation(String nationName) {
        return Colors.translateColorCodes(Colors.getNationColor() + nationName);
    }

    public static String colorNation(Nation nation) {
        return Colors.translateColorCodes(Colors.getNationColor() + nation);
    }

    public static String getTownColor() {
        return TownySettings.getPAPIFormattingMayor();
    }

    public static String getNationColor() {
        return TownySettings.getPAPIFormattingKing();
    }

    static {
        LEGACY_LOOKUP.put("0", BLACK);
        LEGACY_LOOKUP.put("1", DARK_BLUE);
        LEGACY_LOOKUP.put("2", DARK_GREEN);
        LEGACY_LOOKUP.put("3", DARK_AQUA);
        LEGACY_LOOKUP.put("4", DARK_RED);
        LEGACY_LOOKUP.put("5", DARK_PURPLE);
        LEGACY_LOOKUP.put("6", GOLD);
        LEGACY_LOOKUP.put("7", GRAY);
        LEGACY_LOOKUP.put("8", DARK_GRAY);
        LEGACY_LOOKUP.put("9", BLUE);
        LEGACY_LOOKUP.put("a", GREEN);
        LEGACY_LOOKUP.put("b", AQUA);
        LEGACY_LOOKUP.put("c", RED);
        LEGACY_LOOKUP.put("d", LIGHT_PURPLE);
        LEGACY_LOOKUP.put("e", YELLOW);
        LEGACY_LOOKUP.put("f", WHITE);
        LEGACY_LOOKUP.put("k", OBFUSCATED);
        LEGACY_LOOKUP.put("l", BOLD);
        LEGACY_LOOKUP.put("m", STRIKETHROUGH);
        LEGACY_LOOKUP.put("n", UNDERLINED);
        LEGACY_LOOKUP.put("o", ITALIC);
        LEGACY_LOOKUP.put("r", RESET);
    }
}

