/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.FontUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookFactory {
    private static final float MAX_LINE_WIDTH = FontUtil.measureWidth("LLLLLLLLLLLLLLLLLLL");

    public static ItemStack makeBook(String title, String author, String rawText) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle(title);
        meta.setAuthor(author);
        List<String> pages = BookFactory.getPages(rawText);
        for (String page : pages) {
            meta.addPage(new String[]{page});
        }
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    public static ItemStack makeBook(String title, String author, List<String> pages) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle(title);
        meta.setAuthor(author);
        for (String page : pages) {
            meta.addPage(new String[]{page});
        }
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    private static List<String> getLines(String rawText) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            for (String section : rawText.split("\n")) {
                if (section.equals("")) {
                    lines.add("\n");
                    continue;
                }
                String[] words = Colors.strip(section).split(" ");
                String line = "";
                for (int index = 0; index < words.length; ++index) {
                    String word = words[index];
                    if (line.isEmpty()) {
                        line = word;
                        continue;
                    }
                    int spaces = 0;
                    if (FontUtil.font.getWidth(" ") == 2) {
                        spaces = 1;
                        for (int i = 0; i < line.length(); ++i) {
                            if (line.charAt(i) != ' ') continue;
                            ++spaces;
                        }
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    if (FontUtil.measureWidth(stringBuilder.append(line).append(" ").append(word).toString()) + (float)spaces > MAX_LINE_WIDTH) {
                        lines.add(line + "\n");
                        line = word;
                        continue;
                    }
                    line = line + " " + word;
                }
                if (line.equals("")) continue;
                lines.add(line + "\n");
            }
        }
        catch (IllegalArgumentException ex) {
            lines.clear();
        }
        return lines;
    }

    private static List<String> getPages(String rawText) {
        rawText = "\n" + rawText;
        ArrayList<String> pages = new ArrayList<String>();
        List<String> lines = BookFactory.getLines(rawText);
        String pageText = "";
        for (int i = 1; i < lines.size(); ++i) {
            pageText = pageText + lines.get(i);
            if (i == 1 || i % 14 != 0) continue;
            pages.add(pageText);
            pageText = "";
        }
        if (!pageText.isEmpty()) {
            pages.add(pageText);
        }
        return pages;
    }
}

