/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.NationSpawnEvent;
import com.palmergames.bukkit.towny.event.SpawnEvent;
import com.palmergames.bukkit.towny.event.TownSpawnEvent;
import com.palmergames.bukkit.towny.event.teleport.ResidentSpawnEvent;
import com.palmergames.bukkit.towny.event.teleport.UnjailedResidentTeleportEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.EconomyAccount;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnInformation;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.TownyServerAccount;
import com.palmergames.bukkit.towny.object.spawnlevel.NationSpawnLevel;
import com.palmergames.bukkit.towny.object.spawnlevel.TownSpawnLevel;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.paperlib.PaperLib;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.Nullable;

public class SpawnUtil {
    private static Towny plugin;

    public static void initialize(Towny plugin) {
        SpawnUtil.plugin = plugin;
    }

    public static void sendToTownySpawn(Player player, String[] split, TownyObject townyObject, String notAffordMSG, boolean outpost, boolean ignoreWarn, SpawnType spawnType) throws TownyException {
        Town town;
        Resident resident = TownyAPI.getInstance().getResidentOrThrow(player);
        switch (spawnType) {
            case RESIDENT: {
                town = resident.getTownOrNull();
                break;
            }
            case TOWN: {
                town = (Town)townyObject;
                break;
            }
            default: {
                town = null;
            }
        }
        Town town2 = town;
        Nation nation = spawnType == SpawnType.NATION ? (Nation)townyObject : null;
        SpawnInformation spawnInfo = SpawnUtil.getSpawnInformation(player, split.length == 0, notAffordMSG, outpost, spawnType, resident, town2, nation);
        SpawnUtil.getSpawnLoc(player, town2, nation, spawnType, outpost, split).thenAccept(spawnLoc -> {
            try {
                SpawnUtil.sendSpawnEvent(player, spawnType, spawnLoc, spawnInfo);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                return;
            }
            if (spawnInfo.travelCost > 0.0) {
                String paymentMsg = SpawnUtil.getPaymentMsg(spawnInfo.townSpawnLevel, spawnInfo.nationSpawnLevel, spawnType);
                TownyServerAccount payee = TownySettings.isTownSpawnPaidToTown() ? SpawnUtil.getPayee(town2, nation, spawnType) : EconomyAccount.SERVER_ACCOUNT;
                SpawnUtil.initiateCostedSpawn(player, resident, spawnLoc, spawnInfo.travelCost, payee, paymentMsg, ignoreWarn, spawnInfo.cooldown);
            } else {
                SpawnUtil.initiateSpawn(player, spawnLoc, spawnInfo.cooldown, 0.0, null);
            }
        });
    }

    private static SpawnInformation getSpawnInformation(Player player, boolean noCmdArgs, String notAffordMSG, boolean outpost, SpawnType spawnType, Resident resident, Town town, Nation nation) {
        boolean isTownyAdmin = SpawnUtil.isTownyAdmin(player);
        SpawnInformation spawnInformation = new SpawnInformation();
        try {
            SpawnUtil.testResidentAbility(resident);
            spawnInformation.townSpawnLevel = SpawnUtil.getTownSpawnLevel(player, noCmdArgs, spawnType, resident, town, outpost, isTownyAdmin);
            spawnInformation.nationSpawnLevel = SpawnUtil.getNationSpawnLevel(player, noCmdArgs, spawnType, resident, nation, isTownyAdmin);
            spawnInformation.cooldown = SpawnUtil.getCooldown(player, spawnInformation);
            if (!isTownyAdmin) {
                SpawnUtil.testDisallowedZones(player, resident, spawnType, TownySettings.getDisallowedTownSpawnZones());
            }
            spawnInformation.travelCost = SpawnUtil.getTravelCost(player, town, nation, spawnInformation.townSpawnLevel, spawnInformation.nationSpawnLevel, spawnType);
            if (spawnInformation.travelCost > 0.0 && !resident.getAccount().canPayFromHoldings(spawnInformation.travelCost)) {
                throw new TownyException(notAffordMSG);
            }
        }
        catch (TownyException te) {
            spawnInformation.eventCancelled = true;
            spawnInformation.eventCancellationMessage = te.getMessage();
        }
        return spawnInformation;
    }

    public static void outlawTeleport(Town town, Resident outlaw) {
        Player outlawedPlayer = outlaw.getPlayer();
        if (outlawedPlayer == null) {
            return;
        }
        PaperLib.getBedSpawnLocationAsync(outlawedPlayer, true).thenAccept(bed -> {
            Location spawnLocation = town.getWorld().getSpawnLocation();
            if (!TownySettings.getOutlawTeleportWorld().equals("")) {
                spawnLocation = Objects.requireNonNull(Bukkit.getWorld((String)TownySettings.getOutlawTeleportWorld())).getSpawnLocation();
            }
            if (bed != null && TownyAPI.getInstance().getTown((Location)bed) != town) {
                spawnLocation = bed;
            }
            if (outlaw.hasTown() && TownyAPI.getInstance().getTownSpawnLocation(outlawedPlayer) != null) {
                spawnLocation = TownyAPI.getInstance().getTownSpawnLocation(outlawedPlayer);
            }
            TownyMessaging.sendMsg(outlaw, Translatable.of("msg_outlaw_kicked", town));
            SpawnUtil.initiatePluginTeleport(outlaw, spawnLocation, true);
        });
    }

    public static void jailAwayTeleport(Resident jailed) {
        SpawnUtil.getIdealLocation(jailed).thenAccept(loc -> {
            UnjailedResidentTeleportEvent event = new UnjailedResidentTeleportEvent(jailed, (Location)loc);
            if (BukkitTools.isEventCancelled(event)) {
                return;
            }
            SpawnUtil.initiatePluginTeleport(jailed, event.getLocation(), false);
        });
    }

    public static void jailTeleport(Resident jailed) {
        SpawnUtil.initiatePluginTeleport(jailed, jailed.getJailSpawn(), false);
    }

    private static void testResidentAbility(Resident resident) throws TownyException {
        if (CooldownTimerTask.hasCooldown(resident.getName(), "teleport")) {
            throw new TownyException(Translatable.of("msg_err_cannot_spawn_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(resident.getName(), "teleport")));
        }
        if (resident.isJailed()) {
            throw new TownyException(Translatable.of("msg_cannot_spawn_while_jailed"));
        }
    }

    private static boolean isTownyAdmin(Player player) {
        return TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)player) || SpawnUtil.hasPerm(player, PermissionNodes.TOWNY_SPAWN_ADMIN);
    }

    private static boolean playerHasFreeSpawn(Player player) {
        return SpawnUtil.hasPerm(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_SPAWN_FREECHARGE) || SpawnUtil.hasPerm(player, PermissionNodes.TOWNY_SPAWN_ADMIN_NOCHARGE);
    }

    private static TownSpawnLevel getTownSpawnLevel(Player player, boolean noCmdArgs, SpawnType spawnType, Resident resident, Town town, boolean outpost, boolean isTownyAdmin) throws TownyException {
        TownSpawnLevel townSpawnLevel;
        switch (spawnType) {
            case RESIDENT: {
                if (isTownyAdmin) {
                    townSpawnLevel = TownSpawnLevel.ADMIN;
                    break;
                }
                townSpawnLevel = TownSpawnLevel.TOWN_RESIDENT;
                break;
            }
            case TOWN: {
                if (isTownyAdmin) {
                    townSpawnLevel = TownSpawnLevel.ADMIN;
                    break;
                }
                townSpawnLevel = SpawnUtil.getTownSpawnLevel(player, resident, town, outpost, noCmdArgs);
                break;
            }
            default: {
                townSpawnLevel = null;
            }
        }
        return townSpawnLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TownSpawnLevel getTownSpawnLevel(Player player, Resident resident, Town town, boolean outpost, boolean noArg) throws TownyException {
        TownSpawnLevel townSpawnLevel = null;
        if (noArg && !outpost) {
            townSpawnLevel = TownSpawnLevel.TOWN_RESIDENT;
        } else {
            if (TownySettings.trustedResidentsGetToSpawnToTown() && (town.hasTrustedResident(resident) || resident.hasTown() && town.hasTrustedTown(resident.getTownOrNull()))) {
                townSpawnLevel = TownSpawnLevel.TOWN_RESIDENT;
            } else if (!resident.hasTown()) {
                townSpawnLevel = TownSpawnLevel.UNAFFILIATED;
            } else if (resident.getTownOrNull() == town) {
                townSpawnLevel = outpost ? TownSpawnLevel.TOWN_RESIDENT_OUTPOST : TownSpawnLevel.TOWN_RESIDENT;
            } else if (resident.hasNation() && town.hasNation()) {
                Nation targetNation;
                Nation playerNation = resident.getNationOrNull();
                if (playerNation == (targetNation = town.getNationOrNull())) {
                    if (!town.isPublic() && TownySettings.isAllySpawningRequiringPublicStatus() && !resident.hasPermissionNode(PermissionNodes.TOWNY_SPAWN_NATION_BYPASS_PUBLIC.getNode())) {
                        throw new TownyException(Translatable.of("msg_err_ally_isnt_public", town));
                    }
                    townSpawnLevel = TownSpawnLevel.PART_OF_NATION;
                } else if (targetNation.hasEnemy(playerNation)) {
                    if (!town.isNeutral() || !TownySettings.areEnemiesAllowedToSpawnToPeacefulTowns()) throw new TownyException(Translatable.of("msg_err_public_spawn_enemy"));
                    townSpawnLevel = TownSpawnLevel.TOWN_RESIDENT;
                } else if (targetNation.hasAlly(playerNation)) {
                    if (!town.isPublic() && TownySettings.isAllySpawningRequiringPublicStatus() && !resident.hasPermissionNode(PermissionNodes.TOWNY_SPAWN_ALLY_BYPASS_PUBLIC.getNode())) {
                        throw new TownyException(Translatable.of("msg_err_ally_isnt_public", town));
                    }
                    townSpawnLevel = TownSpawnLevel.NATION_ALLY;
                } else {
                    townSpawnLevel = TownSpawnLevel.UNAFFILIATED;
                }
            } else {
                townSpawnLevel = TownSpawnLevel.UNAFFILIATED;
            }
            if (townSpawnLevel == TownSpawnLevel.UNAFFILIATED && !town.isPublic()) {
                if (TownySettings.isConfigAllowingPublicTownSpawnTravel()) throw new TownyException(Translatable.of("msg_err_not_public"));
                throw new TownyException(Translatable.of("msg_err_town_unaffiliated"));
            }
        }
        townSpawnLevel.checkIfAllowed(player, town);
        return townSpawnLevel;
    }

    private static NationSpawnLevel getNationSpawnLevel(Player player, boolean noCmdArgs, SpawnType spawnType, Resident resident, Nation nation, boolean isTownyAdmin) throws TownyException {
        return spawnType == SpawnType.NATION ? (isTownyAdmin ? NationSpawnLevel.ADMIN : SpawnUtil.getNationSpawnLevel(player, resident, nation, noCmdArgs)) : null;
    }

    private static NationSpawnLevel getNationSpawnLevel(Player player, Resident resident, Nation nation, boolean noArg) throws TownyException {
        NationSpawnLevel nationSpawnLevel = null;
        if (noArg) {
            nationSpawnLevel = NationSpawnLevel.PART_OF_NATION;
        } else {
            if (!resident.hasTown()) {
                nationSpawnLevel = NationSpawnLevel.UNAFFILIATED;
            } else if (resident.hasNation()) {
                Nation playerNation = resident.getNationOrNull();
                if (playerNation == nation) {
                    nationSpawnLevel = NationSpawnLevel.PART_OF_NATION;
                } else {
                    if (nation.hasEnemy(playerNation)) {
                        throw new TownyException(Translatable.of("msg_err_public_spawn_enemy"));
                    }
                    nationSpawnLevel = nation.hasAlly(playerNation) ? NationSpawnLevel.NATION_ALLY : NationSpawnLevel.UNAFFILIATED;
                }
            } else {
                nationSpawnLevel = NationSpawnLevel.UNAFFILIATED;
            }
            if (nationSpawnLevel == NationSpawnLevel.UNAFFILIATED && !nation.isPublic()) {
                if (!TownySettings.isConfigAllowingPublicNationSpawnTravel()) {
                    throw new TownyException(Translatable.of("msg_err_nation_unaffiliated"));
                }
                throw new TownyException(Translatable.of("msg_err_nation_not_public"));
            }
        }
        nationSpawnLevel.checkIfAllowed(player, nation);
        return nationSpawnLevel;
    }

    private static int getCooldown(Player player, SpawnInformation spawnInformation) {
        return player.hasPermission(PermissionNodes.TOWNY_SPAWN_ADMIN_NOCOOLDOWN.getNode()) ? 0 : (spawnInformation.townSpawnLevel != null ? spawnInformation.townSpawnLevel.getCooldown() : spawnInformation.nationSpawnLevel.getCooldown());
    }

    private static CompletableFuture<Location> getSpawnLoc(Player player, Town town, Nation nation, SpawnType spawnType, boolean outpost, String[] split) throws TownyException {
        CompletionStage<Object> completionStage;
        switch (spawnType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RESIDENT: {
                if (TownySettings.getBedUse()) {
                    completionStage = PaperLib.getBedSpawnLocationAsync(player, true).thenApply(bedLoc -> {
                        if (bedLoc != null) {
                            return bedLoc;
                        }
                        if (town != null && town.hasSpawn()) {
                            return town.getSpawnOrNull();
                        }
                        return plugin.getCache(player).getLastLocation().getWorld().getSpawnLocation();
                    });
                    break;
                }
                if (town != null && town.hasSpawn()) {
                    completionStage = CompletableFuture.completedFuture(town.getSpawnOrNull());
                    break;
                }
                completionStage = CompletableFuture.completedFuture(plugin.getCache(player).getLastLocation().getWorld().getSpawnLocation());
                break;
            }
            case TOWN: {
                if (outpost) {
                    completionStage = CompletableFuture.completedFuture(SpawnUtil.getOutpostSpawnLocation(town, split));
                    break;
                }
                completionStage = CompletableFuture.completedFuture(town.getSpawn());
                break;
            }
            case NATION: {
                completionStage = CompletableFuture.completedFuture(nation.getSpawn());
            }
        }
        return completionStage;
    }

    private static Location getOutpostSpawnLocation(Town town, String[] split) throws TownyException {
        if (!town.hasOutpostSpawn()) {
            throw new TownyException(Translatable.of("msg_err_outpost_spawn"));
        }
        if (split.length == 0) {
            return town.getOutpostSpawn(1);
        }
        Integer index = null;
        String userInput = split[split.length - 1];
        try {
            index = !userInput.contains("name:") ? Integer.valueOf(Integer.parseInt(userInput)) : SpawnUtil.getOutpostIndexFromName(town, index, userInput.replace("name:", "").replace("_", " "));
        }
        catch (NumberFormatException e) {
            index = SpawnUtil.getOutpostIndexFromName(town, index, userInput.replace("_", " "));
        }
        catch (ArrayIndexOutOfBoundsException i) {
            index = 1;
        }
        if (TownySettings.isOutpostLimitStoppingTeleports() && TownySettings.isOutpostsLimitedByLevels() && town.isOverOutpostLimit() && Math.max(1, index) > town.getOutpostLimit()) {
            throw new TownyException(Translatable.of("msg_err_over_outposts_limit", town.getMaxOutpostSpawn(), town.getOutpostLimit()));
        }
        return town.getOutpostSpawn(Math.max(1, index));
    }

    private static Integer getOutpostIndexFromName(Town town, Integer index, String userInput) {
        for (Location loc : town.getAllOutpostSpawns()) {
            String name;
            TownBlock tboutpost = TownyAPI.getInstance().getTownBlock(loc);
            if (tboutpost == null || !(name = !tboutpost.hasPlotObjectGroup() ? tboutpost.getName() : tboutpost.getPlotObjectGroup().getName()).toLowerCase(Locale.ROOT).startsWith(userInput.toLowerCase(Locale.ROOT))) continue;
            index = 1 + town.getAllOutpostSpawns().indexOf(loc);
        }
        if (index == null) {
            index = 1;
        }
        return index;
    }

    private static void testDisallowedZones(Player player, Resident resident, SpawnType spawnType, List<String> disallowedZones) throws TownyException {
        if (!disallowedZones.isEmpty()) {
            Town townAtPlayerLoc = TownyAPI.getInstance().getTown(player.getLocation());
            if (townAtPlayerLoc == null && disallowedZones.contains("unclaimed")) {
                throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", spawnType.getTypeName(), Translatable.of("msg_the_wilderness")));
            }
            if (townAtPlayerLoc != null) {
                if (townAtPlayerLoc.hasOutlaw(player.getName()) && disallowedZones.contains("outlaw")) {
                    throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", "RTP", Translatable.of("msg_a_town_you_are_outlawed_in")));
                }
                if (resident.hasNation() && townAtPlayerLoc.hasNation()) {
                    Nation resNation;
                    if (CombatUtil.isEnemy(resident.getTownOrNull(), townAtPlayerLoc) && disallowedZones.contains("enemy")) {
                        throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", spawnType.getTypeName(), Translatable.of("msg_enemy_areas")));
                    }
                    Nation townLocNation = townAtPlayerLoc.getNationOrNull();
                    if (!townLocNation.hasAlly(resNation = resident.getNationOrNull()) && !townLocNation.hasEnemy(resNation) && disallowedZones.contains("neutral")) {
                        throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", spawnType.getTypeName(), Translatable.of("msg_neutral_towns")));
                    }
                }
            }
        }
    }

    private static double getTravelCost(Player player, Town town, Nation nation, TownSpawnLevel townSpawnLevel, NationSpawnLevel nationSpawnLevel, SpawnType spawnType) {
        double d;
        if (!TownyEconomyHandler.isActive() || SpawnUtil.playerHasFreeSpawn(player)) {
            return 0.0;
        }
        if (!TownySettings.isPublicSpawnCostAffectedByTownSpawncost() && (SpawnUtil.isPublicSpawn(townSpawnLevel) || SpawnUtil.isPublicSpawn(nationSpawnLevel))) {
            return TownySettings.getSpawnTravelCost();
        }
        switch (spawnType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RESIDENT: {
                if (town == null) {
                    d = 0.0;
                    break;
                }
                d = Math.min(townSpawnLevel.getCost(town), townSpawnLevel.getCost());
                break;
            }
            case TOWN: {
                d = Math.min(townSpawnLevel.getCost(town), townSpawnLevel.getCost());
                break;
            }
            case NATION: {
                d = Math.min(nationSpawnLevel.getCost(nation), nationSpawnLevel.getCost());
            }
        }
        return d;
    }

    private static boolean isPublicSpawn(NationSpawnLevel nationSpawnLevel) {
        return NationSpawnLevel.UNAFFILIATED.equals((Object)nationSpawnLevel);
    }

    private static boolean isPublicSpawn(TownSpawnLevel townSpawnLevel) {
        return TownSpawnLevel.UNAFFILIATED.equals((Object)townSpawnLevel);
    }

    private static String getPaymentMsg(TownSpawnLevel townSpawnLevel, NationSpawnLevel nationSpawnLevel, SpawnType spawnType) {
        String string;
        switch (spawnType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RESIDENT: {
                string = String.format(spawnType.getTypeName() + " (%s)", new Object[]{townSpawnLevel});
                break;
            }
            case TOWN: {
                string = String.format(spawnType.getTypeName() + " (%s)", new Object[]{townSpawnLevel});
                break;
            }
            case NATION: {
                string = String.format(spawnType.getTypeName() + " (%s)", new Object[]{nationSpawnLevel});
            }
        }
        return string;
    }

    private static Account getPayee(Town town, Nation nation, SpawnType spawnType) {
        Account account;
        switch (spawnType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RESIDENT: {
                if (town == null) {
                    account = EconomyAccount.SERVER_ACCOUNT;
                    break;
                }
                account = town.getAccount();
                break;
            }
            case TOWN: {
                account = town.getAccount();
                break;
            }
            case NATION: {
                account = nation.getAccount();
            }
        }
        return account;
    }

    private static void sendSpawnEvent(Player player, SpawnType spawnType, Location spawnLoc, SpawnInformation spawnInformation) throws TownyException {
        BukkitTools.ifCancelledThenThrow(SpawnUtil.getSpawnEvent(player, spawnType, spawnLoc, spawnInformation));
    }

    private static SpawnEvent getSpawnEvent(Player player, SpawnType spawnType, Location spawnLoc, SpawnInformation spawnInfo) {
        SpawnEvent spawnEvent;
        switch (spawnType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RESIDENT: {
                spawnEvent = new ResidentSpawnEvent(player, player.getLocation(), spawnLoc, spawnInfo.eventCancelled, spawnInfo.eventCancellationMessage);
                break;
            }
            case TOWN: {
                spawnEvent = new TownSpawnEvent(player, player.getLocation(), spawnLoc, spawnInfo.eventCancelled, spawnInfo.eventCancellationMessage);
                break;
            }
            case NATION: {
                spawnEvent = new NationSpawnEvent(player, player.getLocation(), spawnLoc, spawnInfo.eventCancelled, spawnInfo.eventCancellationMessage);
            }
        }
        return spawnEvent;
    }

    private static void initiateSpawn(Player player, Location spawnLoc, int cooldown, double cost, @Nullable Account refundAccount) {
        if (TownyTimerHandler.isTeleportWarmupRunning() && !SpawnUtil.hasPerm(player, PermissionNodes.TOWNY_SPAWN_ADMIN_NOWARMUP)) {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_town_spawn_warmup", TownySettings.getTeleportWarmupTime()));
            Resident resident = TownyAPI.getInstance().getResident(player);
            if (resident != null) {
                TeleportWarmupTimerTask.requestTeleport(resident, spawnLoc, cooldown, refundAccount, cost);
            }
        } else {
            if (player.getVehicle() != null) {
                player.getVehicle().eject();
            }
            PaperLib.teleportAsync((Entity)player, spawnLoc, PlayerTeleportEvent.TeleportCause.COMMAND);
            if (cooldown > 0 && !SpawnUtil.hasPerm(player, PermissionNodes.TOWNY_SPAWN_ADMIN_NOCOOLDOWN)) {
                CooldownTimerTask.addCooldownTimer(player.getName(), "teleport", cooldown);
            }
        }
    }

    private static void initiateCostedSpawn(Player player, Resident resident, Location spawnLoc, double travelCost, Account payee, String paymentMsg, boolean ignoreWarn, int cooldown) {
        if (ignoreWarn || !TownySettings.isSpawnWarnConfirmationUsed()) {
            SpawnUtil.payAndThenSpawn(player, resident, spawnLoc, travelCost, payee, paymentMsg, cooldown);
        } else {
            Confirmation.runOnAccept(() -> SpawnUtil.payAndThenSpawn(player, resident, spawnLoc, travelCost, payee, paymentMsg, cooldown)).setTitle(Translatable.of("msg_spawn_warn", TownyEconomyHandler.getFormattedBalance(travelCost))).sendTo((CommandSender)player);
        }
    }

    private static void payAndThenSpawn(Player player, Resident resident, Location spawnLoc, double travelCost, Account payee, String paymentMsg, int cooldown) {
        if (resident.getAccount().payTo(travelCost, payee, paymentMsg)) {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_cost_spawn", TownyEconomyHandler.getFormattedBalance(travelCost)));
            SpawnUtil.initiateSpawn(player, spawnLoc, cooldown, travelCost, payee);
        }
    }

    private static CompletableFuture<Location> getIdealLocation(Resident resident) {
        Town town = resident.getTownOrNull();
        Location loc = resident.getPlayer().getWorld().getSpawnLocation();
        if (town != null && town.hasSpawn()) {
            loc = town.getSpawnOrNull();
        }
        Location finalLoc = loc;
        return PaperLib.getBedSpawnLocationAsync(resident.getPlayer(), true).thenApply(bed -> bed == null ? finalLoc : bed);
    }

    private static void initiatePluginTeleport(Resident resident, Location loc, boolean ignoreWarmup) {
        Player player = resident.getPlayer();
        if (player == null) {
            return;
        }
        plugin.getScheduler().runLater((Entity)player, () -> PaperLib.teleportAsync((Entity)resident.getPlayer(), loc, PlayerTeleportEvent.TeleportCause.PLUGIN), ignoreWarmup ? 0L : (long)TownySettings.getTeleportWarmupTime() * 20L);
    }

    private static void initiatePluginTeleport(Resident resident, CompletableFuture<Location> loc, boolean ignoreWarmup) {
        loc.thenAccept(location -> SpawnUtil.initiatePluginTeleport(resident, location, ignoreWarmup));
    }

    private static boolean hasPerm(Player player, PermissionNodes node) {
        return TownyUniverse.getInstance().getPermissionSource().testPermission((Permissible)player, node.getNode());
    }
}

