/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.teleport.OutlawTeleportEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyInventory;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.gui.SelectionGUI;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.utils.MetaDataUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.TimeMgmt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ResidentUtil {
    private static BooleanDataField borderMeta = new BooleanDataField("bordertitles");

    public static List<Resident> getOnlineResidentsViewable(Player viewer, ResidentList residentList) {
        return residentList.getResidents().stream().filter(res -> viewer != null ? res.isOnline() && viewer.canSee(res.getPlayer()) : res.isOnline()).collect(Collectors.toList());
    }

    public static List<Resident> getValidatedResidents(CommandSender sender, String[] names) {
        ArrayList<Resident> residents = new ArrayList<Resident>();
        for (String name : names) {
            List<Player> matches = BukkitTools.matchPlayer(name);
            if (matches.size() > 1) {
                TownyMessaging.sendErrorMsg((Object)sender, "Multiple players selected: " + matches.stream().map(Player::getName).collect(Collectors.joining(", ")));
                continue;
            }
            String targetName = !matches.isEmpty() ? matches.get(0).getName() : name;
            Resident target = TownyUniverse.getInstance().getResident(targetName);
            if (target != null) {
                residents.add(target);
                continue;
            }
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_registered_1", targetName));
        }
        return residents;
    }

    public static List<Resident> getValidatedResidentsOfTown(CommandSender sender, Town town, String[] names) {
        ArrayList<Resident> residents = new ArrayList<Resident>();
        for (String name : names) {
            if (town.hasResident(name)) {
                residents.add(TownyAPI.getInstance().getResident(name));
                continue;
            }
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_same_town", name));
        }
        return residents;
    }

    public static void openGUIInventory(Resident resident, List<String> list, String name) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String item : list) {
            Material mat = Material.getMaterial((String)item);
            if (mat == null) continue;
            items.add(new ItemStack(mat));
        }
        ResidentUtil.createTownyGUI(resident, items, name);
    }

    public static void openGUIInventory(Resident resident, Collection<Material> set, String name) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Material material : set) {
            items.add(new ItemStack(material));
        }
        ResidentUtil.createTownyGUI(resident, items, name);
    }

    public static /* bridge */ /* synthetic */ void openGUIInventory(Resident resident, Set<Material> set, String name) {
        ResidentUtil.openGUIInventory(resident, set, name);
    }

    public static void openSelectionGUI(Resident resident, SelectionGUI.SelectionType selectionType) {
        String inventoryName = Translatable.of("gui_title_select_plot_type").forLocale(resident);
        Inventory page = ResidentUtil.getBlankPage(inventoryName);
        ArrayList<Inventory> pages = new ArrayList<Inventory>();
        for (TownBlockType townBlockType : TownBlockTypeHandler.getTypes().values()) {
            ItemStack item = new ItemStack(Material.GRASS_BLOCK);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a76" + townBlockType.getFormattedName());
            item.setItemMeta(meta);
            if (page.firstEmpty() == 46) {
                pages.add(page);
                page = ResidentUtil.getBlankPage(inventoryName);
            }
            page.addItem(new ItemStack[]{item});
        }
        pages.add(page);
        resident.setGUIPageNum(0);
        resident.setGUIPages(pages);
        new SelectionGUI(resident, pages.get(0), inventoryName, selectionType);
    }

    private static void createTownyGUI(Resident resident, ArrayList<ItemStack> items, String name) {
        Inventory page = ResidentUtil.getBlankPage(name);
        ArrayList<Inventory> pages = new ArrayList<Inventory>();
        for (ItemStack item : items) {
            if (page.firstEmpty() == 46) {
                pages.add(page);
                page = ResidentUtil.getBlankPage(name);
            }
            page.addItem(new ItemStack[]{item});
        }
        pages.add(page);
        resident.setGUIPages(pages);
        resident.setGUIPageNum(0);
        new TownyInventory(resident, pages.get(0), name);
    }

    public static Inventory getBlankPage(String name) {
        Inventory page = Bukkit.createInventory(null, (int)54, (String)name);
        ItemStack nextpage = new ItemStack(Material.ARROW);
        ItemMeta meta = nextpage.getItemMeta();
        meta.setDisplayName("\u00a76Next");
        nextpage.setItemMeta(meta);
        ItemStack prevpage = new ItemStack(Material.ARROW);
        meta = prevpage.getItemMeta();
        meta.setDisplayName("\u00a76Back");
        prevpage.setItemMeta(meta);
        page.setItem(53, nextpage);
        page.setItem(45, prevpage);
        return page;
    }

    public static Resident createAndGetNPCResident() {
        Resident npc = null;
        try {
            String name = ResidentUtil.nextNpcName();
            UUID npcUUID = UUID.randomUUID();
            TownyUniverse.getInstance().getDataSource().newResident(name, npcUUID);
            npc = TownyUniverse.getInstance().getResident(npcUUID);
            npc.setRegistered(System.currentTimeMillis());
            npc.setLastOnline(0L);
            npc.setNPC(true);
            npc.save();
        }
        catch (TownyException e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "exception occurred while creating new npc resident", e);
        }
        return npc;
    }

    public static String nextNpcName() throws TownyException {
        int i = 0;
        do {
            String name = TownySettings.getNPCPrefix() + ++i;
            if (TownyUniverse.getInstance().hasResident(name)) continue;
            return name;
        } while (i <= 100000);
        throw new TownyException(Translatable.of("msg_err_too_many_npc"));
    }

    public static void reduceResidentCountToFitTownMaxPop(Town town) {
        if (TownySettings.getMaxResidentsPerTown() == 0) {
            return;
        }
        int max = TownySettings.getMaxResidentsForTown(town);
        if (town.getNumResidents() <= max) {
            return;
        }
        int i = 1;
        ArrayList<Resident> toRemove = new ArrayList<Resident>(town.getNumResidents() - max);
        for (Resident res2 : town.getResidents()) {
            if (i > max) {
                toRemove.add(res2);
            }
            ++i;
        }
        if (!toRemove.isEmpty()) {
            toRemove.stream().forEach(res -> res.removeTown());
        }
    }

    public static void outlawEnteredTown(Resident outlaw, Town town, Location location) {
        OutlawTeleportEvent outlawEvent = new OutlawTeleportEvent(outlaw, town, location);
        if (BukkitTools.isEventCancelled(outlawEvent)) {
            return;
        }
        boolean hasBypassNode = outlaw.hasPermissionNode(PermissionNodes.TOWNY_ADMIN_OUTLAW_TELEPORT_BYPASS.getNode());
        if (TownySettings.doTownsGetWarnedOnOutlaw() && !hasBypassNode && !CooldownTimerTask.hasCooldown(outlaw.getName(), CooldownTimerTask.CooldownType.OUTLAW_WARNING)) {
            if (TownySettings.getOutlawWarningMessageCooldown() > 0) {
                CooldownTimerTask.addCooldownTimer(outlaw.getName(), CooldownTimerTask.CooldownType.OUTLAW_WARNING);
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_outlaw_town_notify", outlaw.getFormattedName()));
        }
        if (TownySettings.canOutlawsEnterTowns() || hasBypassNode) {
            TownyMessaging.sendMsg(outlaw, Translatable.of("msg_you_are_an_outlaw_in_this_town", town));
        } else {
            if (TownySettings.getOutlawTeleportWarmup() > 0) {
                TownyMessaging.sendMsg(outlaw, Translatable.of("msg_outlaw_kick_cooldown", town, TimeMgmt.formatCountdownTime(TownySettings.getOutlawTeleportWarmup())));
            }
            Towny.getPlugin().getScheduler().runLater(() -> {
                Player player = outlaw.getPlayer();
                if (player == null) {
                    return;
                }
                Town currTown = TownyAPI.getInstance().getTown(player.getLocation());
                if (currTown == null || currTown != town) {
                    return;
                }
                SpawnUtil.outlawTeleport(town, outlaw);
            }, (long)TownySettings.getOutlawTeleportWarmup() * 20L);
        }
    }

    public static void toggleResidentBorderTitles(Resident resident, Optional<Boolean> choice) {
        boolean borderTitleActive = choice.orElse(!resident.isSeeingBorderTitles());
        MetaDataUtil.setBoolean(resident, borderMeta, borderTitleActive, true);
        TownyMessaging.sendMsg(resident, Translatable.of("msg_border_titles_toggled", borderTitleActive ? Translatable.of("enabled") : Translatable.of("disabled")));
    }
}

