/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;

public class OutpostUtil {
    public static boolean OutpostTests(Town town, Resident resident, TownyWorld world, Coord key, boolean isAdmin, boolean isPlotSetOutpost) throws TownyException {
        int minDistance;
        if (TownySettings.isOutpostsLimitedByLevels() && town.getMaxOutpostSpawn() >= town.getOutpostLimit()) {
            throw new TownyException(Translatable.of("msg_err_not_enough_outposts_free_to_claim", town.getMaxOutpostSpawn(), town.getOutpostLimit()));
        }
        if (TownySettings.getAmountOfResidentsForOutpost() != 0 && town.getResidents().size() < TownySettings.getAmountOfResidentsForOutpost()) {
            throw new TownyException(Translatable.of("msg_err_not_enough_residents"));
        }
        int maxOutposts = TownySettings.getMaxResidentOutposts(resident);
        if (!isAdmin && maxOutposts != -1 && maxOutposts <= town.getAllOutpostSpawns().size()) {
            throw new TownyException(Translatable.of("msg_max_outposts_own", maxOutposts));
        }
        if (world.getMinDistanceFromOtherTownsHomeBlocks(key) < TownySettings.getMinDistanceFromTownHomeblocks()) {
            throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("homeblock")));
        }
        int maxDistance = TownySettings.getMaxDistanceForOutpostsFromTown();
        if (maxDistance > 0) {
            if (!world.getName().equalsIgnoreCase(town.getHomeblockWorld().getName())) {
                throw new TownyException(Translatable.of("msg_err_you_can_only_claim_outposts_in_your_homeblocks_world"));
            }
            int distance = world.getMinDistanceFromOtherPlotsOwnedByTown(key, town);
            if (distance > maxDistance) {
                throw new TownyException(Translatable.of("msg_err_not_close_enough_to_your_town_nearest_plot", distance, maxDistance));
            }
        }
        if ((minDistance = world.getMinDistanceFromOtherTownsPlots(key, isPlotSetOutpost ? town : null)) < TownySettings.getMinDistanceFromTownPlotblocks() || minDistance < TownySettings.getMinDistanceForOutpostsFromPlot()) {
            throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("townblock")));
        }
        return true;
    }
}

