/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TeleportRequest;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.paperlib.PaperLib;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeleportWarmupTimerTask
extends TownyTimerTask {
    private static final Map<Resident, TeleportRequest> TELEPORT_QUEUE = new ConcurrentHashMap<Resident, TeleportRequest>();

    public TeleportWarmupTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<Resident, TeleportRequest>> iterator = TELEPORT_QUEUE.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Resident, TeleportRequest> next = iterator.next();
            Resident resident = next.getKey();
            TeleportRequest request = next.getValue();
            if (currentTime <= request.requestTime() + (long)TownySettings.getTeleportWarmupTime() * 1000L) continue;
            iterator.remove();
            Player player = resident.getPlayer();
            if (player == null) continue;
            PaperLib.teleportAsync((Entity)player, request.destinationLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
            if (request.cooldown() <= 0) continue;
            CooldownTimerTask.addCooldownTimer(resident.getName(), "teleport", request.cooldown());
        }
    }

    public static void requestTeleport(Resident resident, Location spawnLoc) {
        TeleportWarmupTimerTask.requestTeleport(resident, spawnLoc, 0);
    }

    public static void requestTeleport(Resident resident, Location spawnLoc, int cooldown) {
        TeleportWarmupTimerTask.requestTeleport(resident, spawnLoc, cooldown, null, 0.0);
    }

    public static void requestTeleport(@NotNull Resident resident, @NotNull Location destination, int cooldown, @Nullable Account teleportAccount, double teleportCost) {
        TeleportRequest request = TeleportRequest.teleportRequest(System.currentTimeMillis(), destination, cooldown, teleportCost, teleportAccount);
        TELEPORT_QUEUE.put(resident, request);
    }

    public static boolean abortTeleportRequest(Resident resident) {
        if (resident == null) {
            return false;
        }
        TeleportRequest request = TELEPORT_QUEUE.remove(resident);
        if (request == null) {
            return false;
        }
        if (request.teleportCost() != 0.0 && TownyEconomyHandler.isActive() && request.teleportAccount() != null) {
            request.teleportAccount().payTo(request.teleportCost(), resident.getAccount(), Translation.of("msg_cost_spawn_refund"));
            TownyMessaging.sendMsg(resident, Translatable.of("msg_cost_spawn_refund"));
        }
        return true;
    }

    public static boolean hasTeleportRequest(@NotNull Resident resident) {
        return TELEPORT_QUEUE.containsKey(resident);
    }

    public static TeleportRequest getTeleportRequest(@NotNull Resident resident) {
        return TELEPORT_QUEUE.get(resident);
    }

    static {
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:warmup-task"), () -> TownyTimerHandler.toggleTeleportWarmup(TownySettings.getTeleportWarmupTime() > 0));
    }
}

