/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.tasks.DailyTimerTask;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.util.TimeMgmt;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.ApiStatus;

public class NewDayScheduler
extends TownyTimerTask {
    private static long newDayInterval = -1L;
    private static Timer newDayTimer;
    private static ScheduledTask scheduleTask;
    private static ScheduledTask newDayTask;

    public NewDayScheduler(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        NewDayScheduler.logTime();
        NewDayScheduler.cancelScheduledNewDay();
        newDayInterval = TownySettings.getDayInterval();
        if (!TownySettings.doesNewDayUseTimer()) {
            long secondsUntilNextNewDay = TimeMgmt.townyTime();
            if (secondsUntilNextNewDay < TimeUnit.MINUTES.toSeconds(2L)) {
                TownyMessaging.sendDebugMsg("New Day time finalized for: " + TimeMgmt.formatCountdownTime(secondsUntilNextNewDay) + " from now.");
                this.scheduleUpComingNewDay(secondsUntilNextNewDay);
            } else {
                scheduleTask = this.plugin.getScheduler().runLater(new NewDayScheduler(this.plugin), secondsUntilNextNewDay / 2L * 20L);
                TownyMessaging.sendDebugMsg("Re-evaluation of New Day time scheduled for: " + TimeMgmt.formatCountdownTime(secondsUntilNextNewDay / 2L) + " from now.");
            }
        } else {
            TownyMessaging.sendDebugMsg("Starting new new day scheduler timer.");
            newDayTimer = new Timer("towny-new-day-scheduler", true);
            newDayTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    NewDayScheduler.newDay();
                }
            }, TimeUnit.SECONDS.toMillis(TimeMgmt.townyTime()), TimeUnit.SECONDS.toMillis(TownySettings.getDayInterval()));
        }
    }

    private void scheduleUpComingNewDay(long secondsUntilNextNewDay) {
        this.plugin.getScheduler().runAsyncLater(() -> TownyEconomyHandler.economyExecutor().execute(new DailyTimerTask(this.plugin)), secondsUntilNextNewDay * 20L);
    }

    public static boolean isNewDaySchedulerRunning() {
        if (TownySettings.doesNewDayUseTimer()) {
            return newDayTimer != null;
        }
        return scheduleTask != null && !scheduleTask.isCancelled();
    }

    public static boolean isNewDayScheduled() {
        return newDayTask != null && !newDayTask.isCancelled();
    }

    public static void cancelScheduledNewDay() {
        if (newDayTimer != null) {
            newDayTimer.cancel();
            newDayTimer = null;
        }
        if (scheduleTask != null) {
            scheduleTask.cancel();
            scheduleTask = null;
        }
        if (newDayTask != null) {
            newDayTask.cancel();
            newDayTask = null;
        }
    }

    public static void newDay() {
        TownyEconomyHandler.economyExecutor().execute(new DailyTimerTask(Towny.getPlugin()));
    }

    public static void logTime() {
        Towny.getPlugin().getLogger().info("Time until a New Day: " + TimeMgmt.formatCountdownTime(TimeMgmt.townyTime()));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Long townyTime() {
        return TimeMgmt.townyTime();
    }

    static {
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:new-day-scheduler"), config -> {
            if (newDayInterval != TownySettings.getDayInterval() && NewDayScheduler.isNewDaySchedulerRunning()) {
                NewDayScheduler.cancelScheduledNewDay();
                new NewDayScheduler(Towny.getPlugin()).run();
            }
        });
        scheduleTask = null;
        newDayTask = null;
    }
}

