/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class HealthRegenTimerTask
extends TownyTimerTask {
    private final Server server;

    public HealthRegenTimerTask(Towny plugin, Server server) {
        super(plugin);
        this.server = server;
    }

    @Override
    public void run() {
        if (this.plugin.isFolia()) {
            for (Player player : this.server.getOnlinePlayers()) {
                this.plugin.getScheduler().run((Entity)player, () -> this.checkPlayer(player));
            }
        } else {
            for (Player player : this.server.getOnlinePlayers()) {
                this.checkPlayer(player);
            }
        }
    }

    public void checkPlayer(Player player) {
        if (player.getHealth() <= 0.0) {
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player);
        if (townBlock == null) {
            return;
        }
        Town playerTown = TownyAPI.getInstance().getTown(player);
        if (playerTown != null && !playerTown.hasActiveWar() && CombatUtil.isAlly(townBlock.getTownOrNull(), playerTown) && !townBlock.getType().equals(TownBlockType.ARENA)) {
            this.incHealth(player);
        }
    }

    public void incHealth(Player player) {
        double maxHP;
        double currentHP;
        if (player.getSaturation() == 0.0f) {
            player.setSaturation(1.0f);
        }
        if ((currentHP = player.getHealth()) < (maxHP = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue())) {
            player.setHealth(Math.min(maxHP, currentHP += 1.0));
            BukkitTools.fireEvent((Event)new EntityRegainHealthEvent((Entity)player, currentHP, EntityRegainHealthEvent.RegainReason.REGEN));
        }
    }

    static {
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:health-regen-task"), () -> TownyTimerHandler.toggleHealthRegen(TownySettings.hasHealthRegen()));
    }
}

