/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.CancellableTownyEvent;
import com.palmergames.bukkit.towny.event.NewDayEvent;
import com.palmergames.bukkit.towny.event.PreNewDayEvent;
import com.palmergames.bukkit.towny.event.time.dailytaxes.NewDayTaxAndUpkeepPreCollectionEvent;
import com.palmergames.bukkit.towny.event.time.dailytaxes.PreTownPaysNationTaxEvent;
import com.palmergames.bukkit.towny.event.time.dailytaxes.TownPaysNationConqueredTaxEvent;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.NPCCleanupTask;
import com.palmergames.bukkit.towny.tasks.NewDayScheduler;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DailyTimerTask
extends TownyTimerTask {
    private double totalTownUpkeep = 0.0;
    private double totalNationUpkeep = 0.0;
    private double taxCollected = 0.0;
    private double conqueredTaxCollected = 0.0;
    private final List<String> bankruptedTowns = new ArrayList<String>();
    private final List<String> removedTowns = new ArrayList<String>();
    private final List<String> removedNations = new ArrayList<String>();

    public DailyTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        this.totalTownUpkeep = 0.0;
        this.totalNationUpkeep = 0.0;
        this.taxCollected = 0.0;
        this.bankruptedTowns.clear();
        this.removedTowns.clear();
        this.removedNations.clear();
        BukkitTools.fireEvent(new PreNewDayEvent());
        TownyMessaging.sendDebugMsg("New Day");
        if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily()) {
            if (!BukkitTools.isEventCancelled(new NewDayTaxAndUpkeepPreCollectionEvent())) {
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_day_tax"));
                TownyMessaging.sendDebugMsg("Collecting Town Taxes");
                this.collectTownTaxes();
                TownyMessaging.sendDebugMsg("Collecting Nation Taxes");
                this.collectNationTaxes();
                TownyMessaging.sendDebugMsg("Collecting Town Costs");
                this.collectTownCosts();
                TownyMessaging.sendDebugMsg("Collecting Nation Costs");
                this.collectNationCosts();
            } else {
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_day"));
            }
        } else {
            TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_day"));
        }
        if (TownySettings.isDeletingOldResidents()) {
            this.plugin.getScheduler().runAsync(new ResidentPurge(null, TownySettings.getDeleteTime() * 1000L, TownySettings.isDeleteTownlessOnly(), null));
        }
        this.plugin.getScheduler().runAsync(new NPCCleanupTask());
        if (TownySettings.isNewDayDeleting0PlotTowns()) {
            ArrayList<String> deletedTowns = new ArrayList<String>();
            for (Town town : this.universe.getTowns()) {
                if (town.getTownBlocks().size() != 0) continue;
                deletedTowns.add(town.getName());
                this.removedTowns.add(town.getName());
                this.universe.getDataSource().removeTown(town);
            }
            if (!deletedTowns.isEmpty()) {
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_the_following_towns_were_deleted_for_having_0_claims", String.join((CharSequence)", ", deletedTowns)));
            }
        }
        for (Town town : this.universe.getTowns()) {
            if (!town.isConquered()) continue;
            if (town.getConqueredDays() == 1) {
                this.plugin.getScheduler().run(() -> this.unconquer(town));
                continue;
            }
            town.setConqueredDays(town.getConqueredDays() - 1);
        }
        if (TownySettings.isBackingUpDaily()) {
            this.universe.performCleanupAndBackup();
        }
        BukkitTools.fireEvent(new NewDayEvent(this.bankruptedTowns, this.removedTowns, this.removedNations, this.totalTownUpkeep, this.totalNationUpkeep, start));
        TownyMessaging.sendDebugMsg("Finished New Day Code");
        TownyMessaging.sendDebugMsg("Universe Stats:");
        TownyMessaging.sendDebugMsg("    Residents: " + this.universe.getNumResidents());
        TownyMessaging.sendDebugMsg("    Towns: " + this.universe.getTowns().size());
        TownyMessaging.sendDebugMsg("    Nations: " + this.universe.getNumNations());
        for (TownyWorld world : this.universe.getTownyWorlds()) {
            TownyMessaging.sendDebugMsg("    " + world.getName() + " (townblocks): " + this.universe.getTownBlocks().size());
        }
        TownyMessaging.sendDebugMsg("Memory (Java Heap):");
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (max)", Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (total)", Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (free)", Runtime.getRuntime().freeMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (used=total-free)", (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L));
        Towny.getPlugin().getLogger().info("Towny DailyTimerTask took " + (System.currentTimeMillis() - start) + "ms to process.");
        if (!NewDayScheduler.isNewDaySchedulerRunning()) {
            this.plugin.getScheduler().runLater(new NewDayScheduler(this.plugin), 1200L);
        }
    }

    private void unconquer(Town town) {
        town.setConquered(false);
        town.setConqueredDays(0);
    }

    public void collectNationTaxes() {
        ArrayList<Nation> nations = new ArrayList<Nation>(this.universe.getNations());
        ListIterator nationItr = nations.listIterator();
        while (nationItr.hasNext()) {
            this.taxCollected = 0.0;
            Nation nation = (Nation)nationItr.next();
            if (!this.universe.hasNation(nation.getName())) continue;
            this.collectNationTaxes(nation);
        }
    }

    protected void collectNationTaxes(Nation nation) {
        ArrayList<String> newlyDelinquentTowns = new ArrayList<String>();
        ArrayList<String> localTownsDestroyed = new ArrayList<String>();
        ArrayList<Town> towns = new ArrayList<Town>(nation.getTowns());
        ListIterator townItr = towns.listIterator();
        while (townItr.hasNext()) {
            String result;
            Town town = (Town)townItr.next();
            if (!this.universe.hasTown(town.getName()) || town.isCapital() && !TownySettings.doCapitalsPayNationTax() || !town.hasUpkeep() || town.isRuined() || (result = this.processTownPaysNationTax(town, nation)).isEmpty()) continue;
            switch (result) {
                case "destroyed": {
                    localTownsDestroyed.add(town.getName());
                    break;
                }
                case "delinquent": {
                    newlyDelinquentTowns.add(town.getName());
                }
            }
        }
        if (newlyDelinquentTowns != null && !newlyDelinquentTowns.isEmpty()) {
            String msg2;
            boolean bankruptcyenabled = TownySettings.isTownBankruptcyEnabled() && TownySettings.doBankruptTownsPayNationTax();
            String msg1 = bankruptcyenabled ? "msg_town_bankrupt_by_nation_tax" : "msg_couldnt_pay_tax";
            String string = msg2 = bankruptcyenabled ? "msg_town_bankrupt_by_nation_tax_multiple" : "msg_couldnt_pay_nation_tax_multiple";
            if (newlyDelinquentTowns.size() == 1) {
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of(msg1, newlyDelinquentTowns.get(0), Translatable.of("nation_sing")));
            } else {
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of(msg2).append(StringMgmt.join(newlyDelinquentTowns, ", ")));
            }
        }
        if (localTownsDestroyed != null && !localTownsDestroyed.isEmpty()) {
            if (localTownsDestroyed.size() == 1) {
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_town_destroyed_by_nation_tax", localTownsDestroyed.get(0)));
            } else {
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_town_destroyed_by_nation_tax_multiple").append(StringMgmt.join(localTownsDestroyed, ", ")));
            }
        }
        if (this.taxCollected > 0.0) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_tax_collected_from_towns", this.prettyMoney(this.taxCollected)));
            this.taxCollected = 0.0;
        }
        if (this.conqueredTaxCollected > 0.0) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_tax_collected_from_conquered_towns", this.prettyMoney(this.conqueredTaxCollected)));
            this.conqueredTaxCollected = 0.0;
        }
    }

    private String processTownPaysNationTax(Town town, Nation nation) {
        CancellableTownyEvent event;
        double taxAmount = nation.getTaxes();
        double localConqueredTax = 0.0;
        if (nation.isTaxPercentage()) {
            taxAmount = town.getAccount().getHoldingBalance() * taxAmount / 100.0;
            taxAmount = Math.min(taxAmount, nation.getMaxPercentTaxAmount());
        }
        if (town.isConquered() && !BukkitTools.isEventCancelled(event = new TownPaysNationConqueredTaxEvent(town, nation, nation.getConqueredTax())) && ((TownPaysNationConqueredTaxEvent)event).getConqueredTax() > 0.0) {
            localConqueredTax = ((TownPaysNationConqueredTaxEvent)event).getConqueredTax();
            taxAmount += localConqueredTax;
        }
        if (BukkitTools.isEventCancelled(event = new PreTownPaysNationTaxEvent(town, nation, taxAmount))) {
            TownyMessaging.sendPrefixedTownMessage(town, event.getCancelMessage());
            return "";
        }
        taxAmount = ((PreTownPaysNationTaxEvent)event).getTax();
        if (!nation.isTaxPercentage() && taxAmount < 0.0) {
            this.payNationTaxToTown(taxAmount, town, nation);
            return "";
        }
        if (nation.getBankCap() != 0.0 && taxAmount + nation.getAccount().getHoldingBalance() > nation.getBankCap()) {
            taxAmount = nation.getBankCap() - nation.getAccount().getHoldingBalance();
        }
        if (taxAmount == 0.0) {
            return "";
        }
        if (town.getAccount().canPayFromHoldings(taxAmount)) {
            town.getAccount().payTo(taxAmount, nation, String.format("Nation Tax to %s paid by %s.", nation.getName(), town.getName()));
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_payed_nation_tax", this.prettyMoney(taxAmount)));
            this.taxCollected += taxAmount;
            if (localConqueredTax > 0.0) {
                this.conqueredTaxCollected += localConqueredTax;
            }
            return "";
        }
        if (!TownySettings.isTownBankruptcyEnabled() || !TownySettings.doBankruptTownsPayNationTax()) {
            if (TownySettings.doesNationTaxDeleteConqueredTownsWhichCannotPay() && town.isConquered()) {
                this.universe.getDataSource().removeTown(town);
                return "destroyed";
            }
            town.removeNation();
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_your_town_couldnt_pay_the_nation_tax_of", this.prettyMoney(taxAmount)));
            return "delinquent";
        }
        boolean townWasBankrupt = town.isBankrupt();
        town.getAccount().setDebtCap(MoneyUtil.getEstimatedValueOfTown(town));
        if (town.getAccount().getHoldingBalance() - taxAmount < town.getAccount().getDebtCap() * -1.0) {
            if (TownySettings.isNationTaxKickingTownsThatReachDebtCap()) {
                town.removeNation();
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_your_town_couldnt_pay_the_nation_tax_of", this.prettyMoney(nation.getTaxes())));
                return "delinquent";
            }
            taxAmount = town.getAccount().getDebtCap() - Math.abs(town.getAccount().getHoldingBalance());
        }
        town.getAccount().withdraw(taxAmount, String.format("Nation Tax paid to %s.", nation.getName()));
        nation.getAccount().deposit(taxAmount, String.format("Nation Tax paid by %.", town.getName()));
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_payed_nation_tax_with_debt", this.prettyMoney(taxAmount)));
        this.taxCollected += taxAmount;
        if (localConqueredTax > 0.0) {
            this.conqueredTaxCollected += localConqueredTax;
        }
        if (!townWasBankrupt) {
            town.setOpen(false);
            town.save();
            return "delinquent";
        }
        return "";
    }

    private void payNationTaxToTown(double taxAmount, Town town, Nation nation) {
    }

    public void collectTownTaxes() {
        ArrayList<Town> towns = new ArrayList<Town>(this.universe.getTowns());
        ListIterator townItr = towns.listIterator();
        while (townItr.hasNext()) {
            this.taxCollected = 0.0;
            Town town = (Town)townItr.next();
            if (!this.universe.hasTown(town.getName()) || town.isRuined()) continue;
            this.collectTownTaxes(town);
        }
    }

    protected void collectTownTaxes(Town town) {
        this.collectTownResidentTax(town);
        if (this.taxCollected > 0.0) {
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_tax_collected_from_residents", this.prettyMoney(this.taxCollected)));
            this.taxCollected = 0.0;
        }
        this.collecTownPlotTax(town);
        if (this.taxCollected > 0.0) {
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_tax_collected_from_plots", this.prettyMoney(this.taxCollected)));
            this.taxCollected = 0.0;
        }
    }

    private void collectTownResidentTax(Town town) {
        double tax = town.getTaxes();
        if (tax == 0.0) {
            return;
        }
        ArrayList residents = new ArrayList(town.getResidents());
        ListIterator residentItr = residents.listIterator();
        ArrayList<String> removedResidents = new ArrayList<String>();
        while (residentItr.hasNext()) {
            Resident resident = (Resident)residentItr.next();
            if (!this.universe.hasResident(resident.getName())) continue;
            if (TownyPerms.getResidentPerms(resident).get("towny.tax_exempt") == Boolean.TRUE || resident.isNPC() || resident.isMayor()) {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_tax_exempt"));
                continue;
            }
            if (this.collectTownTaxFromResident(tax, resident, town)) continue;
            removedResidents.add(resident.getName());
        }
        if (removedResidents != null && !removedResidents.isEmpty()) {
            if (removedResidents.size() == 1) {
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_couldnt_pay_tax", removedResidents.get(0), Translatable.of("town_sing")));
            } else {
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_couldnt_pay_town_tax_multiple").append(StringMgmt.join(removedResidents, ", ")));
            }
        }
    }

    private boolean collectTownTaxFromResident(double tax, Resident resident, Town town) {
        if (tax < 0.0) {
            this.payTownTaxToResidents(town);
            return true;
        }
        if (town.isTaxPercentage()) {
            tax = resident.getAccount().getHoldingBalance() * tax / 100.0;
            tax = Math.min(tax, town.getMaxPercentTaxAmount());
            if (town.getBankCap() != 0.0 && tax + town.getAccount().getHoldingBalance() > town.getBankCap()) {
                tax = town.getBankCap() - town.getAccount().getHoldingBalance();
            }
            if (tax == 0.0) {
                return true;
            }
            resident.getAccount().payTo(tax, town, String.format("Town Tax (Percentage) paid by %s.", resident.getName()));
            this.taxCollected += tax;
            return true;
        }
        if (town.getBankCap() != 0.0 && tax + town.getAccount().getHoldingBalance() > town.getBankCap()) {
            tax = town.getBankCap() - town.getAccount().getHoldingBalance();
        }
        if (tax == 0.0) {
            return true;
        }
        if (resident.getAccount().canPayFromHoldings(tax)) {
            resident.getAccount().payTo(tax, town, String.format("Town tax (FlatRate) paid by %s.", resident.getName()));
            this.taxCollected += tax;
            return true;
        }
        resident.removeTown();
        return false;
    }

    private void payTownTaxToResidents(Town town) {
    }

    private void collecTownPlotTax(Town town) {
        ArrayList<TownBlock> townBlocks = new ArrayList<TownBlock>(town.getTownBlocks());
        ArrayList<String> lostPlots = new ArrayList<String>();
        ListIterator townBlockItr = townBlocks.listIterator();
        while (townBlockItr.hasNext()) {
            Resident resident;
            TownBlock townBlock = (TownBlock)townBlockItr.next();
            double tax = townBlock.getType().getTax(town);
            if (!townBlock.hasResident() || tax == 0.0 || !TownySettings.isNegativePlotTaxAllowed() && tax < 1.0 || (resident = townBlock.getResidentOrNull()) == null || !this.universe.hasResident(resident.getName()) || resident.isNPC() || town.hasResident(resident) && TownyPerms.getResidentPerms(resident).get("towny.tax_exempt") == Boolean.TRUE) continue;
            if (tax < 0.0) {
                this.payPlotTaxToResidents(Math.abs(tax), resident, town, townBlock.getTypeName());
                continue;
            }
            if (town.getBankCap() != 0.0 && tax + town.getAccount().getHoldingBalance() > town.getBankCap()) {
                tax = town.getBankCap() - town.getAccount().getHoldingBalance();
            }
            if (tax == 0.0 || this.collectPlotTaxFromResident(tax, resident, town, townBlock) || lostPlots.contains(resident.getName())) continue;
            lostPlots.add(resident.getName());
        }
        if (lostPlots != null && !lostPlots.isEmpty()) {
            if (lostPlots.size() == 1) {
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_couldnt_pay_plot_taxes", lostPlots.get(0)));
            } else {
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_couldnt_pay_plot_taxes_multiple").append(StringMgmt.join(lostPlots, ", ")));
            }
        }
    }

    private boolean collectPlotTaxFromResident(double tax, Resident resident, Town town, TownBlock townBlock) {
        if (resident.getAccount().canPayFromHoldings(tax)) {
            resident.getAccount().payTo(tax, town, String.format("Plot Tax (%s) paid by %s", townBlock.getTypeName(), resident.getName()));
            this.taxCollected += tax;
            return true;
        }
        townBlock.setResident(null);
        if (TownySettings.doesPlotTaxNonPaymentSetPlotForSale()) {
            townBlock.setPlotPrice(town.getPlotTypePrice(townBlock.getType()));
        } else {
            townBlock.setPlotPrice(-1.0);
        }
        townBlock.setType(townBlock.getType());
        townBlock.save();
        return false;
    }

    private void payPlotTaxToResidents(double tax, Resident resident, Town town, String typeName) {
        if (!town.getAccount().canPayFromHoldings(tax)) {
            return;
        }
        town.getAccount().payTo(tax, resident.getAccount(), String.format("Plot Tax Payment To Resident (%s)", typeName));
    }

    public void collectTownCosts() {
        ArrayList<Town> towns = new ArrayList<Town>(this.universe.getTowns());
        ListIterator townItr = towns.listIterator();
        while (townItr.hasNext()) {
            Town town = (Town)townItr.next();
            if (!this.universe.hasTown(town.getName()) || !town.hasUpkeep() || town.isRuined()) continue;
            this.processTownUpkeep(town);
        }
        String msg1 = "msg_bankrupt_town2";
        String msg2 = "msg_bankrupt_town_multiple";
        if (TownySettings.isTownBankruptcyEnabled() && TownySettings.isUpkeepDeletingTownsThatReachDebtCap()) {
            this.plugin.resetCache();
            msg1 = "msg_town_reached_debtcap_and_is_disbanded";
            msg2 = "msg_town_reached_debtcap_and_is_disbanded_multiple";
        }
        if (this.bankruptedTowns != null && !this.bankruptedTowns.isEmpty()) {
            if (this.bankruptedTowns.size() == 1) {
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_town_bankrupt_by_upkeep", this.bankruptedTowns.get(0)));
            } else {
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_town_bankrupt_by_upkeep_multiple").append(StringMgmt.join(this.bankruptedTowns, ", ")));
            }
        }
        if (this.removedTowns != null && !this.removedTowns.isEmpty()) {
            if (this.removedTowns.size() == 1) {
                TownyMessaging.sendGlobalMessage(Translatable.of(msg1, this.removedTowns.get(0)));
            } else {
                TownyMessaging.sendGlobalMessage(Translatable.of(msg2).append(StringMgmt.join(this.removedTowns, ", ")));
            }
        }
    }

    private void processTownUpkeep(Town town) {
        double neutralityCost;
        double upkeep = TownySettings.getTownUpkeepCost(town);
        double upkeepPenalty = TownySettings.getTownPenaltyUpkeepCost(town);
        if (upkeepPenalty > 0.0 && upkeep > 0.0) {
            upkeep += upkeepPenalty;
        }
        if (upkeep > 0.0) {
            this.chargeTownUpkeep(town, upkeep);
        } else if (upkeep < 0.0) {
            this.payTownNegativeUpkeep(upkeep, town);
        }
        if (town.isNeutral() && (neutralityCost = TownySettings.getTownNeutralityCost(town)) > 0.0) {
            if (town.isBankrupt() && !TownySettings.canBankruptTownsPayForNeutrality() || !town.getAccount().withdraw(neutralityCost, "Town Peace Upkeep")) {
                town.setNeutral(false);
                town.save();
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_not_peaceful"));
            } else {
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_paid_for_neutral_status", this.prettyMoney(neutralityCost)));
            }
        }
    }

    private void chargeTownUpkeep(Town town, double upkeep) {
        if (town.getAccount().canPayFromHoldings(upkeep)) {
            town.getAccount().withdraw(upkeep, "Town Upkeep");
            this.totalTownUpkeep += upkeep;
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_your_town_payed_upkeep", this.prettyMoney(upkeep)));
            return;
        }
        if (!TownySettings.isTownBankruptcyEnabled()) {
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_your_town_couldnt_pay_upkeep", this.prettyMoney(upkeep)));
            this.universe.getDataSource().removeTown(town);
            this.removedTowns.add(town.getName());
            return;
        }
        boolean townWasBankrupt = town.isBankrupt();
        town.getAccount().setDebtCap(MoneyUtil.getTownDebtCap(town, upkeep));
        if (town.getAccount().getHoldingBalance() - upkeep < town.getAccount().getDebtCap() * -1.0) {
            if (TownySettings.isUpkeepDeletingTownsThatReachDebtCap()) {
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_your_town_couldnt_pay_upkeep", this.prettyMoney(upkeep)));
                this.universe.getDataSource().removeTown(town);
                this.removedTowns.add(town.getName());
                return;
            }
            upkeep = town.getAccount().getDebtCap() - Math.abs(town.getAccount().getHoldingBalance());
        }
        town.getAccount().withdraw(upkeep, "Town Upkeep");
        this.totalTownUpkeep += upkeep;
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_your_town_payed_upkeep_with_debt", this.prettyMoney(upkeep)));
        if (!townWasBankrupt) {
            town.setOpen(false);
            town.save();
            this.bankruptedTowns.add(town.getName());
        }
    }

    private void payTownNegativeUpkeep(double upkeep, Town town) {
        upkeep = Math.abs(upkeep);
        if (TownySettings.isUpkeepPayingPlots()) {
            ArrayList<TownBlock> plots = new ArrayList<TownBlock>(town.getTownBlocks());
            double payment = upkeep / (double)plots.size();
            double townPayment = 0.0;
            for (TownBlock townBlock : plots) {
                if (townBlock.hasResident()) {
                    Resident resident = townBlock.getResidentOrNull();
                    if (resident == null) continue;
                    resident.getAccount().deposit(payment, "Negative Town Upkeep - Plot income");
                    continue;
                }
                townPayment += payment;
            }
            if (townPayment > 0.0) {
                town.getAccount().deposit(townPayment, "Negative Town Upkeep - Plot income");
            }
        } else {
            town.getAccount().deposit(upkeep, "Negative Town Upkeep");
        }
    }

    public void collectNationCosts() {
        ArrayList<Nation> nations = new ArrayList<Nation>(this.universe.getNations());
        ListIterator nationItr = nations.listIterator();
        while (nationItr.hasNext()) {
            Nation nation = (Nation)nationItr.next();
            if (!this.universe.hasNation(nation.getUUID()) || !nation.getCapital().hasUpkeep()) continue;
            this.processNationUpkeep(nation);
        }
        if (this.removedNations != null && !this.removedNations.isEmpty()) {
            if (this.removedNations.size() == 1) {
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_bankrupt_nation2", this.removedNations.get(0)));
            } else {
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_bankrupt_nation_multiple").append(StringMgmt.join(this.removedNations, ", ")));
            }
        }
    }

    private void processNationUpkeep(Nation nation) {
        double neutralityCost;
        double upkeep = TownySettings.getNationUpkeepCost(nation);
        if (upkeep > 0.0) {
            if (nation.getAccount().canPayFromHoldings(upkeep)) {
                nation.getAccount().withdraw(upkeep, "Nation Upkeep");
                this.totalNationUpkeep += upkeep;
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_your_nation_payed_upkeep", this.prettyMoney(upkeep)));
            } else {
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_your_nation_couldnt_pay_upkeep", this.prettyMoney(upkeep)));
                this.universe.getDataSource().removeNation(nation);
                this.removedNations.add(nation.getName());
            }
        } else if (upkeep < 0.0) {
            nation.getAccount().withdraw(upkeep, "Negative Nation Upkeep");
        }
        if (nation.isNeutral() && (neutralityCost = TownySettings.getNationNeutralityCost(nation)) > 0.0) {
            if (!nation.getAccount().withdraw(neutralityCost, "Nation Peace Upkeep")) {
                nation.setNeutral(false);
                nation.save();
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_not_peaceful"));
            } else {
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_paid_for_neutral_status", this.prettyMoney(neutralityCost)));
            }
        }
    }

    private String prettyMoney(double money) {
        return TownyEconomyHandler.getFormattedBalance(money);
    }
}

