/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.util.FileMgmt;
import java.io.File;

public class CleanupTask
implements Runnable {
    private String dataFolderPath = TownyUniverse.getInstance().getRootFolder() + File.separator + "data" + File.separator;

    @Override
    public void run() {
        this.cleanupBackups();
        this.cleanupPlotBlockData();
    }

    private void cleanupBackups() {
        long deleteAfter = TownySettings.getBackupLifeLength();
        if (deleteAfter >= 0L) {
            Towny.getPlugin().getLogger().info("Cleaning up old backups...");
            if (FileMgmt.deleteOldBackups(new File(TownyUniverse.getInstance().getRootFolder() + File.separator + "backup"), deleteAfter)) {
                Towny.getPlugin().getLogger().info("Successfully cleaned backups.");
            } else {
                Towny.getPlugin().getLogger().info("Could not delete old backups.");
            }
        }
    }

    private void cleanupPlotBlockData() {
        File[] worldFolders;
        File plotBlockDataFolder = new File(this.dataFolderPath + "plot-block-data");
        for (File worldfolder : worldFolders = plotBlockDataFolder.listFiles(File::isDirectory)) {
            File[] plotBlockDataFiles;
            File worldFolder = new File(this.dataFolderPath + "plot-block-data" + File.separator + worldfolder.getName());
            for (File plotBlockDataFile : plotBlockDataFiles = worldFolder.listFiles(file -> file.getName().endsWith(".data"))) {
                FileMgmt.zipFile(plotBlockDataFile, plotBlockDataFile.getParent() + File.separator + plotBlockDataFile.getName().replace("data", "zip"));
                FileMgmt.deleteFile(plotBlockDataFile);
            }
        }
    }
}

