/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public class WorldCoordMaterialRemover {
    private static final List<WorldCoord> worldCoordQueue = new ArrayList<WorldCoord>();
    private static final List<WorldCoord> activeQueue = new ArrayList<WorldCoord>();

    public static boolean hasQueue() {
        return !worldCoordQueue.isEmpty();
    }

    public static boolean isQueued(WorldCoord worldCoord) {
        return worldCoordQueue.contains(worldCoord);
    }

    public static int getQueueSize() {
        return worldCoordQueue.size();
    }

    public static void addToQueue(WorldCoord worldCoord) {
        if (!worldCoordQueue.contains(worldCoord)) {
            worldCoordQueue.add(worldCoord);
        }
    }

    @Nullable
    public static WorldCoord getWorldCoordFromQueue() {
        if (!worldCoordQueue.isEmpty()) {
            for (WorldCoord wc : worldCoordQueue) {
                if (WorldCoordMaterialRemover.isActiveQueue(wc)) continue;
                return wc;
            }
        }
        return null;
    }

    public static boolean isActiveQueue(WorldCoord worldCoord) {
        return activeQueue.contains(worldCoord);
    }

    public static int getActiveQueueSize() {
        return activeQueue.size();
    }

    public static void addToActiveQueue(WorldCoord worldCoord) {
        if (!activeQueue.contains(worldCoord)) {
            activeQueue.add(worldCoord);
        }
    }

    public static void queueUnclaimMaterialsDeletion(WorldCoord worldCoord) {
        TownyWorld world = worldCoord.getTownyWorld();
        if (world == null || WorldCoordMaterialRemover.isActiveQueue(worldCoord)) {
            return;
        }
        WorldCoordMaterialRemover.addToActiveQueue(worldCoord);
        WorldCoordMaterialRemover.deleteMaterialsFromWorldCoord(worldCoord, world.getPlotManagementDeleteIds());
    }

    public static void queueDeleteWorldCoordMaterials(WorldCoord coord, Collection<Material> collection) {
        if (WorldCoordMaterialRemover.isActiveQueue(coord)) {
            return;
        }
        WorldCoordMaterialRemover.addToActiveQueue(coord);
        WorldCoordMaterialRemover.deleteMaterialsFromWorldCoord(coord, collection);
    }

    public static void deleteMaterialsFromWorldCoord(WorldCoord coord, Collection<Material> collection) {
        Towny.getPlugin().getScheduler().run(coord.getLowerMostCornerLocation(), () -> {
            List<Block> toRemove = WorldCoordMaterialRemover.findBlocksIn(coord, collection);
            if (toRemove.isEmpty()) {
                worldCoordQueue.remove(coord);
                activeQueue.remove(coord);
                return;
            }
            WorldCoordMaterialRemover.deleteBlocks(coord, toRemove);
        });
    }

    private static List<Block> findBlocksIn(WorldCoord coord, Collection<Material> collection) {
        ArrayList<Block> toRemove = new ArrayList<Block>();
        World world = coord.getBukkitWorld();
        if (world == null) {
            return toRemove;
        }
        int maxHeight = world.getMaxHeight() - 1;
        int minHeight = world.getMinHeight();
        int plotSize = TownySettings.getTownBlockSize();
        int worldX = coord.getX() * plotSize;
        int worldZ = coord.getZ() * plotSize;
        for (int z = 0; z < plotSize; ++z) {
            for (int x = 0; x < plotSize; ++x) {
                for (int y = maxHeight; y > minHeight; --y) {
                    Block block = world.getBlockAt(worldX + x, y, worldZ + z);
                    if (!collection.contains(block.getType())) continue;
                    toRemove.add(block);
                }
            }
        }
        return toRemove;
    }

    private static void deleteBlocks(WorldCoord coord, List<Block> toRemove) {
        toRemove.forEach(block -> block.setType(Material.AIR));
        worldCoordQueue.remove(coord);
        activeQueue.remove(coord);
    }
}

