/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.events.GMGroupEvent;
import org.anjocaido.groupmanager.events.GMSystemEvent;
import org.anjocaido.groupmanager.events.GMUserEvent;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;

public class GroupManagerSource
extends TownyPermissionSource {
    public GroupManagerSource(Towny towny, Plugin test) {
        this.groupManager = (GroupManager)test;
        this.plugin = towny;
        try {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new GMCustomEventListener(), (Plugin)this.plugin);
        }
        catch (IllegalPluginAccessException e) {
            this.plugin.getLogger().warning("Your Version of GroupManager is out of date. Please update.");
        }
    }

    @Override
    public String getPrefixSuffix(Resident resident, String node) {
        Player player = resident.getPlayer();
        if (player == null) {
            return "";
        }
        String group = "";
        String user = "";
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        if (node.equals("prefix")) {
            group = handler.getGroupPrefix(handler.getPrimaryGroup(player.getName()));
            user = handler.getUserPrefix(player.getName());
        } else if (node.equals("suffix")) {
            group = handler.getGroupSuffix(handler.getPrimaryGroup(player.getName()));
            user = handler.getUserSuffix(player.getName());
        } else if (node.equals("userprefix")) {
            group = "";
            user = handler.getUserPrefix(player.getName());
        } else if (node.equals("usersuffix")) {
            group = "";
            user = handler.getUserSuffix(player.getName());
        } else if (node.equals("groupprefix")) {
            group = handler.getGroupPrefix(handler.getPrimaryGroup(player.getName()));
            user = "";
        } else if (node.equals("groupsuffix")) {
            group = handler.getGroupSuffix(handler.getPrimaryGroup(player.getName()));
            user = "";
        }
        if (group == null) {
            group = "";
        }
        if (user == null) {
            user = "";
        }
        if (!group.equals(user)) {
            user = group + user;
        }
        user = Colors.translateColorCodes(user);
        return user;
    }

    @Override
    public int getGroupPermissionIntNode(String playerName, String node) {
        int iReturn = -1;
        Player player = BukkitTools.getPlayerExact(playerName);
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        iReturn = handler.getPermissionInteger(playerName, node);
        if (iReturn == -1) {
            iReturn = this.getEffectivePermIntNode(playerName, node);
        }
        return iReturn;
    }

    @Override
    public int getPlayerPermissionIntNode(String playerName, String node) {
        Player player = BukkitTools.getPlayerExact(playerName);
        if (player == null) {
            return -1;
        }
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        int iReturn = handler.getPermissionInteger(playerName, node);
        if (iReturn == -1) {
            iReturn = this.getEffectivePermIntNode(playerName, node);
        }
        return iReturn;
    }

    @Override
    public String getPlayerPermissionStringNode(String playerName, String node) {
        Player player = BukkitTools.getPlayerExact(playerName);
        if (player == null) {
            return "";
        }
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        return handler.getPermissionString(playerName, node);
    }

    @Override
    public String getPlayerGroup(Player player) {
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        return handler.getGroup(player.getName());
    }

    protected class GMCustomEventListener
    implements Listener {
        @EventHandler(priority=EventPriority.HIGH)
        public void onGMUserEvent(GMUserEvent event) {
            Player player;
            try {
                PermissionEventEnums.GMUser_Action.valueOf(event.getAction().name());
            }
            catch (IllegalArgumentException e) {
                return;
            }
            Resident resident = TownyUniverse.getInstance().getResident(event.getUserName());
            if (resident != null && (player = BukkitTools.getPlayerExact(resident.getName())) != null) {
                String[] modes = GroupManagerSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                GroupManagerSource.this.plugin.setPlayerMode(player, modes, false);
                GroupManagerSource.this.plugin.resetCache(player);
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onGMGroupEvent(GMGroupEvent event) {
            try {
                if (PermissionEventEnums.GMGroup_Action.valueOf(event.getAction().name()) != null) {
                    Group group = event.getGroup();
                    for (Player player : BukkitTools.getOnlinePlayers()) {
                        if (player == null || !group.toString().equals(GroupManagerSource.this.getPlayerGroup(player))) continue;
                        String[] modes = GroupManagerSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                        GroupManagerSource.this.plugin.setPlayerMode(player, modes, false);
                        GroupManagerSource.this.plugin.resetCache(player);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onGMSystemEvent(GMSystemEvent event) {
            try {
                if (PermissionEventEnums.GMSystem_Action.valueOf(event.getAction().name()) != null) {
                    for (Player player : BukkitTools.getOnlinePlayers()) {
                        if (player == null) continue;
                        String[] modes = GroupManagerSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                        GroupManagerSource.this.plugin.setPlayerMode(player, modes, false);
                        GroupManagerSource.this.plugin.resetCache(player);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected class PermissionEventEnums {
        protected PermissionEventEnums() {
        }

        public static enum GMSystem_Action {
            RELOADED,
            DEFAULT_GROUP_CHANGED;

        }

        public static enum GMGroup_Action {
            GROUP_PERMISSIONS_CHANGED,
            GROUP_INHERITANCE_CHANGED,
            GROUP_INFO_CHANGED,
            GROUP_REMOVED;

        }

        public static enum GMUser_Action {
            USER_PERMISSIONS_CHANGED,
            USER_INHERITANCE_CHANGED,
            USER_INFO_CHANGED,
            USER_GROUP_CHANGED,
            USER_SUBGROUP_CHANGED,
            USER_ADDED,
            USER_REMOVED;

        }
    }
}

