/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.statusscreens;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.adventure.text.event.HoverEvent;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Nullable;

public class StatusScreen {
    private static final int GUARANTEED_NO_WRAP_CHAT_WIDTH = 55;
    private final Map<String, Component> components = new LinkedHashMap<String, Component>();
    private final CommandSender sender;

    public StatusScreen(CommandSender sender) {
        this.sender = sender;
    }

    public CommandSender getCommandSender() {
        return this.sender;
    }

    public void addComponentOf(String name, String text) {
        this.components.put(name, TownyComponents.miniMessage(text));
    }

    public void addComponentOf(String name, Component component) {
        this.components.put(name, component);
    }

    public void addComponentOf(String name, String text, ClickEvent click) {
        this.components.put(name, TownyComponents.miniMessage(text).clickEvent(click));
    }

    public void addComponentOf(String name, String text, HoverEvent<?> hover) {
        this.components.put(name, (Component)TownyComponents.miniMessage(text).hoverEvent(hover));
    }

    public void addComponentOf(String name, String text, HoverEvent<?> hover, ClickEvent click) {
        this.components.put(name, TownyComponents.miniMessage(text).hoverEvent(hover).clickEvent(click));
    }

    public void removeStatusComponent(String name) {
        this.components.remove(name);
    }

    public Collection<String> getComponentKeys() {
        return Collections.unmodifiableCollection(this.components.keySet());
    }

    public Collection<Component> getComponents() {
        return Collections.unmodifiableCollection(this.components.values());
    }

    public boolean hasComponent(String name) {
        return this.components.containsKey(name);
    }

    @Nullable
    public Component getComponentOrNull(String name) {
        return this.components.get(name);
    }

    public boolean replaceComponent(String name, Component replacement) {
        return this.components.replace(name, replacement) != null;
    }

    public Component getFormattedStatusScreen() {
        Component screen = Component.empty();
        Component currentLine = Component.empty();
        ArrayList<Component> components = new ArrayList<Component>(this.components.values());
        for (Component nextComp : components) {
            if (nextComp.equals(Component.newline())) {
                if (!currentLine.equals(Component.empty())) {
                    screen = screen.append(currentLine);
                }
                screen = screen.append(Component.newline());
                currentLine = Component.empty();
                continue;
            }
            if (currentLine.equals(Component.empty())) {
                currentLine = nextComp;
                continue;
            }
            if (this.lineWouldBeTooLong(currentLine, nextComp)) {
                screen = screen.append(currentLine).append(Component.newline());
                currentLine = nextComp;
                continue;
            }
            currentLine = ((TextComponent)((TextComponent)Component.empty().append(currentLine)).append(Component.space())).append(nextComp);
        }
        if (!currentLine.equals(Component.empty())) {
            screen = screen.append(currentLine);
        }
        return screen;
    }

    private boolean lineWouldBeTooLong(Component line, Component comp) {
        return TownyComponents.plain(line).length() + TownyComponents.plain(comp).length() > 55;
    }
}

