/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.gui;

import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyInventory;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class PermissionGUI
extends TownyInventory {
    private final TownBlock townBlock;
    private final boolean canEdit;

    public PermissionGUI(Resident res, Inventory inv, String name, TownBlock townBlock, boolean canEdit) {
        super(res, inv, name);
        this.townBlock = townBlock;
        this.canEdit = canEdit;
    }

    public TownBlock getTownBlock() {
        return this.townBlock;
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    @Override
    public void tryPaginate(ItemStack clickedItem, Player player, Resident resident, InventoryView inventoryView) {
        int currentPage = resident.getGUIPageNum();
        try {
            if (clickedItem.getItemMeta().getDisplayName().equals("\u00a76Next")) {
                if (resident.getGUIPageNum() <= resident.getGUIPages().size() - 1) {
                    resident.setGUIPageNum(++currentPage);
                    new PermissionGUI(resident, resident.getGUIPage(), inventoryView.getTitle(), this.townBlock, this.canEdit);
                    this.playClickSound(player);
                }
            } else if (clickedItem.getItemMeta().getDisplayName().equals("\u00a76Back") && resident.getGUIPageNum() > 0) {
                resident.setGUIPageNum(--currentPage);
                new PermissionGUI(resident, resident.getGUIPage(), inventoryView.getTitle(), this.townBlock, this.canEdit);
                this.playClickSound(player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

