/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.gui;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.gui.PermissionGUI;
import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EditGUI
extends PermissionGUI {
    private final Resident editor;
    private final Resident selectedResident;

    public EditGUI(Resident res, Inventory inv, String name, TownBlock townBlock, Resident selectedResident) {
        super(res, inv, name, townBlock, true);
        this.editor = res;
        this.selectedResident = selectedResident;
    }

    public void saveChanges() {
        PermissionGUIUtil.SetPermissionType[] newTypes = new PermissionGUIUtil.SetPermissionType[4];
        Arrays.fill((Object[])newTypes, (Object)PermissionGUIUtil.SetPermissionType.UNSET);
        for (int i = 0; i < 4; ++i) {
            Material type = Optional.ofNullable(this.getInventory().getItem(PermissionGUIUtil.getWoolSlots()[i])).map(ItemStack::getType).orElse(null);
            if (type == null) continue;
            if (type == Material.LIME_WOOL) {
                newTypes[i] = PermissionGUIUtil.SetPermissionType.SET;
                continue;
            }
            if (type == Material.RED_WOOL) {
                newTypes[i] = PermissionGUIUtil.SetPermissionType.NEGATED;
                continue;
            }
            if (type != Material.GRAY_WOOL) continue;
            newTypes[i] = PermissionGUIUtil.SetPermissionType.UNSET;
        }
        if (this.getTownBlock().hasPlotObjectGroup()) {
            this.getTownBlock().getPlotObjectGroup().putPermissionOverride(this.selectedResident, new PermissionData(newTypes, this.editor.getName()));
        } else {
            this.getTownBlock().getPermissionOverrides().put(this.selectedResident, new PermissionData(newTypes, this.editor.getName()));
            this.getTownBlock().save();
        }
        Towny.getPlugin().deleteCache(this.selectedResident);
        this.exitScreen();
    }

    public void exitScreen() {
        PermissionGUIUtil.openPermissionGUI(this.editor, super.getTownBlock());
    }

    public void deleteResident() {
        if (this.getTownBlock().hasPlotObjectGroup()) {
            this.getTownBlock().getPlotObjectGroup().removePermissionOverride(this.selectedResident);
        } else {
            this.getTownBlock().getPermissionOverrides().remove(this.selectedResident);
            this.getTownBlock().save();
        }
        Towny.getPlugin().deleteCache(this.selectedResident);
        this.exitScreen();
    }
}

