/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.event.TranslationLoadEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.TranslationLoader;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class Translation {
    private static Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();
    private static Locale defaultLocale = new Locale("en", "US");
    private static Locale englishLocale = new Locale("en", "US");

    private Translation() {
    }

    public static void loadTranslationRegistry() {
        translations.clear();
        Path langFolder = Paths.get(TownyUniverse.getInstance().getRootFolder(), new String[0]).resolve("settings").resolve("lang");
        TranslationLoader loader = new TranslationLoader(langFolder, (Plugin)Towny.getPlugin(), Towny.class);
        loader.updateLegacyLangFileName(TownySettings.getString(ConfigNodes.LANGUAGE));
        loader.loadTranslationsIntoMemory();
        translations = loader.getTranslations();
        TranslationLoadEvent translationLoadEvent = new TranslationLoadEvent();
        BukkitTools.fireEvent(translationLoadEvent);
        if (!translationLoadEvent.getAddedTranslations().isEmpty()) {
            Translation.addTranslations(translationLoadEvent.getAddedTranslations());
            loader.setTranslations(translations);
        }
        loader.loadOverrideFiles();
        loader.loadGlobalFile();
        translations = loader.getTranslations();
        Translation.setDefaultLocale();
        Towny.getPlugin().getLogger().info(String.format("Successfully loaded translations for %d languages.", translations.keySet().size()));
        HelpMenu.loadMenus();
    }

    public static String of(String key) {
        if (defaultLocale == null) {
            Towny.getPlugin().getLogger().warning("Error: Tried to translate before a locale could be loaded!");
            return key;
        }
        String data = translations.get(defaultLocale.toString()).get(key.toLowerCase(Locale.ROOT));
        if (data == null && (data = (String)translations.getOrDefault(englishLocale.toString(), Collections.emptyMap()).get(key)) == null) {
            TownySettings.sendError(key.toLowerCase() + " from en_US");
            return key;
        }
        return Colors.translateColorCodes(data);
    }

    public static String of(String key, Object ... args) {
        String translated = Translation.of(key);
        try {
            return String.format(translated, args);
        }
        catch (IllegalFormatException e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "An exception occurred when formatting translation '" + translated + "' for {key=" + key + ",args=" + Arrays.toString(args) + "}, see the below error for more details", e);
            return translated;
        }
    }

    public static String of(String key, Locale locale) {
        String data = translations.get(Translation.validateLocale(locale.toString())).get(key.toLowerCase(Locale.ROOT));
        if (data == null) {
            return Translation.of(key);
        }
        return Colors.translateColorCodes(data);
    }

    public static String of(String key, Locale locale, Object ... args) {
        String translated = Translation.of(key, locale);
        try {
            return String.format(Translation.of(key, locale), args);
        }
        catch (IllegalFormatException e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "An exception occurred when formatting translation '" + translated + "' for {key=" + key + ",locale=" + locale + ",args=" + Arrays.toString(args) + "}, see the below error for more details", e);
            return translated;
        }
    }

    public static String of(String key, CommandSender sender) {
        return Translation.of(key, Translation.getLocale(sender));
    }

    public static String of(String key, CommandSender sender, Object ... args) {
        return Translation.of(key, Translation.getLocale(sender), args);
    }

    public static String of(String key, Resident resident) {
        return Translation.of(key, Translation.getLocale(resident));
    }

    public static String of(String key, Resident resident, Object ... args) {
        return Translation.of(key, Translation.getLocale(resident), args);
    }

    public static Locale toLocale(String fileName, boolean shouldWarn) {
        int lastIndex = fileName.lastIndexOf(".") == -1 ? fileName.length() : fileName.lastIndexOf(".");
        try {
            String[] locale = fileName.substring(0, lastIndex).split("[-_]");
            return new Locale(locale[0], locale[1]);
        }
        catch (Exception e) {
            if (shouldWarn) {
                Towny.getPlugin().getLogger().warning(String.format("Could not convert '%s' into a locale, falling back to en_US.", fileName));
            }
            return new Locale("en", "US");
        }
    }

    protected static void setDefaultLocale() {
        defaultLocale = Translation.loadDefaultLocale();
    }

    private static Locale loadDefaultLocale() {
        Locale locale = Translation.toLocale(TownySettings.getString(ConfigNodes.LANGUAGE), true);
        String stringLocale = locale.toString();
        if (!translations.containsKey(stringLocale)) {
            locale = new Locale("en", "US");
            Towny.getPlugin().getLogger().warning(String.format("The locale '%s' is currently not loaded, falling back to en_US. (Is it being loaded correctly?)", stringLocale));
        }
        return locale;
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    private static String validateLocale(String locale) {
        return translations.containsKey(locale) ? locale : defaultLocale.toString();
    }

    public static String translateTranslatables(CommandSender sender, Translatable ... translatables) {
        return Translation.translateTranslatables(sender, " ", translatables);
    }

    public static String translateTranslatables(CommandSender sender, String delimiter, Translatable ... translatables) {
        Locale locale = Translation.getLocale(sender);
        return Arrays.stream(translatables).map(translatable -> translatable.translate(locale)).collect(Collectors.joining(delimiter));
    }

    public static Locale getLocale(CommandSender sender) {
        return sender instanceof Player ? Translation.toLocale(((Player)sender).getLocale(), false) : defaultLocale;
    }

    public static Locale getLocaleOffline(@NotNull OfflinePlayer offlinePlayer) {
        return offlinePlayer.isOnline() ? Translation.getLocale((CommandSender)offlinePlayer.getPlayer()) : defaultLocale;
    }

    public static Locale getLocale(Resident resident) {
        return BukkitTools.isOnline(resident.getName()) ? Translation.getLocale((CommandSender)resident.getPlayer()) : defaultLocale;
    }

    public static void addTranslations(Map<String, Map<String, String>> addedTranslations) {
        if (addedTranslations != null && !addedTranslations.isEmpty()) {
            for (String language : addedTranslations.keySet()) {
                if (addedTranslations.get(language) == null || addedTranslations.get(language).isEmpty()) continue;
                language = language.replaceAll("-", "_");
                Map<String, String> newTranslations = addedTranslations.get(language);
                translations.computeIfAbsent(language, k -> new HashMap());
                for (Map.Entry<String, String> entry : newTranslations.entrySet()) {
                    translations.get(language).put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue());
                }
            }
        }
    }
}

